<?php
/*======
*
* Testimonial
*
======*/
if( !function_exists( 'eventchamp_testimonials_output' ) and !function_exists( 'eventchamp_testimonials_item_shortcode' ) ) {

	function eventchamp_testimonials_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'align' => 'left',
				'column' => '',
				'slider-space' => '',
				'slider-loop' => '',
				'slider-slide-speed' => '',
				'slider-centered-slides' => '',
				'slider-direction"' => '',
				'slider-effect' => '',
				'slider-free-mode' => '',
				'pagination' => '',
			), $atts
		);

		/*====== Column ======*/
		if( empty( $atts["column"] ) ) {

			$atts["column"] = "1";

		}

		/*====== Column Space ======*/
		if( empty( $atts["slider-space"] ) ) {

			$atts["slider-space"] = "30";

		}

		/*====== Slider Loop ======*/
		if( empty( $atts["slider-loop"] ) ) {

			$atts["slider-loop"] = "false";

		}

		/*====== Slider Slide Speed ======*/
		if( empty( $atts["slider-slide-speed"] ) ) {

			$atts["slider-slide-speed"] = "1000";

		}

		/*====== Centered Slides ======*/
		if( empty( $atts["slider-centered-slides"] ) ) {

			$atts["slider-centered-slides"] = "false";

		}

		/*====== Slider Direction ======*/
		if( empty( $atts["slider-direction"] ) ) {

			$atts["slider-direction"] = "horizontal";

		}

		/*====== Slider Effect ======*/
		if( empty( $atts["slider-effect"] ) ) {

			$atts["slider-effect"] = "slide";

		}

		/*====== Slider Free Mode ======*/
		if( empty( $atts["slider-free-mode"] ) ) {

			$atts["slider-free-mode"] = "false";

		}

		/*====== Pagination ======*/
		if( empty( $atts["pagination"] ) ) {

			$atts["pagination"] = "false";

		}

		/*====== HTML Output ======*/
		$output = '';

		$output .= '<div class="gt-testimonials-carousel gt-align-' . esc_attr( $atts["align"] ) . '">';
			$output .= '<div class="swiper-container gt-swiper-slider" data-gt-item="' . esc_attr( $atts["column"] ) . '" data-gt-item-space="' . esc_attr( $atts["slider-space"] ) . '" data-gt-loop="' . esc_attr( $atts["slider-loop"] ) . '" data-gt-speed="' . esc_attr( $atts["slider-slide-speed"] ) . '" data-gt-direction="' . esc_attr( $atts["slider-direction"] ) . '" data-gt-effect="' . esc_attr( $atts["slider-effect"] ) . '" data-gt-centered-slides="' . esc_attr( $atts["slider-centered-slides"] ) . '" data-gt-free-mode="' . esc_attr( $atts["slider-free-mode"] ) . '">';
				$output .= '<div class="swiper-wrapper">';
					$output .= do_shortcode( $content );
				$output .= '</div>';

				if( $atts["pagination"] == "true" ) {

					$output .= '<div class="swiper-pagination gt-slider-pagination"></div>';

				}

			$output .= '</div>';
		$output .= '</div>';

		return $output;

	}
	add_shortcode( "eventchamp_testimonials", "eventchamp_testimonials_output" );

	function eventchamp_testimonials_item_shortcode( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'image' => '',
				'name' => '',
				'text' => '',
				'slider-autoplay' => '',
				'slider-autoplay-delay' => '',
			), $atts
		);

		/*====== Slide Autoplay ======*/
		if( empty( $atts["slider-autoplay"] ) ) {

			$atts["slider-autoplay"] = "false";

		}

		/*====== Slide Autoplay Delay ======*/
		if( empty( $atts["slider-autoplay-delay"] ) ) {

			$atts["slider-autoplay-delay"] = "15000";

		}

		/*====== HTML Output ======*/
		$output = '';

		if( !empty( $atts["name"] ) or !empty( $atts["text"] ) ) {

			if( $atts["slider-autoplay"] == "true" ) {

				$output .= '<div class="swiper-slide" data-swiper-autoplay="' . esc_attr( $atts["slider-autoplay-delay"] ) . '">';

			} else {

				$output .= '<div class="swiper-slide">';

			}

				if( !empty( $atts["image"] ) ) {

					$output .= '<div class="gt-image">';
						$output .= wp_get_attachment_image( esc_attr( $atts["image"] ), 'thumbnail', true, array( "alt" => $atts["name"] ) );
					$output .= '</div>';

				}

				if( !empty( $atts["name"] ) ) {

					$output .= '<div class="gt-name">' . esc_attr( $atts["name"] ) . '</div>';

				}

				if( !empty( $atts["text"] ) ) {

					$output .= '<div class="gt-content">';
						$output .= wpautop( esc_attr( $atts["text"] ) );
					$output .= '</div>';

				}

			$output .= '</div>';

		}

		return $output;

	}
	add_shortcode( "eventchamp_testimonials_item", "eventchamp_testimonials_item_shortcode" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Testimonials Carousel', 'eventchamp-core' ),
				"base" => "eventchamp_testimonials",
				"as_parent" => array( 'only' => 'eventchamp_testimonials_item' ),
				"js_view" => "VcColumnView",
				"content_element" => true,
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/testimonials-carousel.jpg',
				"description" => esc_html__( 'Create a testimonials carousel', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "dropdown",
						"param_name" => "align",
						"heading" => esc_html__( 'Align', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Left', 'eventchamp-core' ) => 'left',
							esc_html__( 'Center', 'eventchamp-core' ) => 'center',
							esc_html__( 'Right', 'eventchamp-core' ) => 'right',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "column",
						"heading" => esc_html__( 'Column', 'eventchamp-core' ),
						'admin_label' => true,
						'save_always' => true,
						"value" => array(
							esc_html__( '1 Column', 'eventchamp-core' ) => '1',
							esc_html__( '2 Column', 'eventchamp-core' ) => '2',
							esc_html__( '3 Column', 'eventchamp-core' ) => '3',
							esc_html__( '4 Column', 'eventchamp-core' ) => '4',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-space",
						"heading" => esc_html__( 'Column Space', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( '0', 'eventchamp-core' ) => '0',
							esc_html__( '1', 'eventchamp-core' ) => '1',
							esc_html__( '2', 'eventchamp-core' ) => '2',
							esc_html__( '3', 'eventchamp-core' ) => '3',
							esc_html__( '4', 'eventchamp-core' ) => '4',
							esc_html__( '5', 'eventchamp-core' ) => '5',
							esc_html__( '10', 'eventchamp-core' ) => '10',
							esc_html__( '15', 'eventchamp-core' ) => '15',
							esc_html__( '20', 'eventchamp-core' ) => '20',
							esc_html__( '25', 'eventchamp-core' ) => '25',
							esc_html__( '30', 'eventchamp-core' ) => '30',
							esc_html__( '45', 'eventchamp-core' ) => '45',
							esc_html__( '50', 'eventchamp-core' ) => '50',
							esc_html__( '55', 'eventchamp-core' ) => '55',
							esc_html__( '60', 'eventchamp-core' ) => '60',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-loop",
						"heading" => esc_html__( 'Loop', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "slider-slide-speed",
						"heading" => esc_html__( 'Slide Speed', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: 1500', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-centered-slides",
						"heading" => esc_html__( 'Centered Slides', 'eventchamp-core' ),
						"description" => esc_html__( 'If you choose true, then active slide will be centered, not always on the left side.', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-direction",
						"heading" => esc_html__( 'Slider Direction', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Horizontal', 'eventchamp-core' ) => 'horizontal',
							esc_html__( 'Vertical', 'eventchamp-core' ) => 'vertical',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-effect",
						"heading" => esc_html__( 'Slider Effect', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Slide', 'eventchamp-core' ) => 'slide',
							esc_html__( 'Fade', 'eventchamp-core' ) => 'fade',
							esc_html__( 'Cube', 'eventchamp-core' ) => 'cube',
							esc_html__( 'Coverflow', 'eventchamp-core' ) => 'coverflow',
							esc_html__( 'Flip', 'eventchamp-core' ) => 'flip',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-free-mode",
						"heading" => esc_html__( 'Free Mode', 'eventchamp-core' ),
						"description" => esc_html__( 'If true then slides will not have fixed positions', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "pagination",
						"heading" => esc_html__( 'Pagination', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
				)
			)
		);

	}

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Testimonials Carousel Item', 'eventchamp-core' ),
				"base" => "eventchamp_testimonials_item",
				"as_child" => array( 'only' => 'eventchamp_testimonials' ),
				"content_element" => true,
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/testimonials-carousel.jpg',
				"params" => array(
					array(
						"type" => "attach_image",
						"param_name" => "image",
						"heading" => esc_html__( 'Image', 'eventchamp-core' ),
						"description" => esc_html__( 'Recommended size: 110x110', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "name",
						"heading" => esc_html__( 'Name', 'eventchamp-core' ),
						"admin_label" => true,
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "text",
						"heading" => esc_html__( 'Content', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-autoplay",
						"heading" => esc_html__( 'Slide Autoplay', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "slider-autoplay-delay",
						"heading" => esc_html__( 'Slide Autoplay Delay', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: 15000', 'eventchamp-core' ),
						'save_always' => true,
					),
				)
			)
		);

	}

	if( class_exists( 'WPBakeryShortCodesContainer' ) ) {

		class WPBakeryShortCode_eventchamp_testimonials extends WPBakeryShortCodesContainer {}

	}

}