<?php
/*======
*
* Tags
*
======*/
if( !function_exists( 'eventchamp_post_type_tags_output' ) ) {

	function eventchamp_post_type_tags_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'style' => '1',
				'align' => 'center',
				'post-type' => 'post',
				'count' => '',
				'include-tags' => '',
				'exclude-tags' => '',
				'order' => 'ASC',
				'order-type' => 'name',
				'empty-tags' => 'false',
				'childless' => 'false',
				'hide-children' => 'false',
				'show-count' => 'false',
			), $atts
		);

		/*====== Taxonomy ======*/
		if( $atts["post-type"] == "post" ) {

			$taxonomy = "post_tag";

		} elseif( $atts["post-type"] == "event" ) {

			$taxonomy = "event_tags";

		} elseif( $atts["post-type"] == "venue" ) {

			$taxonomy = "venue_tags";

		} elseif( $atts["post-type"] == "speaker" ) {

			$taxonomy = "speaker-tags";

		}

		/*====== Include Tags ======*/
		if( !empty( $atts['include-tags'] ) ) {

			$include_tags = $atts['include-tags'];
			$include_tags = explode( ',', $include_tags );

		} else {

			$include_tags = "";

		}

		/*====== Exclude Tags ======*/
		if( !empty( $atts['exclude-tags'] ) ) {

			$exclude_tags = $atts['exclude-tags'];
			$exclude_tags = explode( ',', $exclude_tags );

		} else {

			$exclude_tags = "";

		}

		/*====== Order ======*/
		if( empty( $atts["order"] ) ) {

			$atts["order"] = "ASC";

		}

		/*====== Order Type ======*/
		if( empty( $atts["order-type"] ) ) {

			$atts["order-type"] = "name";

		}

		/*====== Empty Tags ======*/
		if( $atts['empty-tags'] == 'false' ) {

			$empty_tags = false;

		} else {

			$empty_tags = true;

		}

		/*====== Childless ======*/
		if( $atts['childless'] == 'false' ) {

			$childless = false;

		} else {

			$childless = true;

		}

		/*====== Hide Children ======*/
		if( $atts['hide-children'] == 'false' ) {

			$hide_children = '';

		} else {

			$hide_children = 0;

		}

		/*====== Query ======*/
		$tags = get_terms(
			array(
				'taxonomy' => $taxonomy,
				'number' => $atts["count"],
				'include' => $include_tags,
				'exclude' => $exclude_tags,
				'order' => $atts["order"],
				'orderby' => $atts["order-type"],
				'hide_empty' => $empty_tags,
				'childless' => $childless,
				'parent' => $hide_children,
			)
		);

		/*====== HTML Output ======*/
		$output = "";

		if( !empty( $tags ) ) {

			$output .= '<div class="gt-tags gt-style-' . esc_attr( $atts["style"] ) . ' gt-align-' . esc_attr( $atts["align"] ) . '">';
				$output .= '<ul>';

					foreach( $tags as $tag ) {

						if( !empty( $tag ) ) {

							$output .= '<li>';
								$output .= '<a href="' . esc_url( get_term_link( $tag->term_id ) . '?post_type=' . esc_attr( $atts["post-type"] ) ) . '">';
									$output .= esc_attr( $tag->name );

									if( $atts["show-count"] == "true" ) {

										$output .= ' (' . eventchamp_taxonomy_post_count( $cat_id = esc_attr( $tag->term_id ), $taxonomy = esc_attr( $taxonomy ) ) . ')';

									}

								$output .= '</a>';
							$output .= '</li>';

						}

					}

				$output .= '</ul>';
			$output .= '</div>';

		}

		return $output;

	}
	add_shortcode( "eventchamp_post_type_tags", "eventchamp_post_type_tags_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Tags', 'eventchamp-core' ),
				"base" => "eventchamp_post_type_tags",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/tags.jpg',
				"description" => esc_html__( 'List the tags', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "dropdown",
						"param_name" => "style",
						"heading" => esc_html__( 'Style', 'eventchamp-core' ),
						"admin_label" => true,
						"save_always" => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => '1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => '2',
							esc_html__( 'Style 3', 'eventchamp-core' ) => '3',
							esc_html__( 'Style 4', 'eventchamp-core' ) => '4',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "align",
						"heading" => esc_html__( 'Align', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Left', 'eventchamp-core' ) => 'left',
							esc_html__( 'Center', 'eventchamp-core' ) => 'center',
							esc_html__( 'Right', 'eventchamp-core' ) => 'right',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "post-type",
						"heading" => esc_html__( 'Post Type', 'eventchamp-core' ),
						"admin_label" => true,
						"save_always" => true,
						"value" => array(
							esc_html__( 'Post Tags', 'eventchamp-core' ) => 'post',
							esc_html__( 'Event Tags', 'eventchamp-core' ) => 'event',
							esc_html__( 'Venue Tags', 'eventchamp-core' ) => 'venue',
							esc_html__( 'Speaker Tags', 'eventchamp-core' ) => 'speaker',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "count",
						"heading" => esc_html__( 'Count', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-tags",
						"heading" => esc_html__( 'Exclude Tags', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-tags",
						"heading" => esc_html__( 'Include Tags', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "order",
						"heading" => esc_html__( 'Order', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'ASC', 'eventchamp-core' ) => 'ASC',
							esc_html__( 'DESC', 'eventchamp-core' ) => 'DESC',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "order-type",
						"heading" => esc_html__( 'Order Type', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Name', 'eventchamp-core' ) => 'name',
							esc_html__( 'Slug', 'eventchamp-core' ) => 'slug',
							esc_html__( 'Term Group', 'eventchamp-core' ) => 'term_group',
							esc_html__( 'Term ID', 'eventchamp-core' ) => 'term_id',
							esc_html__( 'ID', 'eventchamp-core' ) => 'id',
							esc_html__( 'Description', 'eventchamp-core' ) => 'description',
							esc_html__( 'Parent', 'eventchamp-core' ) => 'parent',
							esc_html__( 'Count', 'eventchamp-core' ) => 'count',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "empty-tags",
						"heading" => esc_html__( 'Empty Tags', 'eventchamp-core' ),
						"description" => esc_html__( 'If you choose true option empty tags will be hide.', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "childless",
						"heading" => esc_html__( 'Childless', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "hide-children",
						"heading" => esc_html__( 'Hide Children', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "show-count",
						"heading" => esc_html__( 'Show Count', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
				),
			)
		);

	}

}