<?php
/*======
*
* Sponsors
*
======*/
if( !function_exists( 'eventchamp_sponsors_output' ) ) {

	function eventchamp_sponsors_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'style' => '1',
				'column' => '1',
				'column-space' => '0',
				'sponsors' => '',
			), $atts
		);

		/*====== Lazy Load ======*/
		$lazy_load = ot_get_option( 'lazy-load', 'off' );

		/*====== Sponsors ======*/
		$sponsors = vc_param_group_parse_atts( $atts['sponsors'] );

		/*====== HTML Output ======*/
		$output = "";

		if( !empty( $sponsors ) ) {

			$output .= '<div class="gt-event-sponsors gt-type-1 gt-style-' . esc_attr( $atts["style"] ) . '">';
				$output .= '<div class="gt-columns gt-column-space-' . esc_attr( $atts["column-space"] ) . ' gt-column-' . esc_attr( $atts["column"] ) . '">';

					foreach( $sponsors as $sponsor ) {

						if( !empty( $sponsor ) ) {

							if( !empty( $sponsor["logo"] ) ) {

								$output .= '<div class="gt-col">';
									$output .= '<div class="gt-inner">';
										$output .= '<div class="gt-logo">';
										
											if( $sponsor["link-status"] == "true" ) {

												$link = $sponsor["link"];
												$link = vc_build_link( $link );

												if( !empty( $sponsor["link"] ) ) {

													if( !empty( $link["target"] ) ) {

														$link_target = $link["target"];

													} else {

														$link_target = "_parent";

													}

													$output .= '<a href="' . esc_url( $link["url"] ) . '" target="' . esc_attr( $link_target ) . '">';

												}

											}

												if( $lazy_load == "on" ) {

													$output .= '<img data-src="' . esc_url( wp_get_attachment_image_src( esc_attr( $sponsor["logo"] ), 'eventchamp-event-sponsor-big' )[0] ) . '" class="gt-grayscale-' . esc_attr( $sponsor["grayscale"] ) . ' gt-lazy-load" alt="' . esc_attr( $sponsor["text"] ) . '">';

												} else {

													$output .= '<img src="' . esc_url( wp_get_attachment_image_src( esc_attr( $sponsor["logo"] ), 'eventchamp-event-sponsor-big' )[0] ) . '" class="gt-grayscale-' . esc_attr( $sponsor["grayscale"] ) . '" alt="' . esc_attr( $sponsor["text"] ) . '">';

												}

												if( !empty( $sponsor["text"] ) ) {

													$output .= '<span>' . esc_attr( $sponsor["text"] ) . '</span>';

												}

											if( $sponsor["link-status"] == "true" ) {

												$link = $sponsor["link"];
												$link = vc_build_link( $link );

												if( !empty( $sponsor["link"] ) ) {

													$output .= '</a>';

												}

											}

										$output .= '</div>';
									$output .= '</div>';
								$output .= '</div>';

							}

						}

					}

				$output .= '</div>';
			$output .= '</div>';

		}

		return $output;

	}
	add_shortcode( "eventchamp_sponsors", "eventchamp_sponsors_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Sponsors', 'eventchamp-core' ),
				"base" => "eventchamp_sponsors",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/sponsors.jpg',
				"description" => esc_html__( 'List the sponsors', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "dropdown",
						"param_name" => "style",
						"heading" => esc_html__( 'Style', 'eventchamp-core' ),
						"admin_label" => true,
						"save_always" => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => '1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => '2',
							esc_html__( 'Style 3', 'eventchamp-core' ) => '3',
							esc_html__( 'Style 4', 'eventchamp-core' ) => '4',
							esc_html__( 'Style 5', 'eventchamp-core' ) => '5',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "column",
						"heading" => esc_html__( 'Column', 'eventchamp-core' ),
						"admin_label" => true,
						"save_always" => true,
						"value" => array(
							esc_html__( '1 Column', 'eventchamp-core' ) => '1',
							esc_html__( '2 Column', 'eventchamp-core' ) => '2',
							esc_html__( '3 Column', 'eventchamp-core' ) => '3',
							esc_html__( '4 Column', 'eventchamp-core' ) => '4',
							esc_html__( '5 Column', 'eventchamp-core' ) => '5',
							esc_html__( '6 Column', 'eventchamp-core' ) => '6',
							esc_html__( '7 Column', 'eventchamp-core' ) => '7',
							esc_html__( '8 Column', 'eventchamp-core' ) => '8',
							esc_html__( '9 Column', 'eventchamp-core' ) => '9',
							esc_html__( '10 Column', 'eventchamp-core' ) => '10',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "column-space",
						"heading" => esc_html__( 'Column Space', 'eventchamp-core' ),
						"admin_label" => true,
						"save_always" => true,
						"value" => array(
							esc_html__( '0', 'eventchamp-core' ) => '0',
							esc_html__( '5', 'eventchamp-core' ) => '5',
							esc_html__( '10', 'eventchamp-core' ) => '10',
							esc_html__( '15', 'eventchamp-core' ) => '15',
							esc_html__( '20', 'eventchamp-core' ) => '20',
							esc_html__( '25', 'eventchamp-core' ) => '25',
							esc_html__( '30', 'eventchamp-core' ) => '30',
							esc_html__( '35', 'eventchamp-core' ) => '35',
							esc_html__( '40', 'eventchamp-core' ) => '40',
							esc_html__( '45', 'eventchamp-core' ) => '45',
							esc_html__( '50', 'eventchamp-core' ) => '50',
							esc_html__( '55', 'eventchamp-core' ) => '55',
							esc_html__( '60', 'eventchamp-core' ) => '60',
						),
					),
					array(
						'type' => 'param_group',
						'param_name' => 'sponsors',
						"heading" => esc_html__( 'Clients', 'eventchamp-core' ),
						"save_always" => true,
						'params' => array(
							array(
								"type" => "attach_image",
								"param_name" => "logo",
								"heading" => esc_html__( 'Logo', 'eventchamp-core' ),
								"description" => esc_html__( 'Recommended size: 540x540', 'eventchamp-core' ),
								"admin_label" => true,
								"save_always" => true,
							),
							array(
								"type" => "textfield",
								"param_name" => "text",
								"heading" => esc_html__( 'Text', 'eventchamp-core' ),
								"admin_label" => true,
								"save_always" => true,
							),
							array(
								"type" => "dropdown",
								"param_name" => "grayscale",
								"heading" => esc_html__( 'Grayscale', 'eventchamp-core' ),
								"save_always" => true,
								"value" => array(
									esc_html__( 'False', 'eventchamp-core' ) => 'false',
									esc_html__( 'True', 'eventchamp-core' ) => 'true',
								),
							),
							array(
								"type" => "dropdown",
								"param_name" => "link-status",
								"heading" => esc_html__( 'Link Status', 'eventchamp-core' ),
								"save_always" => true,
								"value" => array(
									esc_html__( 'False', 'eventchamp-core' ) => 'false',
									esc_html__( 'True', 'eventchamp-core' ) => 'true',
								),
							),
							array(
								"type" => "vc_link",
								"param_name" => "link",
								"heading" => esc_html__( 'Link', 'eventchamp-core' ),
								"save_always" => true,
							),
						)
					),
				),
			)
		);

	}

}