<?php
/*======
*
* Speaker Listing
*
======*/
if( !function_exists( 'eventchamp_speakers_list_grid_output' ) ) {

	function eventchamp_speakers_list_grid_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'speakercount' => '',
				'speakerids' => '',
				'excludespeakers' => '',
				'offset' => '',
				'ordertype' => '',
				'sortby' => '',
				'pagination' => '',
				'style' => '1',
				'column' => '',
				'column-space' => '0',
				'profession' => 'false',
				'company' => 'false',
				'short-biography' => 'false',
				'social-links' => 'false',
			), $atts
		);

		/*====== Column ======*/
		if( $atts["column"] ) {

			$column = esc_attr( $atts["column"] );

		} else {

			$column = "column-1";

		}

		/*====== Main Query ======*/
		$arg = array(
			'post_status' => 'publish',
			'post_type' => 'speaker',
		);

		/*====== Pagination ======*/
		$paged = is_front_page() ? get_query_var( 'page', 1 ) : get_query_var( 'paged', 1 );

		if( empty( $paged ) ) {

			$paged = 1;

		}

		if( !empty( $paged ) ) {

			$extra_query = array(
				'paged' => $paged,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Include Speakers ======*/
		if( !empty( $atts['speakerids'] ) ) {

			$speakerids = $atts['speakerids'];
			$include_speakers = explode( ',', $speakerids );

		} else {

			$include_speakers = "";

		}

		if( !empty( $include_speakers ) ) {

			$extra_query = array(
				'post__in' => $include_speakers,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Speaker Count ======*/
		if( !empty( $atts["speakercount"] ) ) {

			$extra_query = array(
				'posts_per_page' => $atts["speakercount"],
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Offset ======*/
		if( !empty( $atts["offset"] ) ) {

			$extra_query = array(
				'offset' => $atts["offset"],
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Exclude Speakers ======*/
		$excludespeakers = $atts['excludespeakers'];

		if( !empty( $excludespeakers ) ) {

			$exclude_speakers = $excludespeakers;
			$exclude_speakers = explode( ',', $exclude_speakers );

		} else {

			$exclude_speakers = array();

		}


		if( !empty( $exclude_speakers ) ) {

			$extra_query = array(
				'post__not_in' => $exclude_speakers,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Order & Order By ======*/
		if( $atts["ordertype"] == "ASC" ) {

			$order = "ASC";

		} else {

			$order = "DESC";

		}

		if( !empty( $order ) ) {

			$extra_query = array(
				'order' => $order,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		if( $atts["sortby"] == "popular-comment" ) {

			$order_by = "comment_count";

		} elseif( $atts["sortby"] == "id" ) {

			$order_by = "ID";

		} elseif( $atts["sortby"] == "popular" ) {

			$order_by = "comment_count";

		} elseif( $atts["sortby"] == "title" ) {

			$order_by = "title";

		} elseif( $atts["sortby"] == "menu_order" ) {

			$order_by = "menu_order";

		} elseif( $atts["sortby"] == "rand" ) {

			$order_by = "rand";

		} elseif( $atts["sortby"] == "post__in" ) {

			$order_by = "post__in";

		} elseif( $atts["sortby"] == "none" ) {

			$order_by = "none";

		} else {

			$order_by = "date";

		}

		if( !empty( $order_by ) ) {

			$extra_query = array(
				'orderby' => $order_by,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== HTML Output ======*/
		$output = "";

		$wp_query = new WP_Query( $arg );

		if( !empty( $wp_query ) ) {

			if( $wp_query->have_posts() ) {

				$output .= '<div class="gt-speakers-listing gt-style-1">';
					$output .= '<div class="gt-columns gt-' . esc_attr( $column ) . ' gt-column-space-' . esc_attr( $atts["column-space"] ) . '">';

						while( $wp_query->have_posts() ) {

							$wp_query->the_post();

							$output .= '<div class="gt-col">';
								$output .= '<div class="gt-inner">';

									if( $atts["style"] == "1" ) {

										$output .= eventchamp_speaker_style_1( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["profession"] ), $company = esc_attr( $atts["company"] ), $summary = esc_attr( $atts["short-biography"] ), $social = esc_attr( $atts["social-links"] ) );

									} elseif( $atts["style"] == "2" ) {

										$output .= eventchamp_speaker_style_2( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["profession"] ), $company = esc_attr( $atts["company"] ), $summary = esc_attr( $atts["short-biography"] ), $social = esc_attr( $atts["social-links"] ) );

									} elseif( $atts["style"] == "3" ) {

										$output .= eventchamp_speaker_style_3( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["profession"] ), $company = esc_attr( $atts["company"] ), $summary = esc_attr( $atts["short-biography"] ), $social = esc_attr( $atts["social-links"] ) );

									} elseif( $atts["style"] == "4" ) {

										$output .= eventchamp_speaker_style_4( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["profession"] ), $company = esc_attr( $atts["company"] ), $summary = esc_attr( $atts["short-biography"] ), $social = esc_attr( $atts["social-links"] ) );

									} elseif( $atts["style"] == "5" ) {

										$output .= eventchamp_speaker_style_5( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["profession"] ), $company = esc_attr( $atts["company"] ), $summary = esc_attr( $atts["short-biography"] ), $social = esc_attr( $atts["social-links"] ) );

									} elseif( $atts["style"] == "6" ) {

										$output .= eventchamp_speaker_style_6( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["profession"] ), $company = esc_attr( $atts["company"] ), $summary = esc_attr( $atts["short-biography"] ), $social = esc_attr( $atts["social-links"] ) );

									} elseif( $atts["style"] == "7" ) {

										$output .= eventchamp_speaker_style_7( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["profession"] ), $company = esc_attr( $atts["company"] ), $summary = esc_attr( $atts["short-biography"] ), $social = esc_attr( $atts["social-links"] ) );

									} elseif( $atts["style"] == "8" ) {

										$output .= eventchamp_speaker_style_8( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["profession"] ), $company = esc_attr( $atts["company"] ), $summary = esc_attr( $atts["short-biography"] ), $social = esc_attr( $atts["social-links"] ) );

									}

								$output .= '</div>';
							$output .= '</div>';

						}

					$output .= '</div>';

					if( $atts['pagination'] == 'true' ) {

						$output .= eventchamp_element_pagination( $paged = $paged, $query = $wp_query );

					}

				$output .= '</div>';

			}

		}
		wp_reset_postdata();

		return $output;

	}
	add_shortcode( "eventchamp_speakers_list_grid", "eventchamp_speakers_list_grid_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Speaker Listing', 'eventchamp-core' ),
				"base" => "eventchamp_speakers_list_grid",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/speakers-listing.jpg',
				"description" => esc_html__( 'List the speakers', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "textfield",
						"param_name" => "speakercount",
						"heading" => esc_html__( 'Count', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "speakerids",
						"heading" => esc_html__( 'Include Speakers', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "excludespeakers",
						"heading" => esc_html__( 'Exclude Speakers', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "offset",
						"heading" => esc_html__( 'Offset', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "ordertype",
						"heading" => esc_html__( 'Order', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'ASC', 'eventchamp-core' ) => 'ASC',
							esc_html__( 'DESC', 'eventchamp-core' ) => 'DESC',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "sortby",
						"heading" => esc_html__( 'Order Type', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'admin_label' => true,
						"save_always" => true,
						"value" => array(
							esc_html__( 'Added Date', 'eventchamp-core' ) => 'added-date',
							esc_html__( 'Popular by Comment', 'eventchamp-core' ) => 'popular-comment',
							esc_html__( 'ID', 'eventchamp-core' ) => 'id',
							esc_html__( 'Title', 'eventchamp-core' ) => 'title',
							esc_html__( 'Menu Order', 'eventchamp-core' ) => 'menu_order',
							esc_html__( 'Random', 'eventchamp-core' ) => 'rand',
							esc_html__( 'By Include IDs', 'eventchamp-core' ) => 'post__in',
							esc_html__( 'None', 'eventchamp-core' ) => 'none',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "pagination",
						"heading" => esc_html__( 'Pagination', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "style",
						"heading" => esc_html__( 'Style', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'admin_label' => true,
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => '1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => '2',
							esc_html__( 'Style 3', 'eventchamp-core' ) => '3',
							esc_html__( 'Style 4', 'eventchamp-core' ) => '4',
							esc_html__( 'Style 5', 'eventchamp-core' ) => '5',
							esc_html__( 'Style 6', 'eventchamp-core' ) => '6',
							esc_html__( 'Style 7', 'eventchamp-core' ) => '7',
							esc_html__( 'Style 8', 'eventchamp-core' ) => '8',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "column",
						"heading" => esc_html__( 'Column', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'admin_label' => true,
						'save_always' => true,
						"value" => array(
							esc_html__( '1 Column', 'eventchamp-core' ) => 'column-1',
							esc_html__( '2 Column', 'eventchamp-core' ) => 'column-2',
							esc_html__( '3 Column', 'eventchamp-core' ) => 'column-3',
							esc_html__( '4 Column', 'eventchamp-core' ) => 'column-4',
							esc_html__( '5 Column', 'eventchamp-core' ) => 'column-5',
							esc_html__( '6 Column', 'eventchamp-core' ) => 'column-6',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "column-space",
						"heading" => esc_html__( 'Column Space', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( '0', 'eventchamp-core' ) => '0',
							esc_html__( '5', 'eventchamp-core' ) => '5',
							esc_html__( '10', 'eventchamp-core' ) => '10',
							esc_html__( '15', 'eventchamp-core' ) => '15',
							esc_html__( '20', 'eventchamp-core' ) => '20',
							esc_html__( '25', 'eventchamp-core' ) => '25',
							esc_html__( '30', 'eventchamp-core' ) => '30',
							esc_html__( '35', 'eventchamp-core' ) => '35',
							esc_html__( '40', 'eventchamp-core' ) => '40',
							esc_html__( '45', 'eventchamp-core' ) => '45',
							esc_html__( '50', 'eventchamp-core' ) => '50',
							esc_html__( '55', 'eventchamp-core' ) => '55',
							esc_html__( '60', 'eventchamp-core' ) => '60',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "profession",
						"heading" => esc_html__( 'Profession', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "company",
						"heading" => esc_html__( 'Company', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "short-biography",
						"heading" => esc_html__( 'Short Biography', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "social-links",
						"heading" => esc_html__( 'Social Links', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
				),
			)
		);

	}

}