<?php
/*======
*
* Social Links
*
======*/
if( !function_exists( 'eventchamp_social_links_element_output' ) ) {

	function eventchamp_social_links_element_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'style' => '',
			), $atts
		);

		/*====== HTML Output ======*/
		$output = "";

		$output .= '<div class="gt-social-links-element gt-style-' . esc_attr( $atts["style"] ) . '">';
			$output .= eventchamp_social_media_sites();
		$output .= '</div>';

		return $output;

	}
	add_shortcode( "eventchamp_social_links_element", "eventchamp_social_links_element_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Social Links', 'eventchamp-core' ),
				"base" => "eventchamp_social_links_element",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/social-links.jpg',
				"description" => esc_html__( 'List the social media links', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "dropdown",
						"param_name" => "style",
						"heading" => esc_html__( 'Style', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => '1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => '2',
							esc_html__( 'Style 3', 'eventchamp-core' ) => '3',
							esc_html__( 'Style 4', 'eventchamp-core' ) => '4',
							esc_html__( 'Style 5', 'eventchamp-core' ) => '5',
							esc_html__( 'Style 6', 'eventchamp-core' ) => '6',
							esc_html__( 'Style 7', 'eventchamp-core' ) => '7',
						),
					),
				),
			)
		);

	}

}