<?php
/*======
*
* Service Box
*
======*/
if( !function_exists( 'eventchamp_service_box_output' ) ) {

	function eventchamp_service_box_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'style' => 'style-1',
				'title' => '',
				'text' => '',
				'icon' => '',
				'svg-icon' => '',
				'servicelink' => '',
				'align' => 'left',
			), $atts
		);
		
		/*====== HTML Output ======*/
		$output = '';

		if( !empty( $atts["title"] ) or !empty( $atts["text"] ) ) {

			$output .= '<div class="gt-eventchamp-service-box gt-' . esc_attr( $atts["style"] ) . ' gt-align-' . esc_attr( $atts["align"] ) . '">';

				if( !empty( $atts["icon"] ) ) {

					if( !empty( $atts["servicelink"] ) ) {

						$href = $atts["servicelink"];
						$href = vc_build_link( $href );

						if( !empty( $href["target"] ) ) {

							$target = $href["target"];

						} else {

							$target = "_parent";

						}

						if( !empty( $href["url"] ) ) {

							$output .= '<div class="gt-icon">';
								$output .= '<a href="' . esc_url( $href["url"] ) . '" target="' . esc_attr( $target ) . '"></a>';
								$output .= '<i class="' . esc_attr( $atts["icon"] ) . '"></i>';
							$output .= '</div>';

						}

					} else {

						$output .= '<div class="gt-icon">';
							$output .= '<i class="' . esc_attr( $atts["icon"] ) . '"></i>';
						$output .= '</div>';

					}

				} elseif( !empty( $atts["svg-icon"] ) ) {

					if( !empty( $atts["servicelink"] ) ) {

						$href = $atts["servicelink"];
						$href = vc_build_link( $href );

						if( !empty( $href["target"] ) ) {

							$target = $href["target"];

						} else {

							$target = "_parent";

						}

						if( !empty( $href["url"] ) ) {

							$output .= '<div class="gt-icon">';
								$output .= '<a href="' . esc_url( $href["url"] ) . '" target="' . esc_attr( $target ) . '"></a>';
								$output .= rawurldecode( base64_decode( $atts["svg-icon"] ) );
							$output .= '</div>';

						}

					} else {

						$output .= '<div class="gt-icon">';
							$output .= rawurldecode( base64_decode( $atts["svg-icon"] ) );
						$output .= '</div>';

					}

				}

					if( !empty( $atts["title"] ) ) {

						if( !empty( $atts["servicelink"] ) ) {

							$href = $atts["servicelink"];
							$href = vc_build_link( $href );

							if( !empty( $href["target"] ) ) {

								$target = $href["target"];

							} else {

								$target = "_parent";

							}

							if( !empty( $href["url"] ) ) {

								$output .= '<div class="gt-title">';
									$output .= '<a href="' . esc_url( $href["url"] ) . '" target="' . esc_attr( $target ) . '" class="button-link">' . esc_attr( $atts["title"] ) . '</a>';
								$output .= '</div>';

							}

						} else {

							$output .= '<div class="gt-title">' . esc_attr( $atts["title"] ) . '</div>';

						}

					}

				if( !empty( $atts["text"] ) ) {

					$output .= wpautop( esc_attr( $atts["text"] ) );

				}

			$output .= '</div>';

		}

		return $output;

	}
	add_shortcode( "eventchamp_service_box", "eventchamp_service_box_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Service Box', 'eventchamp-core' ),
				"base" => "eventchamp_service_box",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/service-box.jpg',
				"description" => esc_html__( 'Simple but useful service box', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "dropdown",
						"param_name" => "style",
						"heading" => esc_html__( 'Style', 'eventchamp-core' ),
						"admin_label" => true,
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => 'style-1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => 'style-2',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "align",
						"heading" => esc_html__( 'Align', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Left', 'eventchamp-core' ) => 'left',
							esc_html__( 'Center', 'eventchamp-core' ) => 'center',
							esc_html__( 'Right', 'eventchamp-core' ) => 'right',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "title",
						"heading" => esc_html__( 'Title', 'eventchamp-core' ),
						"admin_label" => true,
						"save_always" => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "text",
						"heading" => esc_html__( 'Text', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "icon",
						"heading" => esc_html__( 'Icon', 'eventchamp-core' ),
						"description" => esc_html__( 'If you want to use SVG icon, enter blank it. Example: fab fa-wordpress-simple, fas fa-map-marker-alt. Icon list: https://goo.gl/vdPEsc', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "textarea_raw_html",
						"param_name" => "svg-icon",
						"heading" => esc_html__( 'SVG Icon', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "vc_link",
						"param_name" => "servicelink",
						"heading" => esc_html__( 'Link', 'eventchamp-core' ),
						"save_always" => true,
					),
				),
			)
		);

	}

}