<?php
/*======
*
* Organizers
*
======*/
if( !function_exists( 'eventchamp_organizers_output' ) ) {

	function eventchamp_organizers_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'style' => '1',
				'align' => 'center',
				'count' => '',
				'include-organizers' => '',
				'exclude-organizers' => '',
				'order' => 'ASC',
				'order-type' => 'name',
				'empty-organizers' => 'false',
				'childless' => 'false',
				'hide-children' => 'false',
				'event-count' => 'false',
				'show-count' => 'false',
			), $atts
		);

		/*====== Include Organizers ======*/
		if( !empty( $atts['include-organizers'] ) ) {

			$include_organizers = $atts['include-organizers'];
			$include_organizers = explode( ',', $include_organizers );

		} else {

			$include_organizers = "";

		}

		/*====== Exclude Organizers ======*/
		if( !empty( $atts['exclude-organizers'] ) ) {

			$exclude_organizers = $atts['exclude-organizers'];
			$exclude_organizers = explode( ',', $exclude_organizers );

		} else {

			$exclude_organizers = "";

		}

		/*====== Order ======*/
		if( empty( $atts["order"] ) ) {

			$atts["order"] = "ASC";

		}

		/*====== Order Type ======*/
		if( empty( $atts["order-type"] ) ) {

			$atts["order-type"] = "name";

		}

		/*====== Empty Organizers ======*/
		if( $atts['empty-organizers'] == 'false' ) {

			$empty_organizers = false;

		} else {

			$empty_organizers = true;

		}

		/*====== Childless ======*/
		if( $atts['childless'] == 'false' ) {

			$childless = false;

		} else {

			$childless = true;

		}

		/*====== Hide Children ======*/
		if( $atts['hide-children'] == 'false' ) {

			$hide_children = '';

		} else {

			$hide_children = 0;

		}

		/*====== Query ======*/
		$organizers = get_terms(
			array(
				'taxonomy' => 'organizer',
				'number' => $atts["count"],
				'include' => $include_organizers,
				'exclude' => $exclude_organizers,
				'order' => $atts["order"],
				'orderby' => $atts["order-type"],
				'hide_empty' => $empty_organizers,
				'childless' => $childless,
				'parent' => $hide_children,
			)
		);

		/*====== HTML Output ======*/
		$output = "";

		if( !empty( $organizers ) ) {

			$output .= '<div class="gt-organizers gt-style-' . esc_attr( $atts["style"] ) . ' gt-align-' . esc_attr( $atts["align"] ) . '">';
				$output .= '<ul>';

					foreach( $organizers as $organizer ) {

						if( !empty( $organizer ) ) {

							$output .= '<li>';
								$output .= '<a href="' . esc_url( get_term_link( $organizer->term_id ) . '?post_type=event' ) . '">';
									$output .= esc_attr( $organizer->name );

									if( $atts["show-count"] == "true" ) {

										$output .= ' (' . eventchamp_taxonomy_post_count( $cat_id = esc_attr( $organizer->term_id ), $taxonomy = "organizer" ) . ')';

									}

								$output .= '</a>';
							$output .= '</li>';

						}

					}

				$output .= '</ul>';
			$output .= '</div>';

		}

		return $output;

	}
	add_shortcode( "eventchamp_organizers", "eventchamp_organizers_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Organizers', 'eventchamp-core' ),
				"base" => "eventchamp_organizers",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/organizers.jpg',
				"description" => esc_html__( 'List the organizers', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "dropdown",
						"param_name" => "style",
						"heading" => esc_html__( 'Style', 'eventchamp-core' ),
						"admin_label" => true,
						"save_always" => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => '1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => '2',
							esc_html__( 'Style 3', 'eventchamp-core' ) => '3',
							esc_html__( 'Style 4', 'eventchamp-core' ) => '4',
							esc_html__( 'Style 5', 'eventchamp-core' ) => '4',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "align",
						"heading" => esc_html__( 'Align', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Left', 'eventchamp-core' ) => 'left',
							esc_html__( 'Center', 'eventchamp-core' ) => 'center',
							esc_html__( 'Right', 'eventchamp-core' ) => 'right',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "count",
						"heading" => esc_html__( 'Count', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-organizers",
						"heading" => esc_html__( 'Exclude Organizers', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-organizers",
						"heading" => esc_html__( 'Include Organizers', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "order",
						"heading" => esc_html__( 'Order', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'ASC', 'eventchamp-core' ) => 'ASC',
							esc_html__( 'DESC', 'eventchamp-core' ) => 'DESC',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "order-type",
						"heading" => esc_html__( 'Order Type', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Name', 'eventchamp-core' ) => 'name',
							esc_html__( 'Slug', 'eventchamp-core' ) => 'slug',
							esc_html__( 'Term Group', 'eventchamp-core' ) => 'term_group',
							esc_html__( 'Term ID', 'eventchamp-core' ) => 'term_id',
							esc_html__( 'ID', 'eventchamp-core' ) => 'id',
							esc_html__( 'Description', 'eventchamp-core' ) => 'description',
							esc_html__( 'Parent', 'eventchamp-core' ) => 'parent',
							esc_html__( 'Count', 'eventchamp-core' ) => 'count',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "empty-organizers",
						"heading" => esc_html__( 'Empty Organizers', 'eventchamp-core' ),
						"description" => esc_html__( 'If you choose true option empty organizers will be hide.', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "childless",
						"heading" => esc_html__( 'Childless', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "hide-children",
						"heading" => esc_html__( 'Hide Children', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "show-count",
						"heading" => esc_html__( 'Show Count', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
				),
			)
		);

	}

}