<?php
/*======
*
* Modal Button
*
======*/
if( !function_exists( 'eventchamp_modal_button_output' ) ) {

	function eventchamp_modal_button_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'style' => '1',
				'align' => 'left',
				'buttontitle' => '',
				'icon' => '',
				'svg-icon' => '',
				'inline' => 'false',
				'margin' => 'false',
				'text' => '',
				'content' => '',
				'shortcode' => '',
				'iframe' => '',
			), $atts
		);

		/*====== Content ======*/
		$atts['content'] = $content;

		/*====== Random Modal Number ======*/
		$rand = rand( 1, 99999 );

		/*====== HTML Output ======*/
		$output = '';

		if( !empty( $atts["buttontitle"] ) ) {

			$output .= '<div class="gt-button gt-style-' . esc_attr( $atts["style"] ) . ' gt-align-' . esc_attr( $atts["align"] ) . ' gt-inline-' . esc_attr( $atts["inline"] ) . ' gt-margin-' . esc_attr( $atts["margin"] ) . '">';
				$output .= '<a data-toggle="modal" data-target="#modal-' . esc_attr( $rand ) . '">';

					if( !empty( $atts["icon"] ) ) {

						$output .= '<i class="' . esc_attr( $atts["icon"] ) . '"></i>';

					} elseif( !empty( $atts["svg-icon"] ) ) {

						$output .= rawurldecode( base64_decode( $atts["svg-icon"] ) );

					}

					$output .= '<span>' . esc_attr( $atts["buttontitle"] ) . '</span>';
				$output .= '</a>';
			$output .= '</div>';

			$output .= '<div class="modal fade gt-modal gt-large-modal gt-modal-button-modal" id="modal-' . esc_attr( $rand ) . '" tabindex="-6" role="dialog" aria-labelledby="modal-' . esc_attr( $rand ) . '-label">';
				$output .= '<div class="modal-dialog gt-modal-dialog modal-dialog-centered" role="document">';
					$output .= '<div class="modal-content gt-modal-content">';
						$output .= '<div class="modal-header gt-modal-header">';
							$output .= '<div class="gt-modal-title">' . esc_attr( $atts["buttontitle"] ) . '</div>';
							$output .= '<button type="button" class="gt-close" data-dismiss="modal" aria-label="' . esc_html__( 'Close', 'eventchamp-core' ) . '">';
								$output .= '<svg version="1.1" xmlns="https://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 371.23 371.23" xml:space="preserve"> <polygon points="371.23,21.213 350.018,0 185.615,164.402 21.213,0 0,21.213 164.402,185.615 0,350.018 21.213,371.23 185.615,206.828 350.018,371.23 371.23,350.018 206.828,185.615 "/> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> </svg>';
							$output .= '</button>';
						$output .= '</div>';
						$output .= '<div class="modal-body gt-modal-body">';

							if( !empty( $atts["text"] ) ) {

								$output .= '<div class="gt-modal-inner-content">' . wpautop( do_shortcode( $atts["text"] ) )  . '</div>';

							}

							if( !empty( $atts["content"] ) ) {

								$output .= '<div class="gt-modal-inner-content">' . wpautop( do_shortcode( $atts["content"] ) ) . '</div>';

							}

							if( !empty( $atts["shortcode"] ) ) {

								$output .= '<div class="gt-modal-inner-content">' . do_shortcode( '[mc4wp_form id="' . esc_attr( $atts["shortcode"] ) . '"]' ) . '</div>';

							}

							if( !empty( $atts["iframe"] ) ) {

								$output .= '<div class="gt-modal-inner-content">';
									$output .= '<iframe width="800" height="550" frameborder="0" src="' . esc_url( $atts["iframe"] ) . '"></iframe>';
								$output .=' </div>';

							}

						$output .= '</div>';
					$output .= '</div>';
				$output .= '</div>';
			$output .= '</div>';

		}

		return $output;

	}
	add_shortcode( "eventchamp_modal_button", "eventchamp_modal_button_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Modal Button', 'eventchamp-core' ),
				"base" => "eventchamp_modal_button",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/button.jpg',
				"description" => esc_html__( 'A button that works with a modal', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "dropdown",
						"param_name" => "style",
						"heading" => esc_html__( 'Style', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => '1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => '2',
							esc_html__( 'Style 3', 'eventchamp-core' ) => '3',
							esc_html__( 'Style 4', 'eventchamp-core' ) => '4',
							esc_html__( 'Style 5', 'eventchamp-core' ) => '5',
							esc_html__( 'Style 6', 'eventchamp-core' ) => '6',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "align",
						"heading" => esc_html__( 'Align', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Left', 'eventchamp-core' ) => 'left',
							esc_html__( 'Center', 'eventchamp-core' ) => 'center',
							esc_html__( 'Right', 'eventchamp-core' ) => 'right',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "buttontitle",
						"heading" => esc_html__( 'Title', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						"admin_label" => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "icon",
						"heading" => esc_html__( 'Icon', 'eventchamp-core' ),
						"description" => esc_html__( 'If you want to use SVG icon, enter blank it. Example: fab fa-wordpress-simple, fas fa-map-marker-alt. Icon list: https://goo.gl/vdPEsc', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "textarea_raw_html",
						"param_name" => "svg-icon",
						"heading" => esc_html__( 'SVG Icon', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "inline",
						"heading" => esc_html__( 'Inline', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "margin",
						"heading" => esc_html__( 'Margin', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textarea",
						"param_name" => "text",
						"heading" => esc_html__( 'Standard Content', 'eventchamp-core' ),
						"group" => esc_html__( 'Modal', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "textarea_html",
						"param_name" => "content",
						"heading" => esc_html__( 'HTML Content', 'eventchamp-core' ),
						"group" => esc_html__( 'Modal', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "textarea",
						"param_name" => "shortcode",
						"heading" => esc_html__( 'Shortcode', 'eventchamp-core' ),
						"group" => esc_html__( 'Modal', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "iframe",
						"heading" => esc_html__( 'Map Iframe Link', 'eventchamp-core' ),
						"group" => esc_html__( 'Modal', 'eventchamp-core' ),
						"save_always" => true,
					)
				),
			)
		);

	}

}