<?php
/*======
*
* MailChimp Newsletter
*
======*/
if( !function_exists( 'eventchamp_mailchimp_newsletter_output' ) ) {

	function eventchamp_mailchimp_newsletter_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'id' => '',
				'style' => '',
			), $atts
		);

		/*====== HTML Output ======*/
		$output = '';

		if( !empty( $atts["id"] ) ) {

			$output = '<div class="gt-mailchimp-newsletter gt-' . esc_attr( $atts["style"] ) . '">';
				$output .= do_shortcode( '[mc4wp_form id="' . esc_attr( $atts["id"] ) . '"]' );
			$output .= '</div>';

		}

		return $output;

	}
	add_shortcode( "eventchamp_mailchimp_newsletter", "eventchamp_mailchimp_newsletter_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'MailChimp Newsletter', 'eventchamp-core' ),
				"base" => "eventchamp_mailchimp_newsletter",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/mailchimp-newsletter.jpg',
				"description" => esc_html__( 'Show MailChimp forms', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "dropdown",
						"param_name" => "style",
						"heading" => esc_html__( 'Style', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => 'dark',
							esc_html__( 'Style 2', 'eventchamp-core' ) => 'white',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "id",
						"heading" => esc_html__( 'Form ID', 'eventchamp-core' ),
						"admin_label" => true,
					),
				),
			)
		);

	}

}