<?php
/*======
*
* Image Gallery
*
======*/
if( !function_exists( 'eventchamp_image_gallery_element_output' ) ) {

	function eventchamp_image_gallery_element_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'images' => '',
				'caption' => '',
				'column' => '',
				'column-space' => '',
			), $atts
		);

		/*====== HTML Output ======*/
		$output = "";

		if( !empty( $atts["images"] ) ) {

			$images = explode( ',', $atts["images"] );

			$rand = rand( 0, 9999 );

			$output .= '<div class="gt-image-gallery">';

				$output .= '<div class="gt-columns gt-column-' . esc_attr( $atts["column"] ) . ' gt-column-space-' . esc_attr( $atts["column-space"] ) . '">';

					foreach( $images as $image ) {

						if( !empty( $image ) ) {

							$output .= '<div class="gt-col">';

								$output .= '<div class="gt-inner">';

									$output .= '<div class="gt-photo">';

										$output .= '<a data-fancybox="gallery-' . esc_attr( $rand ) . '" href="' . wp_get_attachment_image_src( esc_attr( $image ), 'full' )[0] . '" data-srcset="' . wp_get_attachment_image_srcset( esc_attr( $image ), 'full' ) . '" data-caption="' . ( $atts["caption"] == "true" ? wp_get_attachment_caption( esc_attr( $image ) ) : '' ) . '"></a>';

											if( $atts["column"] == "1" ) {

												$output .= wp_get_attachment_image( esc_attr( $image ), 'eventchamp-thumbnail-3' );

											} elseif( $atts["column"] == "1" or $atts["column"] == "2" or $atts["column"] == "3" or $atts["column"] == "4" ) {

												$output .= wp_get_attachment_image( esc_attr( $image ), 'eventchamp-thumbnail-2' );

											} else {
												$output .= wp_get_attachment_image( esc_attr( $image ), 'eventchamp-thumbnail' );

											}

									$output .= '</div>';

								$output .= '</div>';

							$output .= '</div>';

						}

					}

				$output .= '</div>';

			$output .= '</div>';

			return $output;

		}

	}
	add_shortcode( "eventchamp_image_gallery_element", "eventchamp_image_gallery_element_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Image Gallery', 'eventchamp-core' ),
				"base" => "eventchamp_image_gallery_element",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/image-gallery.jpg',
				"description" => esc_html__( 'A image gallery with lightbox', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "attach_images",
						"param_name" => "images",
						"heading" => esc_html__( 'Images', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "caption",
						"heading" => esc_html__( 'Caption', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "column",
						"heading" => esc_html__( 'Column', 'eventchamp-core' ),
						"admin_label" => true,
						"save_always" => true,
						"value" => array(
							esc_html__( '1', 'eventchamp-core' ) => '1',
							esc_html__( '2', 'eventchamp-core' ) => '2',
							esc_html__( '3', 'eventchamp-core' ) => '3',
							esc_html__( '4', 'eventchamp-core' ) => '4',
							esc_html__( '5', 'eventchamp-core' ) => '5',
							esc_html__( '6', 'eventchamp-core' ) => '6',
							esc_html__( '7', 'eventchamp-core' ) => '7',
							esc_html__( '8', 'eventchamp-core' ) => '8',
							esc_html__( '9', 'eventchamp-core' ) => '9',
							esc_html__( '10', 'eventchamp-core' ) => '10',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "column-space",
						"heading" => esc_html__( 'Column Space', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( '0', 'eventchamp-core' ) => '0',
							esc_html__( '5', 'eventchamp-core' ) => '5',
							esc_html__( '10', 'eventchamp-core' ) => '10',
							esc_html__( '15', 'eventchamp-core' ) => '15',
							esc_html__( '20', 'eventchamp-core' ) => '20',
							esc_html__( '25', 'eventchamp-core' ) => '25',
							esc_html__( '30', 'eventchamp-core' ) => '30',
							esc_html__( '35', 'eventchamp-core' ) => '35',
							esc_html__( '40', 'eventchamp-core' ) => '40',
							esc_html__( '45', 'eventchamp-core' ) => '45',
							esc_html__( '50', 'eventchamp-core' ) => '50',
							esc_html__( '55', 'eventchamp-core' ) => '55',
							esc_html__( '60', 'eventchamp-core' ) => '60',
						),
					),
				),
			)
		);

	}

}