<?php
/*======
*
* Heading
*
======*/
if( !function_exists( 'eventchamp_content_title_output' ) ) {

	function eventchamp_content_title_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'title' => '',
				'size' => '',
				'align' => '',
				'titleone' => '',
				'titletwo' => '',
				'description' => '',
				'separator' => 'true',
				'icon' => '',
				'svg-icon' => '',
			), $atts
		);

		/*====== Align ======*/
		if( !empty( $atts['align'] ) ) {

			$align = esc_attr( $atts['align'] );

		} else {

			$align = "center";

		}

		/*====== HTML Output ======*/
		$output = "";

		if( !empty( $atts["titleone"] ) or !empty( $atts["titletwo"] ) or !empty( $atts["description"] ) ) {

			$output .= '<div class="gt-heading gt-' . esc_attr( $atts["title"] ) . ' gt-' . esc_attr( $atts["size"] ) . ' gt-align-' . esc_attr( $align ) . '">';

				if( !empty( $atts["titleone"] ) or !empty( $atts["titletwo"] ) ) {

					$output .= '<div class="gt-title">';

						if( !empty( $atts["titleone"] ) ) {

							$output .= esc_attr( $atts["titleone"] );

						}

						if( !empty( $atts["titleone"] ) and !empty( $atts["titletwo"] ) ) {

							$output .= ' ';

						}

						if( !empty( $atts["titletwo"] ) ) {

							$output .= '<span>' . esc_attr( $atts["titletwo"] ) . '</span>';

						}

					$output .= '</div>';

				}

				if( $atts["separator"] == "true" ) {

					$output .= '<div class="gt-separate">';

						if( !empty( $atts["icon"] ) ) {

							$output .= '<i class="' . esc_attr( $atts["icon"] ) . '"></i>';

						} elseif( !empty( $atts["svg-icon"] ) ) {

							$output .= '<div class="gt-icon">';
								$output .= rawurldecode( base64_decode( $atts["svg-icon"] ) );
							$output .= '</div>';

						} else {

							$output .= '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"></path><polyline points="3.27 6.96 12 12.01 20.73 6.96"></polyline><line x1="12" y1="22.08" x2="12" y2="12"></line></svg>';

						}

					$output .= '</div>';

				}

				if( !empty( $atts["description"] ) ) {

					$output .= '<div class="gt-text">' . esc_attr( $atts["description"] ) . '</div>';

				}

			$output .= '</div>';

		}

		return $output;

	}
	add_shortcode( "eventchamp_content_title", "eventchamp_content_title_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Heading', 'eventchamp-core' ),
				"base" => "eventchamp_content_title",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/heading.jpg',
				"description" => esc_html__( 'Create a heading or title', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "dropdown",
						"param_name" => "title",
						"heading" => esc_html__( 'Style', 'eventchamp-core' ),
						'save_always' => true,
						"admin_label" => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => 'dark',
							esc_html__( 'Style 2', 'eventchamp-core' ) => 'white',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "size",
						"heading" => esc_html__( 'Size', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Size 1', 'eventchamp-core' ) => 'size1',
							esc_html__( 'Size 2', 'eventchamp-core' ) => 'size2',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "align",
						"heading" => esc_html__( 'Align', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Left', 'eventchamp-core' ) => 'left',
							esc_html__( 'Center', 'eventchamp-core' ) => 'center',
							esc_html__( 'Right', 'eventchamp-core' ) => 'right',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "titleone",
						"heading" => esc_html__( 'Primary Title', 'eventchamp-core' ),
						"admin_label" => true,
						"save_always" => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "titletwo",
						"heading" => esc_html__( 'Secondary Title', 'eventchamp-core' ),
						"admin_label" => true,
						"save_always" => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "description",
						"heading" => esc_html__( 'Description Text', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "separator",
						"heading" => esc_html__( 'Separator', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "icon",
						"heading" => esc_html__( 'Font Icon', 'eventchamp-core' ),
						"description" => esc_html__( 'If you want to use SVG icon, enter blank it. Example: fab fa-wordpress-simple, fas fa-map-marker-alt. Icon list: https://goo.gl/vdPEsc', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "textarea_raw_html",
						"param_name" => "svg-icon",
						"heading" => esc_html__( 'SVG Icon', 'eventchamp-core' ),
						"save_always" => true,
					),
				),
			)
		);

	}

}