<?php
/*======
*
* Google Maps
*
======*/
if( !function_exists( 'eventchamp_google_maps_output' ) ) {

	function eventchamp_google_maps_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'map-height' => '450px',
				'map-style' => '1',
				'map-lat' => '1',
				'map-lng' => '1',
				'map-zoom' => '13',
				'map-zoom-control' => 'false',
				'map-icon' => '',
				'map-type' => 'false',
				'map-scale' => 'false',
				'map-fullscreen' => 'false',
				'map-streets' => 'false',
				'markers' => '',
			), $atts
		);

		/*====== Map Zoom ======*/
		if( empty( $atts["map-zoom"] ) ) {

			$atts["map-zoom"] = "13";

		}

		/*====== Map Height ======*/
		if( empty( $atts["map-height"] ) ) {

			$atts["map-height"] = "450px";

		}

		/*====== Map Style ======*/
		if( empty( $atts["map-style"] ) ) {

			$atts["map-style"] = "1";

		}

		/*====== Map Lat ======*/
		if( empty( $atts["map-lat"] ) ) {

			$atts["map-lat"] = "1";

		}

		/*====== Map Lng ======*/
		if( empty( $atts["map-lng"] ) ) {

			$atts["map-lng"] = "1";

		}

		/*====== Map Icon ======*/
		if( !empty( $atts["map-icon"] ) ) {

			$map_icon = wp_get_attachment_image_src( esc_attr( $atts["map-icon"] ), 'full' )[0];

		} else {

			$map_icon = get_template_directory_uri() . '/include/assets/img/map-marker.png';

		}

		/*====== Markers ======*/
		$markers = vc_param_group_parse_atts( $atts['markers'] );

		/*====== HTML Output ======*/
		$output = '';

		$output .= '<div class="gt-map gt-google-maps">';
			$output .= '<div id="google_maps" class="gt-map-inner" style="height:' . esc_attr( $atts["map-height"] ) .  '"></div>';
			$output .= '<ul data-zoom="' . esc_attr( $atts["map-zoom"] ) . '" data-lat="' . esc_attr( $atts["map-lat"] ) . '" data-lng="' . esc_attr( $atts["map-lng"] ) . '" data-type="' . esc_attr( $atts["map-type"] ) . '" data-scale="' . esc_attr( $atts["map-scale"] ) . '" data-zoom-control="' . esc_attr( $atts["map-zoom-control"] ) . '" data-map-style="' . esc_attr( $atts["map-style"] ) . '" data-street="' . esc_attr( $atts["map-streets"] ) . '" data-icon="' . esc_url( $map_icon ) . '" data-fullscreen="' . esc_attr( $atts["map-fullscreen"] ) . '" data-first-info="false" data-close-icon="">';

				if( !empty( $markers ) ) {

					foreach ( $markers as $marker ) {

						if( !empty( $marker ) ) {

							if( !empty( $marker["map-icon"] ) ) {

								$map_icon = wp_get_attachment_image_src( esc_attr( $marker["map-icon"] ), 'full' )[0];

							}

							$output .= '<li data-lat="' . esc_attr( $marker["marker-lat"] ) . '" data-lng="' . esc_attr( $marker["marker-lng"] ) . '" data-icon="' . esc_url( $map_icon ) . '"></li>';

						}

					}

				}

			$output .= '</ul>';
		$output .= '</div>';

		return $output;

	}
	add_shortcode( "eventchamp_google_maps", "eventchamp_google_maps_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Google Maps', 'eventchamp-core' ),
				"base" => "eventchamp_google_maps",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/map.jpg',
				"description" => esc_html__( 'Create a Google Maps', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "textfield",
						"param_name" => "map-height",
						"heading" => esc_html__( 'Map Height', 'eventchamp-core' ),
						"description" => esc_html__( 'If you want to make it full height, enter 100vh value. Default: 450px', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "map-style",
						"heading" => esc_html__( 'Map Style', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => '1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => '2',
							esc_html__( 'Style 3', 'eventchamp-core' ) => '3',
							esc_html__( 'Style 4', 'eventchamp-core' ) => '4',
							esc_html__( 'Style 5', 'eventchamp-core' ) => '5',
							esc_html__( 'Style 6', 'eventchamp-core' ) => '6',
							esc_html__( 'Style 7', 'eventchamp-core' ) => '7',
							esc_html__( 'Style 8', 'eventchamp-core' ) => '8',
							esc_html__( 'Style 9', 'eventchamp-core' ) => '9',
							esc_html__( 'Style 10', 'eventchamp-core' ) => '10',
							esc_html__( 'Style 11', 'eventchamp-core' ) => '11',
							esc_html__( 'Style 12', 'eventchamp-core' ) => '12',
							esc_html__( 'Style 13', 'eventchamp-core' ) => '13',
							esc_html__( 'Style 14', 'eventchamp-core' ) => '14',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "map-lat",
						"heading" => esc_html__( 'Map Lat', 'eventchamp-core' ),
						"description" => esc_html__( 'The map will open on this lat coordinate.', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "map-lng",
						"heading" => esc_html__( 'Map Lng', 'eventchamp-core' ),
						"description" => esc_html__( 'The map will open on this lng coordinate.', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "map-zoom",
						"heading" => esc_html__( 'Map Zoom', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: 13', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "map-zoom-control",
						"heading" => esc_html__( 'Map Zoom Control', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "attach_image",
						"param_name" => "map-icon",
						"heading" => esc_html__( 'Map Icon', 'eventchamp-core' ),
						"description" => esc_html__( 'If you will not upload any map icon, the default icon will show.', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "map-type",
						"heading" => esc_html__( 'Map Type', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "map-scale",
						"heading" => esc_html__( 'Map Scale', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "map-fullscreen",
						"heading" => esc_html__( 'Map Fullscreen', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "map-streets",
						"heading" => esc_html__( 'Map Streets', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						'type' => 'param_group',
						'param_name' => 'markers',
						"heading" => esc_html__( 'Markers', 'eventchamp-core' ),
						"save_always" => true,
						'params' => array(
							array(
								"type" => "textfield",
								"param_name" => "marker-lat",
								"heading" => esc_html__( 'Map Lat', 'eventchamp-core' ),
								'save_always' => true,
							),
							array(
								"type" => "textfield",
								"param_name" => "marker-lng",
								"heading" => esc_html__( 'Map Lng', 'eventchamp-core' ),
								'save_always' => true,
							),
							array(
								"type" => "attach_image",
								"param_name" => "map-icon",
								"heading" => esc_html__( 'Map Icon', 'eventchamp-core' ),
								"description" => esc_html__( 'If you will not upload any map icon, the default icon will show.', 'eventchamp-core' ),
								'save_always' => true,
							),
						)
					),
				),
			)
		);

	}

}