<?php
/*======
*
* Events Map
*
======*/
if( !function_exists( 'eventchamp_events_map_output' ) ) {

	function eventchamp_events_map_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'include-events' => '',
				'exclude-events' => '',
				'hide-expired' => '',
				'exclude-categories' => '',
				'exclude-locations' => '',
				'exclude-organizers' => '',
				'exclude-tags' => '',
				'include-categories' => '',
				'include-locations' => '',
				'include-organizers' => '',
				'include-tags' => '',
				'map-height' => '450px',
				'map-style' => '1',
				'map-lat' => '1',
				'map-lng' => '1',
				'map-zoom' => '13',
				'map-zoom-control' => 'false',
				'map-icon' => '',
				'map-type' => 'false',
				'map-scale' => 'false',
				'map-fullscreen' => 'false',
				'map-streets' => 'false',
				'event-categories' => 'false',
				'event-locations' => 'false',
				'event-venue' => 'false',
				'event-start-date' => 'false',
				'event-status' => 'false',
				'event-price' => 'false',
			), $atts
		);

		/*====== Map Zoom ======*/
		if( empty( $atts["map-zoom"] ) ) {

			$atts["map-zoom"] = "13";

		}

		/*====== Map Height ======*/
		if( empty( $atts["map-height"] ) ) {

			$atts["map-height"] = "450px";

		}

		/*====== Map Style ======*/
		if( empty( $atts["map-style"] ) ) {

			$atts["map-style"] = "1";

		}

		/*====== Map Lat ======*/
		if( empty( $atts["map-lat"] ) ) {

			$atts["map-lat"] = "1";

		}

		/*====== Map Lng ======*/
		if( empty( $atts["map-lng"] ) ) {

			$atts["map-lng"] = "1";

		}

		/*====== Map Icon ======*/
		if( !empty( $atts["map-icon"] ) ) {

			$map_icon = wp_get_attachment_image_src( esc_attr( $atts["map-icon"] ), 'full' )[0];

		} else {

			$map_icon = get_template_directory_uri() . '/include/assets/img/map-marker.png';

		}

		/*====== Expired Events Status ======*/
		if( !empty( $atts['hide-expired'] ) ) {

			$hide_expired = esc_attr( $atts["hide-expired"] );

		} else {

			$hide_expired = "false";

		}

		/*====== Search Results ======*/
		if( isset( $_GET['keyword'] ) or isset( $_GET['category'] ) or isset( $_GET['status'] ) or isset( $_GET['sort'] ) or isset( $_GET['tag'] ) or isset( $_GET['location'] ) or isset( $_GET['event-venue'] ) or isset( $_GET['event-speaker'] ) or isset( $_GET['startdate'] ) or isset( $_GET['enddate'] ) or isset( $_GET['price'] ) ) {

			if( isset( $_GET['keyword'] ) ) {

				$search_keyword = esc_js( esc_sql( esc_attr( $_GET["keyword"] ) ) );

			} else {

				$search_keyword = "";

			}

			if( isset( $_GET['category'] ) ) {

				$search_category = esc_js( esc_sql( esc_attr( $_GET["category"] ) ) );

			} else {

				$search_category = "";

			}

			if( isset( $_GET['status'] ) ) {

				$search_status = esc_js( esc_sql( esc_attr( $_GET["status"] ) ) );

			} else {

				$search_status = "";

			}

			if( isset( $_GET['sort'] ) ) {

				$search_sort = esc_js( esc_sql( esc_attr( $_GET["sort"] ) ) );

			} else {

				$search_sort = "";

			}

			if( isset( $_GET['tag'] ) ) {

				$search_tag = esc_js( esc_sql( esc_attr( $_GET["tag"] ) ) );

			} else {

				$search_tag = "";

			}

			if( isset( $_GET['location'] ) ) {

				$search_location = esc_js( esc_sql( esc_attr( $_GET["location"] ) ) );

			} else {

				$search_location = "";

			}

			if( isset( $_GET['event-venue'] ) ) {

				$search_venue = esc_js( esc_sql( esc_attr( $_GET["event-venue"] ) ) );

			} else {

				$search_venue = "";

			}

			if( isset( $_GET['event-speaker'] ) ) {

				$search_speaker = esc_js( esc_sql( esc_attr( $_GET["event-speaker"] ) ) );

			} else {

				$search_speaker = "";

			}

			if( isset( $_GET['organizer'] ) ) {

				$search_organizer = esc_js( esc_sql( esc_attr( $_GET["organizer"] ) ) );

			} else {

				$search_organizer = "";

			}

			if( isset( $_GET['startdate'] ) ) {

				if( !empty( $_GET['startdate'] ) ) {

					$search_startdate = esc_js( esc_sql( esc_attr( $_GET["startdate"] ) ) );
					$search_startdate = date( 'Y-m-d', strtotime( $search_startdate ) );
					$search_startdate_compare = ">=";

				} else {

					$search_startdate = "";
					$search_startdate_compare = "";

				}

			} else {

				$search_startdate = "";
				$search_startdate_compare = "";

			}

			if( isset( $_GET['enddate'] ) ) {

				if( !empty( $_GET['enddate'] ) ) {

					$search_enddate = esc_js( esc_sql( esc_attr( $_GET["enddate"] ) ) );
					$search_enddate = date( 'Y-m-d', strtotime( $search_enddate ) );
					$search_enddate_compare = "<=";

				} else {

					$search_enddate = "";
					$search_enddate_compare = "";

				}

			} else {

				$search_enddate = "";
				$search_enddate_compare = "";

			}
			
			if( $search_status == "upcoming" ) {

				$search_compare = ">";
				$search_compare2 = ">";

			} elseif( $search_status == "showing" ) {

				$search_compare = "<=";
				$search_compare2 = ">=";

			} elseif( $search_status == "expired" ) {

				$search_compare = "<";
				$search_compare2 = "<";

			} else {

				$search_compare = "<=";
				$search_compare2 = ">=";

			}

			$prices = array();

			if( isset( $_GET['price'] ) ) {

				$search_price = esc_js( esc_sql( esc_attr( $_GET["price"] ) ) );

				if( !empty( $search_price ) ) {

					$prices = explode( ';', $search_price );

				}

			}

		} else {

			$search_startdate = "";
			$search_startdate_compare = "";
			$search_enddate = "";
			$search_enddate_compare = "";
			$search_keyword = "";
			$search_category = "";
			$search_status = "";
			$search_sort = "";
			$search_location = "";
			$search_venue = "";
			$search_speaker = "";
			$search_organizer = "";
			$search_compare = "";
			$search_compare2 = "";
			$order = "";
			$order_by = "";
			$meta_key = "event_start_date";
			$search_tag = "";
			$prices = array();

		}

		/*====== Exclude Categories ======*/
		$exclude_category_array = "";

		if( !empty( $atts['exclude-categories'] ) ) {

			$exclude_categories = $atts['exclude-categories'];
			$exclude_categories = explode( ',', $exclude_categories );

		} else {

			$exclude_categories = "";

		}

		if( !empty( $exclude_categories ) ) {

			$exclude_category_array = array(
				'taxonomy' => 'eventcat',
				'field' => 'term_id',
				'terms' => $exclude_categories,
				'operator' => 'NOT IN',
			);

		}

		/*====== Exclude Locations ======*/
		$exclude_location_array = "";

		if( !empty( $atts['exclude-locations'] ) ) {

			$exclude_locations = $atts['exclude-locations'];
			$exclude_locations = explode( ',', $exclude_locations );

		} else {

			$exclude_locations = "";

		}

		if( !empty( $exclude_locations ) ) {

			$exclude_location_array = array(
				'taxonomy' => 'location',
				'field' => 'term_id',
				'terms' => $exclude_locations,
				'operator' => 'NOT IN',
			);

		}

		/*====== Exclude Organizers ======*/
		$exclude_organizer_array = "";

		if( !empty( $atts['exclude-organizers'] ) ) {

			$exclude_organizers = $atts['exclude-organizers'];
			$exclude_organizers = explode( ',', $exclude_organizers );

		} else {

			$exclude_organizers = "";

		}

		if( !empty( $exclude_organizers ) ) {

			$exclude_organizer_array = array(
				'taxonomy' => 'organizer',
				'field' => 'term_id',
				'terms' => $exclude_organizers,
				'operator' => 'NOT IN',
			);

		}

		/*====== Exclude Tags ======*/
		$exclude_tag_array = "";

		if( !empty( $atts['exclude-tags'] ) ) {

			$exclude_tags = $atts['exclude-tags'];
			$exclude_tags = explode( ',', $exclude_tags );

		} else {

			$exclude_tags = "";

		}

		if( !empty( $exclude_tags ) ) {

			$exclude_tag_array = array(
				'taxonomy' => 'event_tags',
				'field' => 'term_id',
				'terms' => $exclude_tags,
				'operator' => 'NOT IN',
			);

		}

		/*====== Include Categories ======*/
		$include_category_array = "";

		if( !empty( $search_category ) ) {

			$include_categories = explode( ',', $search_category );

			if( !empty( $include_categories ) ) {

				$include_category_array = array(
					'taxonomy' => 'eventcat',
					'field' => 'term_id',
					'terms' => $include_categories,
					'operator' => 'IN',
				);

			}

		} else {

			if( !empty( $atts['includecategories'] ) ) {

				$include_categories = $atts['includecategories'];
				$include_categories = explode( ',', $include_categories );

			} else {

				$include_categories = "";

			}

			if( !empty( $include_categories ) ) {

				$include_category_array = array(
					'taxonomy' => 'eventcat',
					'field' => 'term_id',
					'terms' => $include_categories,
					'operator' => 'IN',
				);

			}

		}

		/*====== Include Locations ======*/
		$include_location_array = "";

		if( !empty( $search_location ) ) {

			$include_locations = explode( ',', $search_location );

			if( !empty( $include_locations ) ) {

				$include_location_array = array(
					'taxonomy' => 'location',
					'field' => 'term_id',
					'terms' => $include_locations,
					'operator' => 'IN',
				);

			}

		} else {

			if( !empty( $atts['include-locations'] ) ) {

				$include_locations = $atts['include-locations'];
				$include_locations = explode( ',', $include_locations );

			} else {

				$include_locations = "";

			}

			if( !empty( $include_locations ) ) {

				$include_location_array = array(
					'taxonomy' => 'location',
					'field' => 'term_id',
					'terms' => $include_locations,
					'operator' => 'IN',
				);

			}

		}

		/*====== Include Organizers ======*/
		$include_organizers_array = "";

		if( !empty( $search_organizer ) ) {

			$include_organizers = explode( ',', $search_organizer );

			if( !empty( $include_organizers ) ) {

				$include_organizers_array = array(
					'taxonomy' => 'organizer',
					'field' => 'term_id',
					'terms' => $include_organizers,
					'operator' => 'IN',
				);

			}

		} else {

			if( !empty( $atts['include-organizers'] ) ) {

				$include_organizers = $atts['include-organizers'];
				$include_organizers = explode( ',', $include_organizers );

			} else {

				$include_organizers = "";

			}

			if( !empty( $include_organizers ) ) {

				$include_organizers_array = array(
					'taxonomy' => 'organizer',
					'field' => 'term_id',
					'terms' => $include_organizers,
					'operator' => 'IN',
				);

			}

		}

		/*====== Include Tags ======*/
		$include_tags_array = "";

		if( !empty( $search_tag ) ) {

			$include_tags = explode( ',', $search_tag );

			if( !empty( $include_tags ) ) {

				$include_tags_array = array(
					'taxonomy' => 'event_tags',
					'field' => 'name',
					'terms' => $include_tags,
					'operator' => 'IN',
				);

			}

		} else {

			if( !empty( $atts['include-tags'] ) ) {

				$include_tags = $atts['include-tags'];
				$include_tags = explode( ',', $include_tags );

			} else {

				$include_tags = "";

			}

			if( !empty( $include_tags ) ) {

				$include_tags_array = array(
					'taxonomy' => 'event_tags',
					'field' => 'term_id',
					'terms' => $include_tags,
					'operator' => 'IN',
				);

			}

		}

		/*====== Filtrable by Venue ======*/
		$venue_array = array();

		if( !empty( $search_venue ) ) {

			$venue_array = array(
				'key' => 'event_venue',
				'compare' => 'LIKE',
				'value' => ':' . esc_attr( $search_venue ) . ';',
			);

		}

		/*====== Filtrable by Speaker ======*/
		$speaker_array = array();

		if( !empty( $search_speaker ) ) {

			$speaker_array = array(
				'key' => 'event_speakers',
				'compare' => 'LIKE',
				'value' => ':' . esc_attr( $search_speaker ) . ';',
			);

		}

		/*====== Filter by Price ======*/
		$prices_array = array();

		if( !empty( $prices ) ) {

			if( !empty( $prices[0] ) and !empty( $prices[1] ) ) {

				$prices_array = array(
					array(
						'key' => 'event-ticket-main-price',
						'compare' => '>=',
						'value' => $prices[0],
						'type' => 'NUMERIC',
					),
					array(
						'key' => 'event-ticket-main-price',
						'compare' => '<=',
						'value' => $prices[1],
						'type' => 'NUMERIC',
					),
				);

			}

		}

		/*====== Filtrable by Start Date ======*/
		$start_date_array = array();

		if( !empty( $search_startdate ) ) {

			$start_date_array = array(
				'key' => 'event_start_date',
				'compare' => $search_startdate_compare,
				'value' => $search_startdate,
			);

		}

		/*====== Filtrable by End Date ======*/
		$end_date_array = array();

		if( !empty( $search_enddate ) ) {

			$end_date_array = array(
				'key' => 'event_end_date',
				'compare' => $search_enddate_compare,
				'value' => $search_enddate,
			);

		}

		/*====== Order by Event Date ======*/
		$order_event_start_date_array = array();

		if( $search_sort == "start-date" ) {

			$order_event_start_date_array = array(
				'relation' => 'AND',
				'event_start_date_clause' => array(
					'key' => 'event_start_date',
				), 
				'event_start_time_clause' => array(
					'key' => 'event_start_time',
				),
			);

 		}

		/*====== Order by End Date ======*/
		$order_event_end_date_array = array();

		if( $search_sort == "end-date" ) {

			$order_event_end_date_array = array(
				'relation' => 'AND',
				'event_end_date_clause' => array(
					'key' => 'event_end_date',
				), 
				'event_end_time_clause' => array(
					'key' => 'event_end_time',
				),
			);

 		}

		/*====== Filtrable by Event Status ======*/
		$status_array = array();
		$status_array_2 = array();

		if( !empty( $search_status ) ) {

			if( $search_status == "expired" ) {

				$expire_date_now = date("Y-m-d H:i");
				$status_array = array(
					'key' => 'event_expire_date',
					'compare' => '<=',
					'value' => $expire_date_now,
				);

			} else {

				$status_array = array(
					'key' => 'event_start_date',
					'compare' => $search_compare,
					'value' => $date_now,
				);
				$status_array_2 = array(
					'key' => 'event_end_date',
					'compare' => $search_compare2,
					'value' => $date_now,
				);

			}

		}

		/*====== Main Query ======*/
		$arg = array(
			'posts_per_page' => -1,
			'post_status' => 'publish',
			'post_type' => 'event',
			'tax_query' => array (
				'relation' => 'AND',
				$include_location_array,
				$include_category_array,
				$include_organizers_array,
				$include_tags_array,
				$exclude_category_array,
				$exclude_location_array,
				$exclude_organizer_array,
				$exclude_tag_array,
			),
			'meta_query' => array(
				$status_array,
				$status_array_2,
				$start_date_array,
				$end_date_array,
				$venue_array,
				$speaker_array,
				$prices_array,
				$order_event_start_date_array,
				$order_event_end_date_array,
			),
		);

		/*====== Keyword ======*/
		if( !empty( $search_keyword ) ) {

			$extra_query = array(
				's' => $search_keyword,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Include Events ======*/
		if( !empty( $atts['include-events'] ) ) {

			$event_ids = $atts['include-events'];
			$include_events = explode( ',', $event_ids );

		} else {

			$include_events = "";

		}

		if( !empty( $include_events ) ) {

			$extra_query = array(
				'post__in' => $include_events,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Exclude Events ======*/
		if( $hide_expired == "false" ) {

			if( !empty( $atts['exclude-events'] ) ) {

				$exclude_events = $atts['exclude-events'];
				$exclude_events = explode( ',', $exclude_events );

			} else {

				$exclude_events = array();

			}

			if( !empty( $exclude_events ) ) {

				$extra_query = array(
					'post__not_in' => $exclude_events,
				);
				$arg = wp_parse_args( $arg, $extra_query );

			}

		}

		/*====== Add Expired Events in Exclude Events ======*/
		if( $hide_expired == "true" ) {

			$expired_ids = eventchamp_expired_event_ids();

		} else {

			$expired_ids = array();

		}

		if( !empty( $expired_ids ) ) {

			if( !empty( $exclude_events ) ) {

				$exclude_events_expired = $exclude_events;
				$exclude_events_expired = explode( ',', $exclude_events_expired );

			} else {

				$exclude_events_expired = array();

			}

			$excludeevents_with_expired = array_merge( $exclude_events_expired, $expired_ids );

			$extra_query = array(
				'post__not_in' => $excludeevents_with_expired,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Order by Start Date ======*/
		if( $search_sort == "start-date" ) {

			$extra_query = array(
				'orderby' => array(
					'event_start_date_clause' => $order,
					'event_start_time_clause' => $order,
				),
			);
			$arg = wp_parse_args( $arg, $extra_query );

 		}

		/*====== Order by End Date ======*/
		if( $search_sort == "end-date" ) {

			$extra_query = array(
				'orderby' => array(
					'event_end_date_clause' => $order,
					'event_end_time_clause' => $order,
				),
			);
			$arg = wp_parse_args( $arg, $extra_query );

 		}

		/*====== HTML Output ======*/
		$output = '';

		$wp_query = new WP_Query( $arg );

		if( !empty( $wp_query ) ) {

			if( $wp_query->have_posts() ) {

				$output .= '<div class="gt-map gt-events-map">';
					$output .= '<div id="event_map" class="gt-map-inner" style="height:' . esc_attr( $atts["map-height"] ) .  '"></div>';
					$output .= '<ul data-zoom="' . esc_attr( $atts["map-zoom"] ) . '" data-lat="' . esc_attr( $atts["map-lat"] ) . '" data-lng="' . esc_attr( $atts["map-lng"] ) . '" data-type="' . esc_attr( $atts["map-type"] ) . '" data-scale="' . esc_attr( $atts["map-scale"] ) . '" data-zoom-control="' . esc_attr( $atts["map-zoom-control"] ) . '" data-map-style="' . esc_attr( $atts["map-style"] ) . '" data-street="' . esc_attr( $atts["map-streets"] ) . '" data-icon="' . esc_url( $map_icon ) . '" data-fullscreen="' . esc_attr( $atts["map-fullscreen"] ) . '" data-first-info="false" data-close-icon="' . get_template_directory_uri() . '/include/assets/img/map-close.svg' . '" data-cluster-icon="' . get_template_directory_uri() . '/include/assets/img/map-cluster/m' . '">';

						while( $wp_query->have_posts() ) {

							$wp_query->the_post();

							$categories = wp_get_post_terms( get_the_ID(), 'eventcat' );
							$locations = wp_get_post_terms( get_the_ID(), 'location' );
							$event_venues = get_post_meta( get_the_ID(), 'event_venue', true );
							$event_start_date = get_post_meta( get_the_ID(), 'event_start_date', true );
							$event_price = get_post_meta( get_the_ID(), 'event-ticket-main-price', true );
							$event_lat = get_post_meta( get_the_ID(), 'event-map-lat', true );
							$event_lng = get_post_meta( get_the_ID(), 'event-map-lng', true );
							$event_icon = get_post_meta( get_the_ID(), 'event-map-icon', true );

							if( empty( $event_icon ) ) {

								$event_icon = $map_icon;

							}

							$popup_content = '<div class="gt-map-popup-wrapper">';
								$popup_content .= '<div class="gt-map-popup" style="background-image:url(' . esc_url( wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'eventchamp-thumbnail' )[0] ) . ');">';
									$popup_content .= '<a href="' . get_the_permalink() . '"></a>';

									$popup_content .= '<div class="gt-inner">';

										if( $atts["event-price"] == 'true' and !empty( $event_price ) or $atts["event-status"] == 'true' ) {

											$popup_content .= '<ul class="gt-top-links">';

												if( $atts["event-price"] == 'true' and !empty( $event_price ) ) {

													$currency_position = ot_get_option( 'event-price-currency-position', 'left' );
													$currency = ot_get_option( 'event-price-currency' );

													$popup_content .= '<li class="gt-price">';

														if( $currency_position == "left" ) {

															$popup_content .= '<span>';
																$popup_content .= esc_attr( $currency );
															$popup_content .= '</span>';

														}

														if( $currency_position == "left-space" ) {

															$popup_content .= '<span>';
																$popup_content .= esc_attr( $currency ) . ' ';
															$popup_content .= '</span>';

														}

														$popup_content .= esc_attr( $event_price );

														if( $currency_position == "right" ) {

															$popup_content .= '<span>';
																$popup_content .= esc_attr( $currency );
															$popup_content .= '</span>';

														}

														if( $currency_position == "right-space" ) {

															$popup_content .= '<span>';
																$popup_content .= ' ' . esc_attr( $currency );
															$popup_content .= '</span>';

														}

													$popup_content .= '</li>';

												}

												if( $atts["event-price"] == 'true' and $event_price == '0' ) {

													$free_event_price = ot_get_option( 'event-free-events-price', 'free' );

													if( $free_event_price != 'hide' ) {

														$currency_position = ot_get_option( 'event-price-currency-position', 'left' );
														$currency = ot_get_option( 'event-price-currency' );
														$event_price = "0";

														$popup_content .= '<li class="gt-price">';

															if( $free_event_price == "free" ) {

																$popup_content .= esc_html__( 'Free', 'eventchamp' );

															} elseif( $free_event_price == "0" ) {

																$popup_content .= '0';

															} elseif( $free_event_price == "0-currency" ) {

																if( $currency_position == "left" ) {

																	$popup_content .= '<span>';
																		$popup_content .= esc_attr( $currency );
																	$popup_content .= '</span>';

																}

																if( $currency_position == "left-space" ) {

																	$popup_content .= '<span>';
																		$popup_content .= esc_attr( $currency ) . ' ';
																	$popup_content .= '</span>';

																}

																$popup_content .= esc_attr( $event_price );

																if( $currency_position == "right" ) {

																	$popup_content .= '<span>';
																		$popup_content .= esc_attr( $currency );
																	$popup_content .= '</span>';

																}

																if( $currency_position == "right-space" ) {

																	$popup_content .= '<span>';
																		$popup_content .= ' ' . esc_attr( $currency );
																	$popup_content .= '</span>';

																}

															}

														$popup_content .= '</li>';

													}

												}

												if( $atts["event-status"] == 'true' ) {

													$popup_content .= '<li class="gt-status">';
														$popup_content .= eventchamp_event_status( $post_id = get_the_ID() );
													$popup_content .= '</li>';

												}

											$popup_content .= '</ul>';

										}

										$popup_content .= '<div class="gt-title">' . get_the_title() . '</div>';

										if( $atts["event-categories"] == 'true' and !empty( $categories ) or  $atts["event-locations"] == 'true' and !empty( $locations ) or $atts["event-start-date"] == 'true' and !empty( $event_start_date ) or $atts["event-venue"] == 'true' and !empty( $event_venues ) ) {

											$popup_content .= '<ul class="gt-bottom-links">';

												if( $atts["event-categories"] == 'true' and !empty( $categories ) ) {

													$popup_content .= '<li class="gt-category">';
														$popup_content .= '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 19a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h5l2 3h9a2 2 0 0 1 2 2z"></path></svg>';
														$popup_content .= '<ul>';

															foreach( $categories as $cat ) {

																if( !empty( $cat ) ) {

																	$popup_content .= '<li class="gt-category-' . esc_attr( $cat->term_id ) . '">';
																		$popup_content .= '<a href="' . get_term_link( $cat->term_id ) . '?post_type=event">' . esc_attr( $cat->name ) . '</a>';
																	$popup_content .= '</li>';

																}

															}

														$popup_content .= '</ul>';
													$popup_content .= '</li>';

												}

												if( $atts["event-locations"] == 'true' and !empty( $locations ) ) {

													$popup_content .= '<li class="gt-location">';
														$popup_content .= '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"></path><circle cx="12" cy="10" r="3"></circle></svg>';
														$popup_content .= '<ul>';

															foreach( $locations as $loc ) {

																if( !empty( $loc ) ) {

																	$popup_content .= '<li class="gt-category-' . esc_attr( $loc->term_id ) . '">';
																		$popup_content .= '<a href="' . get_term_link( $loc->term_id ) . '?post_type=event">' . esc_attr( $loc->name ) . '</a>';
																	$popup_content .= '</li>';

																}

															}

														$popup_content .= '</ul>';
													$popup_content .= '</li>';

												}

												if( $atts["event-start-date"] == 'true' and !empty( $event_start_date ) ) {

													$popup_content .= '<li class="gt-date">';
														$popup_content .= '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect><line x1="16" y1="2" x2="16" y2="6"></line><line x1="8" y1="2" x2="8" y2="6"></line><line x1="3" y1="10" x2="21" y2="10"></line></svg>';
													 	$popup_content .= '<span>' . eventchamp_global_date_converter( $date = esc_attr( $event_start_date ) ) . '</span>';
													$popup_content .= '</li>';

												}

												if( $atts["event-venue"] == 'true' and !empty( $event_venues ) ) {

													$popup_content .= '<li class="gt-venue">';
														$popup_content .= '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polygon points="1 6 1 22 8 18 16 22 23 18 23 2 16 6 8 2 1 6"></polygon><line x1="8" y1="2" x2="8" y2="18"></line><line x1="16" y1="6" x2="16" y2="22"></line></svg>';
														$popup_content .= '<ul>';

															foreach( $event_venues as $event_venue ) {

																if( !empty( $event_venue ) ) {

																	$popup_content .= '<li><a href="' . esc_url( get_the_permalink( $event_venue ) ) . '">' . get_the_title( $event_venue ) . '</a></li>';

																}

															}

														$popup_content .= '</ul>';
													$popup_content .= '</li>';

												}

											$popup_content .= '</ul>';

										}

									$popup_content .= '</div>';

								$popup_content .= '</div>';
							$popup_content .= '</div>';

							$output .= '<li data-lat="' . esc_attr( $event_lat ) . '" data-lng="' . esc_attr( $event_lng ) . '" data-icon="' . esc_url( $event_icon ) . '">';
								$output .= $popup_content;
							$output .= '</li>';

						}

					$output .= '</ul>';
				$output .= '</div>';

			}

		}
		wp_reset_postdata();

		return $output;

	}
	add_shortcode( "eventchamp_events_map", "eventchamp_events_map_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Events Map', 'eventchamp-core' ),
				"base" => "eventchamp_events_map",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/events-map.jpg',
				"description" => esc_html__( 'List the events on the map', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "textfield",
						"param_name" => "include-events",
						"heading" => esc_html__( 'Include Events', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-events",
						"heading" => esc_html__( 'Exclude Events', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "hide-expired",
						"heading" => esc_html__( 'Hide Expired Events', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-categories",
						"heading" => esc_html__( 'Exclude Categories', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-locations",
						"heading" => esc_html__( 'Exclude Locations', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-organizers",
						"heading" => esc_html__( 'Exclude Organizers', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-tags",
						"heading" => esc_html__( 'Exclude Tags', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-categories",
						"heading" => esc_html__( 'Include Categories', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-locations",
						"heading" => esc_html__( 'Include Locations', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-organizers",
						"heading" => esc_html__( 'Include Organizers', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-tags",
						"heading" => esc_html__( 'Include Tag', 'eventchamp-core' ),
						"description" => esc_html__( 'Example: Event', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "map-height",
						"heading" => esc_html__( 'Map Height', 'eventchamp-core' ),
						"description" => esc_html__( 'If you want to make it full height, enter 100vh value. Default: 450px', 'eventchamp-core' ),
						"group" => esc_html__( 'Map', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "map-style",
						"heading" => esc_html__( 'Map Style', 'eventchamp-core' ),
						"group" => esc_html__( 'Map', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => '1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => '2',
							esc_html__( 'Style 3', 'eventchamp-core' ) => '3',
							esc_html__( 'Style 4', 'eventchamp-core' ) => '4',
							esc_html__( 'Style 5', 'eventchamp-core' ) => '5',
							esc_html__( 'Style 6', 'eventchamp-core' ) => '6',
							esc_html__( 'Style 7', 'eventchamp-core' ) => '7',
							esc_html__( 'Style 8', 'eventchamp-core' ) => '8',
							esc_html__( 'Style 9', 'eventchamp-core' ) => '9',
							esc_html__( 'Style 10', 'eventchamp-core' ) => '10',
							esc_html__( 'Style 11', 'eventchamp-core' ) => '11',
							esc_html__( 'Style 12', 'eventchamp-core' ) => '12',
							esc_html__( 'Style 13', 'eventchamp-core' ) => '13',
							esc_html__( 'Style 14', 'eventchamp-core' ) => '14',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "map-lat",
						"heading" => esc_html__( 'Map Lat', 'eventchamp-core' ),
						"description" => esc_html__( 'The map will open on this lat coordinate.', 'eventchamp-core' ),
						"group" => esc_html__( 'Map', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "map-lng",
						"heading" => esc_html__( 'Map Lng', 'eventchamp-core' ),
						"description" => esc_html__( 'The map will open on this lng coordinate.', 'eventchamp-core' ),
						"group" => esc_html__( 'Map', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "map-zoom",
						"heading" => esc_html__( 'Map Zoom', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: 13', 'eventchamp-core' ),
						"group" => esc_html__( 'Map', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "map-zoom-control",
						"heading" => esc_html__( 'Map Zoom Control', 'eventchamp-core' ),
						"group" => esc_html__( 'Map', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "attach_image",
						"param_name" => "map-icon",
						"heading" => esc_html__( 'Map Icon', 'eventchamp-core' ),
						"description" => esc_html__( 'If an event has not any map icon, this icon will show on the map.', 'eventchamp-core' ),
						"group" => esc_html__( 'Map', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "map-type",
						"heading" => esc_html__( 'Map Type', 'eventchamp-core' ),
						"group" => esc_html__( 'Map', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "map-scale",
						"heading" => esc_html__( 'Map Scale', 'eventchamp-core' ),
						"group" => esc_html__( 'Map', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "map-fullscreen",
						"heading" => esc_html__( 'Map Fullscreen', 'eventchamp-core' ),
						"group" => esc_html__( 'Map', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "map-streets",
						"heading" => esc_html__( 'Map Streets', 'eventchamp-core' ),
						"group" => esc_html__( 'Map', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "event-categories",
						"heading" => esc_html__( 'Categories', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "event-locations",
						"heading" => esc_html__( 'Locations', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "event-venue",
						"heading" => esc_html__( 'Venue', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "event-start-date",
						"heading" => esc_html__( 'Start Date', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "event-status",
						"heading" => esc_html__( 'Status', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "event-price",
						"heading" => esc_html__( 'Price', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
				),
			)
		);

	}

}