<?php
/*======
*
* Events Carousel
*
======*/
if( !function_exists( 'eventchamp_events_list_output' ) ) {

	function eventchamp_events_list_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'eventcount' => '',
				'eventids' => '',
				'excludeevents' => '',
				'offset' => '',
				'ordertype' => '',
				'sortby' => '',
				'hideexpired' => '',
				'show-expired-events' => '',
				'excludecategories' => '',
				'exclude-locations' => '',
				'exclude-organizers' => '',
				'exclude-tags' => '',
				'includecategories' => '',
				'include-locations' => '',
				'include-organizers' => '',
				'include-tags' => '',
				'style' => '',
				'allbutton' => '',
				'price' => '',
				'status' => '',
				'category' => '',
				'location' => '',
				'venue' => '',
				'organizer' => '',
				'date' => '',
				'start-time' => '',
				'end-date' => '',
				'end-time' => '',
				'ticket-amount' => '',
				'excerpt' => '',
				'column' => '',
				'slider-space' => '',
				'autoplay' => '',
				'slider-autoplay-delay' => '',
				'loopstatus' => '',
				'slider-slide-speed' => '',
				'slider-centered-slides' => '',
				'slider-direction' => '',
				'slider-effect' => '',
				'slider-free-mode' => '',
				'navbuttons' => '',
			), $atts
		);

		/*====== Expired Events Status ======*/
		if( !empty( $atts['hideexpired'] ) ) {

			$hideexpired = esc_attr( $atts["hideexpired"] );

		} else {

			$hideexpired = "false";

		}

		/*====== Style ======*/
		if( !empty( $atts['style'] ) ) {

			$style = esc_attr( $atts["style"] );

		} else {

			$style = "style1";

		}

		/*====== Column ======*/
		if( empty( $atts["column"] ) ) {

			$atts["column"] = "1";

		}

		/*====== Column Space ======*/
		if( empty( $atts["slider-space"] ) ) {

			$atts["slider-space"] = "0";

		}

		/*====== Price Status ======*/
		if( $atts["price"] == "true" ) {

			$price_status = "true";

		} else {

			$price_status = "false";

		}

		/*====== Status Status ======*/
		if( $atts["status"] == "true" ) {

			$status_status = "true";

		} else {

			$status_status = "false";

		}

		/*====== Category Status ======*/
		if( $atts["category"] == "true" ) {

			$category_status = "true";

		} else {

			$category_status = "false";

		}

		/*====== Location Status ======*/
		if( $atts["location"] == "true" ) {

			$location_status = "true";

		} else {

			$location_status = "false";

		}

		/*====== Venue Status ======*/
		if( $atts["venue"] == "true" ) {

			$venue_status = "true";

		} else {

			$venue_status = "false";

		}

		/*====== Organizer Status ======*/
		if( $atts["organizer"] == "true" ) {

			$organizer_status = "true";

		} else {

			$organizer_status = "false";

		}

		/*====== Ticket Amount Status ======*/
		if( $atts["ticket-amount"] == "true" ) {

			$ticket_amount_status = "true";

		} else {

			$ticket_amount_status = "false";

		}

		/*====== Start Date Status ======*/
		if( $atts["date"] == "true" ) {

			$date_status = "true";

		} else {

			$date_status = "false";

		}

		/*====== Start Time Status ======*/
		if( $atts["start-time"] == "true" ) {

			$start_time_status = "true";

		} else {

			$start_time_status = "false";

		}

		/*====== End Date Status ======*/
		if( $atts["end-date"] == "true" ) {

			$end_date_status = "true";

		} else {

			$end_date_status = "false";

		}

		/*====== End Time Status ======*/
		if( $atts["end-time"] == "true" ) {

			$end_time_status = "true";

		} else {

			$end_time_status = "false";

		}

		/*====== Column Space ======*/
		if( empty( $atts["slider-space"] ) ) {

			$atts["slider-space"] = "30";

		}

		/*====== Slider Autoplay ======*/
		if( empty( $atts["autoplay"] ) ) {

			$atts["autoplay"] = "false";

		}

		/*====== Slider Autoplay Delay ======*/
		if( empty( $atts["slider-autoplay-delay"] ) ) {

			$atts["slider-autoplay-delay"] = "15000";

		}

		/*====== Slider Loop ======*/
		if( empty( $atts["loopstatus"] ) ) {

			$atts["loopstatus"] = "false";

		}

		/*====== Slider Slide Speed ======*/
		if( empty( $atts["slider-slide-speed"] ) ) {

			$atts["slider-slide-speed"] = "1500";

		}

		/*====== Centered Slides ======*/
		if( empty( $atts["slider-centered-slides"] ) ) {

			$atts["slider-centered-slides"] = "false";

		}

		/*====== Slider Direction ======*/
		if( empty( $atts["slider-direction"] ) ) {

			$atts["slider-direction"] = "horizontal";

		}

		/*====== Slider Effect ======*/
		if( empty( $atts["slider-effect"] ) ) {

			$atts["slider-effect"] = "slide";

		}

		/*====== Slider Free Mode ======*/
		if( empty( $atts["slider-free-mode"] ) ) {

			$atts["slider-free-mode"] = "false";

		}

		/*====== Navigation ======*/
		if( empty( $atts["navbuttons"] ) ) {

			$atts["navbuttons"] = "false";

		}

		/*====== Excerpt Status ======*/
		if( $atts["excerpt"] == "true" ) {

			$excerpt_status = "true";

		} else {

			$excerpt_status = "false";

		}

		/*====== Exclude Categories ======*/
		$exclude_category_array = "";

		if( !empty( $atts['excludecategories'] ) ) {

			$exclude_categories = $atts['excludecategories'];
			$exclude_categories = explode( ',', $exclude_categories );

		} else {

			$exclude_categories = "";

		}

		if( !empty( $exclude_categories ) ) {

			$exclude_category_array = array(
				'taxonomy' => 'eventcat',
				'field' => 'term_id',
				'terms' => $exclude_categories,
				'operator' => 'NOT IN',
			);

		}

		/*====== Exclude Locations ======*/
		$exclude_location_array = "";

		if( !empty( $atts['exclude-locations'] ) ) {

			$exclude_locations = $atts['exclude-locations'];
			$exclude_locations = explode( ',', $exclude_locations );

		} else {

			$exclude_locations = "";

		}

		if( !empty( $exclude_locations ) ) {

			$exclude_location_array = array(
				'taxonomy' => 'location',
				'field' => 'term_id',
				'terms' => $exclude_locations,
				'operator' => 'NOT IN',
			);

		}

		/*====== Exclude Organizers ======*/
		$exclude_organizer_array = "";

		if( !empty( $atts['exclude-organizers'] ) ) {

			$exclude_organizers = $atts['exclude-organizers'];
			$exclude_organizers = explode( ',', $exclude_organizers );

		} else {

			$exclude_organizers = "";

		}

		if( !empty( $exclude_organizers ) ) {

			$exclude_organizer_array = array(
				'taxonomy' => 'organizer',
				'field' => 'term_id',
				'terms' => $exclude_organizers,
				'operator' => 'NOT IN',
			);

		}

		/*====== Exclude Tags ======*/
		$exclude_tag_array = "";

		if( !empty( $atts['exclude-tags'] ) ) {

			$exclude_tags = $atts['exclude-tags'];
			$exclude_tags = explode( ',', $exclude_tags );

		} else {

			$exclude_tags = "";

		}

		if( !empty( $exclude_tags ) ) {

			$exclude_tag_array = array(
				'taxonomy' => 'event_tags',
				'field' => 'term_id',
				'terms' => $exclude_tags,
				'operator' => 'NOT IN',
			);

		}

		/*====== Include Categories ======*/
		$include_category_array = "";

		if( !empty( $atts['includecategories'] ) ) {

			$include_categories = $atts['includecategories'];
			$include_categories = explode( ',', $include_categories );

		} else {

			$include_categories = "";

		}

		if( !empty( $include_categories ) ) {

			$include_category_array = array(
				'taxonomy' => 'eventcat',
				'field' => 'term_id',
				'terms' => $include_categories,
				'operator' => 'IN',
			);

		}

		/*====== Include Locations ======*/
		$include_location_array = "";

		if( !empty( $atts['include-locations'] ) ) {

			$include_locations = $atts['include-locations'];
			$include_locations = explode( ',', $include_locations );

		} else {

			$include_locations = "";

		}

		if( !empty( $include_locations ) ) {

			$include_location_array = array(
				'taxonomy' => 'location',
				'field' => 'term_id',
				'terms' => $include_locations,
				'operator' => 'IN',
			);

		}

		/*====== Include Organizers ======*/
		$include_organizers_array = "";

		if( !empty( $atts['include-organizers'] ) ) {

			$include_organizers = $atts['include-organizers'];
			$include_organizers = explode( ',', $include_organizers );

		} else {

			$include_organizers = "";

		}

		if( !empty( $include_organizers ) ) {

			$include_organizers_array = array(
				'taxonomy' => 'organizer',
				'field' => 'term_id',
				'terms' => $include_organizers,
				'operator' => 'IN',
			);

		}

		/*====== Include Tags ======*/
		$include_tags_array = "";

		if( !empty( $atts['include-tags'] ) ) {

			$include_tags = $atts['include-tags'];
			$include_tags = explode( ',', $include_tags );

		} else {

			$include_tags = "";

		}

		if( !empty( $include_tags ) ) {

			$include_tags_array = array(
				'taxonomy' => 'event_tags',
				'field' => 'term_id',
				'terms' => $include_tags,
				'operator' => 'IN',
			);

		}

		/*====== Main Query ======*/
		$arg = array(
			'post_status' => 'publish',
			'post_type' => 'event',
			'tax_query' => array (
				'relation' => 'AND',
				$include_location_array,
				$include_category_array,
				$include_organizers_array,
				$include_tags_array,
				$exclude_category_array,
				$exclude_location_array,
				$exclude_organizer_array,
				$exclude_tag_array,
			)
		);

		/*====== Event Count ======*/
		if( !empty( $atts["eventcount"] ) ) {

			$extra_query = array(
				'posts_per_page' => $atts["eventcount"],
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Offset ======*/
		if( !empty( $atts["offset"] ) ) {

			$extra_query = array(
				'offset' => $atts["offset"],
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Include Events ======*/
		if( !empty( $atts['eventids'] ) ) {

			$eventids = $atts['eventids'];
			$include_events = explode( ',', $eventids );

		} else {

			$include_events = "";

		}

		if( !empty( $include_events ) ) {

			$extra_query = array(
				'post__in' => $include_events,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Exclude Events ======*/
		$excludeevents = $atts['excludeevents'];

		if( $hideexpired == "false" ) {

			if( !empty( $excludeevents ) ) {

				$exclude_events = $excludeevents;
				$exclude_events = explode( ',', $exclude_events );

			} else {

				$exclude_events = array();

			}

			if( !empty( $exclude_events ) ) {

				$extra_query = array(
					'post__not_in' => $exclude_events,
				);
				$arg = wp_parse_args( $arg, $extra_query );

			}

		}

		/*====== Add Expired Events in Exclude Events ======*/
		if( $hideexpired == "true" ) {

			$expired_ids = eventchamp_expired_event_ids();

		} else {

			$expired_ids = array();

		}

		if( !empty( $expired_ids ) ) {

			$excludeevents = $atts['excludeevents'];

			if( !empty( $excludeevents ) ) {

				$exclude_events = $excludeevents;
				$exclude_events = explode( ',', $exclude_events );

			} else {

				$exclude_events = array();

			}

			$excludeevents_with_expired = array_merge( $exclude_events, $expired_ids );

			$extra_query = array(
				'post__not_in' => $excludeevents_with_expired,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Show Expired Events ======*/
		if( $atts["show-expired-events"] == "true" ) {

			$expired_events = eventchamp_expired_event_ids();

			$extra_query = array(
				'post__in' => $expired_events,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== Order & Order By ======*/
		if( $atts["ordertype"] == "ASC" ) {

			$order = "ASC";

		} else {

			$order = "DESC";

		}

		if( !empty( $order ) ) {

			$extra_query = array(
				'order' => $order,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		if( $atts["sortby"] == "popular-comment" ) {

			$order_by = "comment_count";

		} elseif( $atts["sortby"] == "id" ) {

			$order_by = "ID";

		} elseif( $atts["sortby"] == "popular" ) {

			$order_by = "comment_count";

		} elseif( $atts["sortby"] == "title" ) {

			$order_by = "title";

		} elseif( $atts["sortby"] == "menu_order" ) {

			$order_by = "menu_order";

		} elseif( $atts["sortby"] == "rand" ) {

			$order_by = "rand";

		} elseif( $atts["sortby"] == "none" ) {

			$order_by = "none";

		} elseif( $atts["sortby"] == "post__in" ) {

			$order_by = "post__in";

		} elseif( $atts["sortby"] == "event-date" ) {

			$order_by = "";

			$extra_query = array(
				'meta_query' => array(
					'relation' => 'AND',
					'event_start_date_clause' => array(
						'key' => 'event_start_date',
					), 
					'event_start_time_clause' => array(
						'key' => 'event_start_time',
					),
				),
				'orderby' => array(
					'event_start_date_clause' => $order,
					'event_start_time_clause' => $order,
				),
			);
			$arg = wp_parse_args( $arg, $extra_query );

		} elseif( $atts["sortby"] == "price" ) {

			$order_by = "";

			$extra_query = array(
				'meta_query' => array(
					'relation' => 'AND',
					'event_main_price_clause' => array(
						'key' => 'event-ticket-main-price',
						'type' => 'NUMERIC',
					),
				),
				'orderby' => array(
					'event_main_price_clause' => $order,
				),
			);
			$arg = wp_parse_args( $arg, $extra_query );

		} else {

			$order_by = "date";

		}

		if( !empty( $order_by ) ) {

			$extra_query = array(
				'orderby' => $order_by,
			);
			$arg = wp_parse_args( $arg, $extra_query );

		}

		/*====== HTML Output ======*/
		$output = "";

		$wp_query = new WP_Query( $arg );

		if( !empty( $wp_query ) ) {

			if( $wp_query->have_posts() ) {

				$output .= '<div class="gt-events-carousel">';
					$output .= '<div class="swiper-container gt-swiper-slider" data-gt-item="' . esc_attr( $atts["column"] ) . '" data-gt-item-space="' . esc_attr( $atts["slider-space"] ) . '" data-gt-loop="' . esc_attr( $atts["loopstatus"] ) . '" data-gt-speed="' . esc_attr( $atts["slider-slide-speed"] ) . '" data-gt-direction="' . esc_attr( $atts["slider-direction"] ) . '" data-gt-effect="' . esc_attr( $atts["slider-effect"] ) . '" data-gt-centered-slides="' . esc_attr( $atts["slider-centered-slides"] ) . '" data-gt-free-mode="' . esc_attr( $atts["slider-free-mode"] ) . '">';
						$output .= '<div class="swiper-wrapper">';

							while( $wp_query->have_posts() ) {

								$wp_query->the_post();

								if( $atts["autoplay"] == "true" ) {

									$output .= '<div class="swiper-slide" data-swiper-autoplay="' . esc_attr( $atts["slider-autoplay-delay"] ) . '">';

								} else {

									$output .= '<div class="swiper-slide">';

								}

									if( $style == "style2" ) {

										$output .= eventchamp_event_list_style_3( $post_id = get_the_ID(), $image = "true", $category = esc_attr( $category_status ), $start_date = esc_attr( $date_status ), $end_date = esc_attr( $end_date_status ), $location = esc_attr( $location_status ), $excerpt = esc_attr( $excerpt_status ), $status = esc_attr( $status_status ), $price = esc_attr( $price_status ), $venue = esc_attr( $venue_status ), $ticket_amount = esc_attr( $ticket_amount_status ), $start_time = esc_attr( $start_time_status ), $end_time = esc_attr( $end_time_status ), $organizer = esc_attr( $organizer_status ) );

									} elseif( $style == "style3" ) {

										$output .= eventchamp_event_list_style_4( $post_id = get_the_ID(), $image = "true", $category = esc_attr( $category_status ), $start_date = esc_attr( $date_status ), $end_date = esc_attr( $end_date_status ), $location = esc_attr( $location_status ), $excerpt = esc_attr( $excerpt_status ), $status = esc_attr( $status_status ), $price = esc_attr( $price_status ), $venue = esc_attr( $venue_status ), $ticket_amount = esc_attr( $ticket_amount_status ), $start_time = esc_attr( $start_time_status ), $end_time = esc_attr( $end_time_status ), $organizer = esc_attr( $organizer_status ) );

									} elseif( $style == "style4" ) {

										$output .= eventchamp_event_list_style_2( $post_id = get_the_ID(), $image = "true", $category = esc_attr( $category_status ), $start_date = esc_attr( $date_status ), $end_date = esc_attr( $end_date_status ), $location = esc_attr( $location_status ), $status = esc_attr( $status_status ), $price = esc_attr( $price_status ), $venue = esc_attr( $venue_status ), $ticket_amount = esc_attr( $ticket_amount_status ), $start_time = esc_attr( $start_time_status ), $end_time = esc_attr( $end_time_status ), $organizer = esc_attr( $organizer_status ) );

									} else {

										$output .= eventchamp_event_list_style_1( $post_id = get_the_ID(), $image = "true", $category = esc_attr( $category_status ), $start_date = esc_attr( $date_status ), $end_date = esc_attr( $end_date_status ), $location = esc_attr( $location_status ), $excerpt = esc_attr( $excerpt_status ), $status = esc_attr( $status_status ), $price = esc_attr( $price_status ), $venue = esc_attr( $venue_status ), $ticket_amount = esc_attr( $ticket_amount_status ), $start_time = esc_attr( $start_time_status ), $end_time = esc_attr( $end_time_status ), $organizer = esc_attr( $organizer_status ) );

									}

								$output .= '</div>';

							}

						$output .= '</div>';

						if( $atts["navbuttons"] == "true" or $atts["allbutton"] == "true" ) {

							$output .= '<div class="gt-pagination">';

								if( $atts["navbuttons"] == "true" ) {

									$output .= '<div class="gt-slider-prev">';
										$output .= '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="15 18 9 12 15 6"></polyline></svg>';
									$output .= '</div>';

								}

								if( $atts["allbutton"] == "true" ) {

									$output .= '<div>';
										$output .= '<a href="' . esc_url( get_post_type_archive_link( 'event' ) ) . '" class="gt-all-button">' . esc_html__( 'All Events', 'eventchamp-core' ) . '</a>';
									$output .= '</div>';

								}

								if( $atts["navbuttons"] == "true" ) {

									$output .= '<div class="gt-slider-next">';
										$output .= '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="9 18 15 12 9 6"></polyline></svg>';
									$output .= '</div>';

								}

							$output .= '</div>';

						}

					$output .= '</div>';
				$output .= '</div>';

			}

		}
		wp_reset_postdata();

		return $output;

	}
	add_shortcode( "eventchamp_events_list", "eventchamp_events_list_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Events Carousel', 'eventchamp-core' ),
				"base" => "eventchamp_events_list",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/events-carousel.jpg',
				"description" => esc_html__( 'List the events with carousel', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "textfield",
						"param_name" => "eventcount",
						"heading" => esc_html__( 'Count', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'admin_label' => true,
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "eventids",
						"heading" => esc_html__( 'Include Events', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "excludeevents",
						"heading" => esc_html__( 'Exclude Events', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "offset",
						"heading" => esc_html__( 'Offset', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "ordertype",
						"heading" => esc_html__( 'Order', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'ASC', 'eventchamp-core' ) => 'ASC',
							esc_html__( 'DESC', 'eventchamp-core' ) => 'DESC',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "sortby",
						"heading" => esc_html__( 'Order Type', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'admin_label' => true,
						"save_always" => true,
						"value" => array(
							esc_html__( 'Added Date', 'eventchamp-core' ) => 'added-date',
							esc_html__( 'Event Date', 'eventchamp-core' ) => 'event-date',
							esc_html__( 'Price', 'eventchamp-core' ) => 'price',
							esc_html__( 'Popular by Comment', 'eventchamp-core' ) => 'popular-comment',
							esc_html__( 'ID', 'eventchamp-core' ) => 'id',
							esc_html__( 'Title', 'eventchamp-core' ) => 'title',
							esc_html__( 'Menu Order', 'eventchamp-core' ) => 'menu_order',
							esc_html__( 'Random', 'eventchamp-core' ) => 'rand',
							esc_html__( 'By Include IDs', 'eventchamp-core' ) => 'post__in',
							esc_html__( 'None', 'eventchamp-core' ) => 'none',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "hideexpired",
						"heading" => esc_html__( 'Hide Expired Events', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'admin_label' => true,
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "show-expired-events",
						"heading" => esc_html__( 'Show Only Expired Events', 'eventchamp-core' ),
						"description" => esc_html__( 'If you choose this option, you can list expired events.', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'admin_label' => true,
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "excludecategories",
						"heading" => esc_html__( 'Exclude Categories', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"heading" => esc_html__( 'Exclude Locations', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"param_name" => "exclude-locations",
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-organizers",
						"heading" => esc_html__( 'Exclude Organizers', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-tags",
						"heading" => esc_html__( 'Exclude Tags', 'eventchamp-core' ),
						"description" => esc_html__( 'Example: Event', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "includecategories",
						"heading" => esc_html__( 'Include Categories', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-locations",
						"heading" => esc_html__( 'Include Locations', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-organizers",
						"heading" => esc_html__( 'Include Organizers', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-tags",
						"heading" => esc_html__( 'Include Tag', 'eventchamp-core' ),
						"description" => esc_html__( 'Example: Event', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "style",
						"heading" => esc_html__( 'Style', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'admin_label' => true,
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => 'style1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => 'style2',
							esc_html__( 'Style 3', 'eventchamp-core' ) => 'style3',
							esc_html__( 'Style 4', 'eventchamp-core' ) => 'style4',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "allbutton",
						"heading" => esc_html__( 'All Events Button', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "price",
						"heading" => esc_html__( 'Price', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "status",
						"heading" => esc_html__( 'Status', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "category",
						"heading" => esc_html__( 'Category', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "location",
						"heading" => esc_html__( 'Location', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "venue",
						"heading" => esc_html__( 'Venue', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "organizer",
						"heading" => esc_html__( 'Organizer', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "date",
						"heading" => esc_html__( 'Start Date', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "start-time",
						"heading" => esc_html__( 'Start Time', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "end-date",
						"heading" => esc_html__( 'End Date', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "end-time",
						"heading" => esc_html__( 'End Time', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "ticket-amount",
						"heading" => esc_html__( 'Ticket Amount', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "excerpt",
						"heading" => esc_html__( 'Excerpt', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "column",
						"heading" => esc_html__( 'Column', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( '1 Column', 'eventchamp-core' ) => '1',
							esc_html__( '2 Column', 'eventchamp-core' ) => '2',
							esc_html__( '3 Column', 'eventchamp-core' ) => '3',
							esc_html__( '4 Column', 'eventchamp-core' ) => '4',
							esc_html__( '5 Column', 'eventchamp-core' ) => '5',
							esc_html__( '6 Column', 'eventchamp-core' ) => '6',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-space",
						"heading" => esc_html__( 'Column Space', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( '0', 'eventchamp-core' ) => '0',
							esc_html__( '1', 'eventchamp-core' ) => '1',
							esc_html__( '2', 'eventchamp-core' ) => '2',
							esc_html__( '3', 'eventchamp-core' ) => '3',
							esc_html__( '4', 'eventchamp-core' ) => '4',
							esc_html__( '5', 'eventchamp-core' ) => '5',
							esc_html__( '10', 'eventchamp-core' ) => '10',
							esc_html__( '15', 'eventchamp-core' ) => '15',
							esc_html__( '20', 'eventchamp-core' ) => '20',
							esc_html__( '25', 'eventchamp-core' ) => '25',
							esc_html__( '30', 'eventchamp-core' ) => '30',
							esc_html__( '45', 'eventchamp-core' ) => '45',
							esc_html__( '50', 'eventchamp-core' ) => '50',
							esc_html__( '55', 'eventchamp-core' ) => '55',
							esc_html__( '60', 'eventchamp-core' ) => '60',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "autoplay",
						"heading" => esc_html__( 'Slider Autoplay', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "slider-autoplay-delay",
						"heading" => esc_html__( 'Slider Autoplay Delay', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: 15000', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "loopstatus",
						"heading" => esc_html__( 'Slider Loop', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "slider-slide-speed",
						"heading" => esc_html__( 'Slide Speed', 'eventchamp-core' ),
						"description" => esc_html__( 'Duration of transition between the slides. Default: 1500', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-centered-slides",
						"heading" => esc_html__( 'Centered Slides', 'eventchamp-core' ),
						"description" => esc_html__( 'If you choose true, then active slide will be centered, not always on the left side.', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-direction",
						"heading" => esc_html__( 'Slider Direction', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Horizontal', 'eventchamp-core' ) => 'horizontal',
							esc_html__( 'Vertical', 'eventchamp-core' ) => 'vertical',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-effect",
						"heading" => esc_html__( 'Slider Effect', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Slide', 'eventchamp-core' ) => 'slide',
							esc_html__( 'Fade', 'eventchamp-core' ) => 'fade',
							esc_html__( 'Cube', 'eventchamp-core' ) => 'cube',
							esc_html__( 'Coverflow', 'eventchamp-core' ) => 'coverflow',
							esc_html__( 'Flip', 'eventchamp-core' ) => 'flip',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-free-mode",
						"heading" => esc_html__( 'Free Mode', 'eventchamp-core' ),
						"description" => esc_html__( 'If true then slides will not have fixed positions', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "navbuttons",
						"heading" => esc_html__( 'Navigation', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
				),
			)
		);

	}

}