<?php
/*======
*
* Eventchamp Slider
*
======*/
if( !function_exists( 'eventchamp_slider_output' ) ) {

	function eventchamp_slider_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'slides' => '',
				'separator' => '',
				'separator-color' => '',
				'slider-height' => '100vh',
				'slider-column' => '1',
				'slider-space' => '0',
				'slider-autoplay' => 'false',
				'slider-loop' => 'false',
				'slider-slide-speed' => '1000',
				'slider-centered-slides' => 'false',
				'slider-direction' => 'horizontal',
				'slider-effect' => 'slide',
				'slider-free-mode' => 'false',
				'navigation' => 'false',
				'navigation-style' => 'style-1',
				'pagination' => 'false',
				'pagination-style' => 'style-1',
			), $atts
		);

		/*====== Lazy Load ======*/
		$lazy_load = ot_get_option( 'lazy-load', 'off' );

		/*====== Slides ======*/
		$slides = vc_param_group_parse_atts( $atts['slides'] );

		/*====== Separator Color ======*/
		if( empty( $atts["separator-color"] ) ) {

			$separator_color = "#FFFFFF";

		} else {

			$separator_color = esc_attr( $atts["separator-color"] );

		}

		/*====== Slider Height ======*/
		if( empty( $atts["slider-height"] ) ) {

			$atts["slider-height"] = "100vh";

		}

		/*====== Column ======*/
		if( empty( $atts["slider-column"] ) ) {

			$atts["slider-column"] = "1";

		}

		/*====== Column Space ======*/
		if( empty( $atts["slider-space"] ) ) {

			$atts["slider-space"] = "0";

		}

		/*====== Slider Autoplay ======*/
		if( empty( $atts["slider-autoplay"] ) ) {

			$atts["slider-autoplay"] = "false";

		}

		/*====== Slider Loop ======*/
		if( empty( $atts["slider-loop"] ) ) {

			$atts["slider-loop"] = "false";

		}

		/*====== Slider Slide Speed ======*/
		if( empty( $atts["slider-slide-speed"] ) ) {

			$atts["slider-slide-speed"] = "1000";

		}

		/*====== Slider Direction ======*/
		if( empty( $atts["slider-direction"] ) ) {

			$atts["slider-direction"] = "horizontal";

		}

		/*====== Slider Effect ======*/
		if( empty( $atts["slider-effect"] ) ) {

			$atts["slider-effect"] = "slide";

		}

		/*====== Centered Slides ======*/
		if( empty( $atts["slider-centered-slides"] ) ) {

			$atts["slider-centered-slides"] = "false";

		}

		/*====== Slider Free Mode ======*/
		if( empty( $atts["slider-free-mode"] ) ) {

			$atts["slider-free-mode"] = "false";

		}

		/*====== HTML Output ======*/
		$output = '';

		if( !empty( $slides ) ) {

			$output .= '<div class="gt-eventchamp-slider" style="height:' . esc_attr( $atts["slider-height"] ) . ';">';
				$output .= '<div class="swiper-container gt-swiper-slider" data-gt-item="' . esc_attr( $atts["slider-column"] ) . '" data-gt-item-space="' . esc_attr( $atts["slider-space"] ) . '" data-gt-loop="' . esc_attr( $atts["slider-loop"] ) . '" data-gt-speed="' . esc_attr( $atts["slider-slide-speed"] ) . '" data-gt-direction="' . esc_attr( $atts["slider-direction"] ) . '" data-gt-effect="' . esc_attr( $atts["slider-effect"] ) . '" data-gt-centered-slides="' . esc_attr( $atts["slider-centered-slides"] ) . '" data-gt-free-mode="' . esc_attr( $atts["slider-free-mode"] ) . '">';
					$output .= '<div class="swiper-wrapper">';

						foreach( $slides as $slide ) {

							if( !empty( $slide ) ) {

								/*====== Autoplay Delay ======*/
								if( empty( $slide["autoplay-delay"] ) ) {

									$slide["autoplay-delay"] == "15000";

								}

								/*====== Opacity Color ======*/
								if( empty( $slide["opacity-color"] ) ) {

									$slide["opacity-color"] = "#000000";

								}

								/*====== Background Image Position ======*/
								if( empty( $slide["background-image-position"] ) ) {

									$slide["background-image-position"] = "default";

								}

								/*====== Background Image Attachment ======*/
								if( empty( $slide["background-image-attachment"] ) ) {

									$slide["background-image-attachment"] = "default";

								}

								/*====== Background Image Size ======*/
								if( empty( $slide["background-image-size"] ) ) {

									$slide["background-image-size"] = "default";

								}

								/*====== Background Image Repeat ======*/
								if( empty( $slide["background-image-repeat"] ) ) {

									$slide["background-image-repeat"] = "default";

								}

								if( $atts["slider-autoplay"] == "true" ) {

									$output .= '<div class="swiper-slide" data-swiper-autoplay="' . esc_attr( $slide["autoplay-delay"] ) . '">';

								} else {

									$output .= '<div class="swiper-slide">';

								}

									if( !empty( $slide["background-image"] ) ) {

										if( $lazy_load == "on" ) {

											$output .= '<div class="gt-slide-inner gt-background-position-' . esc_attr( $slide["background-image-position"] ) . ' gt-background-attachment-' . esc_attr( $slide["background-image-attachment"] ) . ' gt-background-size-' . esc_attr( $slide["background-image-size"] ) . ' gt-background-repeat-' . esc_attr( $slide["background-image-repeat"] ) . ' gt-lazy-load" data-background="' . esc_url( wp_get_attachment_image_src( $slide["background-image"], 'eventchamp-event-slider' )[0] ) . '">';

										} else {

											$output .= '<div class="gt-slide-inner gt-background-position-' . esc_attr( $slide["background-image-position"] ) . ' gt-background-attachment-' . esc_attr( $slide["background-image-attachment"] ) . ' gt-background-size-' . esc_attr( $slide["background-image-size"] ) . ' gt-background-repeat-' . esc_attr( $slide["background-image-repeat"] ) . '" style="background-image:url(' . esc_url( wp_get_attachment_image_src( $slide["background-image"], 'eventchamp-event-slider' )[0] ) . ');">';

										}

									} else {

										$output .= '<div class="gt-slide-inner">';

									}

										if( $slide["opacity"] == "true" ) {

											$output .= '<div class="gt-opacity" style="opacity: ' . esc_attr( $slide["opacity-value"] ) . '; background-color: ' . esc_attr( $slide["opacity-color"] ) . ';"></div>';

										}

										$output .= '<div class="gt-slider-content">';

											if( !empty( $slide["subtitle"] ) ) {

												$output .= '<div class="gt-subtitle">' . esc_attr( $slide["subtitle"] ) . '</div>';

											}

											if( !empty( $slide["primary-title"] ) or !empty( $slide["secondary-title"] ) ) {

												$output .= '<div class="gt-title">';

													if( !empty( $slide["primary-title"] ) ) {

														$output .= '<span class="gt-primary">' . esc_attr( $slide["primary-title"] ) . '</span>';

													}

													if( !empty( $slide["secondary-title"] ) ) {

														$output .= '<span class="gt-secondary">' . esc_attr( $slide["secondary-title"] ) . '</span>';

													}

												$output .= '</div>';

											}

											if( !empty( $slide["text"] ) ) {

												$output .= '<div class="gt-text">' . wpautop( esc_attr( $slide["text"] ) ) . '</div>';

											}

											if( !empty( $slide["button-1"] ) ) {

												$output .= '<div class="gt-buttons">';

													if( !empty( $slide["button-1"] ) ) {

														if( $slide["button-1-status"] == "true" ) {

															$href = $slide["button-1"];
															$href = vc_build_link( $href );

															if( !empty( $href["target"] ) ) {

																$target = $href["target"];

															} else {

																$target = "_parent";

															}

															if( !empty( $href["title"] ) ) {

																$output .= '<a href="' . esc_url( $href["url"] ) . '" target="' . esc_attr( $target ) . '">';
																	$output .= '<span>' . esc_attr( $href["title"] ) . '</span>';
																$output .= '</a>';

															}

														}

													}

													if( !empty( $slide["button-2"] ) ) {

														if( $slide["button-2-status"] == "true" ) {

															$href = $slide["button-2"];
															$href = vc_build_link( $href );

															if( !empty( $href["target"] ) ) {

																$target = $href["target"];

															} else {

																$target = "_parent";

															}

															if( !empty( $href["title"] ) ) {

																$output .= '<a href="' . esc_url( $href["url"] ) . '" target="' . esc_attr( $target ) . '">';
																	$output .= '<span>' . esc_attr( $href["title"] ) . '</span>';
																$output .= '</a>';

															}

														}

													}

												$output .= '</div>';

											}

										$output .= '</div>';
									$output .= '</div>';
								$output .= '</div>';

							}

						}

					$output .= '</div>';

					if( $atts["separator"] == "style-1" ) {

						$output .= '<div class="gt-separator gt-style-1">';
							$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1480 51" preserveAspectRatio="none"><path d="M1480 51V8c-17 0-34 2.3-47 6.8l-29.4 10.3c-25.8 9-68.1 9-93.9 0l-29.4-10.3c-25.8-9-68.1-9-93.9 0L1157 25.1c-25.8 9-68.1 9-93.9 0l-29.4-10.3c-25.8-9-68.1-9-93.9 0l-29.4 10.3c-25.8 9-68.1 9-93.9 0L787 14.8c-25.8-9-68.1-9-93.9 0l-29.4 10.3c-25.8 9-68.1 9-93.9 0l-29.4-10.3c-25.8-9-68.1-9-93.9 0l-29.4 10.3c-25.8 9-68.1 9-93.9 0l-29.5-10.3c-25.8-9-68.1-9-93.9 0l-29.4 10.3c-25.8 9-68.1 9-93.9 0L47 14.8C34 10.3 17 8 0 8v43h1480z"></path></svg>';
						$output .= '</div>';

					} elseif( $atts["separator"] == "style-2" ) {

						$output .= '<div class="gt-separator gt-style-2">';
							$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1480 103.5" preserveAspectRatio="none"><path d="M1480 103.5V7.7c-6.8.2-13.5.6-20.3.7-45.5 1.1-90.4 6.9-134 20.1-23.9 7.2-47 16.8-70.6 24.8-14 4.7-28.2 8.7-42.4 12.8-23.7 6.8-47.9 9.9-72.4 11.3-17 1-34.3 2.7-51.2 1.1-26.2-2.4-52.3-6.5-78.1-11.2-30.8-5.7-60.1-17-89.3-28.2C865.3 17.4 806.6 7.1 746.3 7c-57.8-.1-115.1 5.7-170.4 24-22.1 7.3-43.6 16.1-65.7 23.6-38.6 13.1-78.2 21.1-118.9 23.7-66.6 4.2-130.7-7.7-192.7-31.8-40.5-15.8-81.9-28.1-125-33.8C49.3 9.4 24.7 7.1 0 7.7v95.8h1480z"/></svg>';
						$output .= '</div>';

					} elseif( $atts["separator"] == "style-3" ) {

						$output .= '<div class="gt-separator gt-style-3">';
							$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1480 142.3" preserveAspectRatio="none"><path d="M704.6 52.7C430.3 1.4 174.9 23 0 43.7v98.7h1480V43.7c-192.5 22.8-441.9 71.3-775.4 9z"/></svg>';
						$output .= '</div>';

					} elseif( $atts["separator"] == "style-4" ) {

						$output .= '<div class="gt-separator gt-style-4">';
							$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1480 117"  preserveAspectRatio="none"><path d="M0 24.5c246.7 46.3 493.3 69.4 740 69.4s493.3-23.1 740-69.4V117H0V24.5z"/></svg>';
						$output .= '</div>';

					} elseif( $atts["separator"] == "style-5" ) {

						$output .= '<div class="gt-separator gt-style-5">';
							$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1480 160"><path d="M0 160L1480 12v148z"/></svg>';
						$output .= '</div>';

					} elseif( $atts["separator"] == "style-6" ) {

						$output .= '<div class="gt-separator gt-style-6">';
							$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1480 60"><path d="M74 22.5C33.1 22.5 0 39.3 0 60h148c0-20.7-33.1-37.5-74-37.5zM222 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM370 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM518 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM666 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM814 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM962 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM1110 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM1258 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM1406 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5z"/></svg>';
						$output .= '</div>';

					} elseif( $atts["separator"] == "style-7" ) {

						$output .= '<div class="gt-separator gt-style-7">';
							$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1480 60"><path d="M43.5 22L0 60h87.1zM130.6 22L87.1 60h87zM217.6 22l-43.5 38h87.1zM304.7 22l-43.5 38h87zM391.8 22l-43.6 38h87.1zM478.8 22l-43.5 38h87.1zM565.9 22l-43.5 38h87zM652.9 22l-43.5 38h87.1zM740 22l-43.5 38h87zM827.1 22l-43.6 38h87.1zM914.1 22l-43.5 38h87zM1001.2 22l-43.6 38h87.1zM1088.2 22l-43.5 38h87.1zM1175.3 22l-43.5 38h87zM1262.4 22l-43.6 38h87.1zM1349.4 22l-43.5 38h87zM1436.5 22l-43.6 38h87.1z"/></svg>';
						$output .= '</div>';

					}

					if( $atts["pagination"] == "true" ) {

						if( $atts["separator"] !== "false" ) {

							$output .= '<div class="swiper-pagination gt-slider-pagination gt-' . esc_attr( $atts["pagination-style"] ) . '"></div>';

						} else {

							$output .= '<div class="swiper-pagination gt-slider-pagination gt-' . esc_attr( $atts["pagination-style"] ) . '"></div>';

						}

					}

					if( $atts["navigation"] == "true" ) {

						$output .= '<div class="gt-slider-prev gt-slider-control gt-' . esc_attr( $atts["navigation-style"] ) . '">';
							$output .= '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="15 18 9 12 15 6"></polyline></svg>';
						$output .= '</div>';
						$output .= '<div class="gt-slider-next gt-slider-control gt-' . esc_attr( $atts["navigation-style"] ) . '">';
							$output .= '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="9 18 15 12 9 6"></polyline></svg>';
						$output .= '</div>';

					}

				$output .= '</div>';
			$output .= '</div>';

		}

		return $output;

	}
	add_shortcode( "eventchamp_slider", "eventchamp_slider_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Eventchamp Slider', 'eventchamp-core' ),
				"base" => "eventchamp_slider",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/eventchamp-slider.jpg',
				"description" => esc_html__( 'A creative slider', 'eventchamp-core' ),
				"params" => array(
					array(
						'type' => 'param_group',
						'param_name' => 'slides',
						"heading" => esc_html__( 'Slides', 'eventchamp-core' ),
						"description" => esc_html__( 'You can create slides from this panel.', 'eventchamp-core' ),
						"save_always" => true,
						'params' => array(
							array(
								"type" => "textfield",
								"param_name" => "primary-title",
								"heading" => esc_html__( 'Primary Title', 'eventchamp-core' ),
								'admin_label' => true,
								'save_always' => true,
							),
							array(
								"type" => "textfield",
								"param_name" => "secondary-title",
								"heading" => esc_html__( 'Secondary Title', 'eventchamp-core' ),
								'admin_label' => true,
								'save_always' => true,
							),
							array(
								"type" => "textfield",
								"param_name" => "subtitle",
								"heading" => esc_html__( 'Subtitle', 'eventchamp-core' ),
								'admin_label' => true,
								'save_always' => true,
							),
							array(
								"type" => "textfield",
								"param_name" => "text",
								"heading" => esc_html__( 'Text', 'eventchamp-core' ),
								'save_always' => true,
							),
							array(
								"type" => "dropdown",
								"param_name" => "button-1-status",
								"heading" => esc_html__( 'Button 1 Status', 'eventchamp-core' ),
								"save_always" => true,
								"value" => array(
									esc_html__( 'False', 'eventchamp-core' ) => 'false',
									esc_html__( 'True', 'eventchamp-core' ) => 'true',
								),
							),
							array(
								"type" => "vc_link",
								"param_name" => "button-1",
								"heading" => esc_html__( 'Button 1', 'eventchamp-core' ),
								'save_always' => true,
							),
							array(
								"type" => "dropdown",
								"param_name" => "button-2-status",
								"heading" => esc_html__( 'Button 2 Status', 'eventchamp-core' ),
								"save_always" => true,
								"value" => array(
									esc_html__( 'False', 'eventchamp-core' ) => 'false',
									esc_html__( 'True', 'eventchamp-core' ) => 'true',
								),
							),
							array(
								"type" => "vc_link",
								"param_name" => "button-2",
								"heading" => esc_html__( 'Button 2', 'eventchamp-core' ),
								'save_always' => true,
							),
							array(
								"type" => "attach_image",
								"param_name" => "background-image",
								"heading" => esc_html__( 'Background Image', 'eventchamp-core' ),
								"description" => esc_html__( 'Recommended size: 1920x1100', 'eventchamp-core' ),
								"save_always" => true,
							),
							array(
								"type" => "dropdown",
								"param_name" => "background-image-position",
								"heading" => esc_html__( 'Background Image Position', 'eventchamp-core' ),
								"description" => esc_html__( 'Default: Center Center.', 'eventchamp-core' ),
								"save_always" => true,
								"value" => array(
									esc_html__( 'Default', 'eventchamp-core' ) => 'default',
									esc_html__( 'Initial', 'eventchamp-core' ) => 'initial',
									esc_html__( 'Inherit', 'eventchamp-core' ) => 'inherit',
									esc_html__( 'Center Center', 'eventchamp-core' ) => 'center-center',
									esc_html__( 'Center Top', 'eventchamp-core' ) => 'center-top',
									esc_html__( 'Center Bottom', 'eventchamp-core' ) => 'center-top',
									esc_html__( 'Left Top', 'eventchamp-core' ) => 'left-top',
									esc_html__( 'Left Center', 'eventchamp-core' ) => 'left-center',
									esc_html__( 'Left Bottom', 'eventchamp-core' ) => 'left-bottom',
									esc_html__( 'Right Top', 'eventchamp-core' ) => 'right-top',
									esc_html__( 'Right Center', 'eventchamp-core' ) => 'right-center',
									esc_html__( 'Right Bottom', 'eventchamp-core' ) => 'right-bottom',
								),
							),
							array(
								"type" => "dropdown",
								"param_name" => "background-image-attachment",
								"heading" => esc_html__( 'Background Image Attachment', 'eventchamp-core' ),
								"description" => esc_html__( 'Default: Scroll', 'eventchamp-core' ),
								"save_always" => true,
								"value" => array(
									esc_html__( 'Default', 'eventchamp-core' ) => 'default',
									esc_html__( 'Initial', 'eventchamp-core' ) => "initial",
									esc_html__( 'Inherit', 'eventchamp-core' ) => "inherit",
									esc_html__( 'Scroll', 'eventchamp-core' ) => "scroll",
									esc_html__( 'Fixed', 'eventchamp-core' ) => "fixed",
									esc_html__( 'Local', 'eventchamp-core' ) => "local",
								),
							),
							array(
								"type" => "dropdown",
								"param_name" => "background-image-size",
								"heading" => esc_html__( 'Background Image Size', 'eventchamp-core' ),
								"description" => esc_html__( 'Default: Cover', 'eventchamp-core' ),
								"save_always" => true,
								"value" => array(
									esc_html__( 'Default', 'eventchamp-core' ) => 'default',
									esc_html__( 'Initial', 'eventchamp-core' ) => "initial",
									esc_html__( 'Inherit', 'eventchamp-core' ) => "inherit",
									esc_html__( 'Auto', 'eventchamp-core' ) => "auto",
									esc_html__( 'Cover', 'eventchamp-core' ) => "cover",
									esc_html__( 'Contain', 'eventchamp-core' ) => "contain",
								),
							),
							array(
								"type" => "dropdown",
								"param_name" => "background-image-repeat",
								"heading" => esc_html__( 'Background Image Repeat', 'eventchamp-core' ),
								"description" => esc_html__( 'Default: No Repeat', 'eventchamp-core' ),
								"save_always" => true,
								"value" => array(
									esc_html__( 'Default', 'eventchamp-core' ) => 'default',
									esc_html__( 'Initial', 'eventchamp-core' ) => "initial",
									esc_html__( 'Inherit', 'eventchamp-core' ) => "inherit",
									esc_html__( 'Repeat', 'eventchamp-core' ) => "repeat",
									esc_html__( 'Repeat X', 'eventchamp-core' ) => "repeat-x",
									esc_html__( 'Repeat Y', 'eventchamp-core' ) => "repeat-y",
									esc_html__( 'No Repeat', 'eventchamp-core' ) => "no-repeat",
									esc_html__( 'Space', 'eventchamp-core' ) => "space",
									esc_html__( 'Round', 'eventchamp-core' ) => "round",
								),
							),
							array(
								"type" => "textfield",
								"param_name" => "autoplay-delay",
								"heading" => esc_html__( 'Slide Autoplay Delay', 'eventchamp-core' ),
								"description" => esc_html__( 'Default: 15000', 'eventchamp-core' ),
								"save_always" => true,
							),
							array(
								"type" => "dropdown",
								"param_name" => "opacity",
								"heading" => esc_html__( 'Opacity', 'eventchamp-core' ),
								"group" => esc_html__( 'Design', 'eventchamp-core' ),
								'save_always' => true,
								"value" => array(
									esc_html__( 'False', 'eventchamp-core' ) => 'false',
									esc_html__( 'True', 'eventchamp-core' ) => 'true',
								),
							),
							array(
								"type" => "dropdown",
								"param_name" => "opacity-value",
								"heading" => esc_html__( 'Opacity Value', 'eventchamp-core' ),
								"description" => esc_html__( 'Default: 0.3.', 'eventchamp-core' ),
								"group" => esc_html__( 'Design', 'eventchamp-core' ),
								'save_always' => true,
								"value" => array(
									esc_html__( '5', 'eventchamp-core' ) => '0.05',
									esc_html__( '10', 'eventchamp-core' ) => '0.1',
									esc_html__( '15', 'eventchamp-core' ) => '0.15',
									esc_html__( '20', 'eventchamp-core' ) => '0.2',
									esc_html__( '25', 'eventchamp-core' ) => '0.25',
									esc_html__( '30', 'eventchamp-core' ) => '0.3',
									esc_html__( '35', 'eventchamp-core' ) => '0.35',
									esc_html__( '40', 'eventchamp-core' ) => '0.4',
									esc_html__( '45', 'eventchamp-core' ) => '0.45',
									esc_html__( '50', 'eventchamp-core' ) => '0.5',
									esc_html__( '55', 'eventchamp-core' ) => '0.55',
									esc_html__( '60', 'eventchamp-core' ) => '0.6',
									esc_html__( '65', 'eventchamp-core' ) => '0.65',
									esc_html__( '70', 'eventchamp-core' ) => '0.7',
									esc_html__( '75', 'eventchamp-core' ) => '0.75',
									esc_html__( '80', 'eventchamp-core' ) => '0.8',
									esc_html__( '85', 'eventchamp-core' ) => '0.85',
									esc_html__( '90', 'eventchamp-core' ) => '0.9',
									esc_html__( '95', 'eventchamp-core' ) => '0.95',
									esc_html__( '100', 'eventchamp-core' ) => '1',
								),
							),
							array(
								"type" => "colorpicker",
								"param_name" => "opacity-color",
								"heading" => esc_html__( 'Opacity Color', 'eventchamp-core' ),
								"description" => esc_html__( 'Default: #000000', 'eventchamp-core' ),
								"group" => esc_html__( 'Design', 'eventchamp-core' ),
								'save_always' => true,
							),
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "separator",
						"heading" => esc_html__( 'Separator', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'False',
							esc_html__( 'Style 1', 'eventchamp-core' ) => 'style-1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => 'style-2',
							esc_html__( 'Style 3', 'eventchamp-core' ) => 'style-3',
							esc_html__( 'Style 4', 'eventchamp-core' ) => 'style-4',
							esc_html__( 'Style 5', 'eventchamp-core' ) => 'style-5',
							esc_html__( 'Style 6', 'eventchamp-core' ) => 'style-6',
							esc_html__( 'Style 7', 'eventchamp-core' ) => 'style-7',
						),
					),
					array(
						"type" => "colorpicker",
						"param_name" => "separator-color",
						"heading" => esc_html__( 'Separator Color', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: #FFFFFF', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "slider-height",
						"heading" => esc_html__( 'Slider Height', 'eventchamp-core' ),
						"description" => esc_html__( 'Example: 600px. If enter blank, it will have full height.', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-column",
						"heading" => esc_html__( 'Column', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( '1 Column', 'eventchamp-core' ) => '1',
							esc_html__( '2 Column', 'eventchamp-core' ) => '2',
							esc_html__( '3 Column', 'eventchamp-core' ) => '3',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-space",
						"heading" => esc_html__( 'Column Space', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( '0', 'eventchamp-core' ) => '0',
							esc_html__( '1', 'eventchamp-core' ) => '1',
							esc_html__( '2', 'eventchamp-core' ) => '2',
							esc_html__( '3', 'eventchamp-core' ) => '3',
							esc_html__( '4', 'eventchamp-core' ) => '4',
							esc_html__( '5', 'eventchamp-core' ) => '5',
							esc_html__( '10', 'eventchamp-core' ) => '10',
							esc_html__( '15', 'eventchamp-core' ) => '15',
							esc_html__( '20', 'eventchamp-core' ) => '20',
							esc_html__( '25', 'eventchamp-core' ) => '25',
							esc_html__( '30', 'eventchamp-core' ) => '30',
							esc_html__( '45', 'eventchamp-core' ) => '45',
							esc_html__( '50', 'eventchamp-core' ) => '50',
							esc_html__( '55', 'eventchamp-core' ) => '55',
							esc_html__( '60', 'eventchamp-core' ) => '60',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-autoplay",
						"heading" => esc_html__( 'Slider Autoplay', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-loop",
						"heading" => esc_html__( 'Slider Loop', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "slider-slide-speed",
						"heading" => esc_html__( 'Slide Speed', 'eventchamp-core' ),
						"description" => esc_html__( 'Duration of transition between the slides. Default: 1000', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-centered-slides",
						"heading" => esc_html__( 'Centered Slides', 'eventchamp-core' ),
						"description" => esc_html__( 'If you choose true, then active slide will be centered, not always on the left side.', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-direction",
						"heading" => esc_html__( 'Slider Direction', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Horizontal', 'eventchamp-core' ) => 'horizontal',
							esc_html__( 'Vertical', 'eventchamp-core' ) => 'vertical',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-effect",
						"heading" => esc_html__( 'Slider Effect', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Slide', 'eventchamp-core' ) => 'slide',
							esc_html__( 'Fade', 'eventchamp-core' ) => 'fade',
							esc_html__( 'Cube', 'eventchamp-core' ) => 'cube',
							esc_html__( 'Coverflow', 'eventchamp-core' ) => 'coverflow',
							esc_html__( 'Flip', 'eventchamp-core' ) => 'flip',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-free-mode",
						"heading" => esc_html__( 'Free Mode', 'eventchamp-core' ),
						"description" => esc_html__( 'If true then slides will not have fixed positions', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "navigation",
						"heading" => esc_html__( 'Navigation', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "navigation-style",
						"heading" => esc_html__( 'Navigation Style', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => 'style-1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => 'style-2',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "pagination",
						"heading" => esc_html__( 'Pagination', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "pagination-style",
						"heading" => esc_html__( 'Pagination Style', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => 'style-1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => 'style-2',
						),
					),
				),
			)
		);

	}

}