<?php
/*======
*
* Counter
*
======*/
if( !function_exists( 'eventchamp_step_boxes_shortcode' ) ) {

	function eventchamp_step_boxes_shortcode( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'align' => '',
				'countertitle' => '',
				'counternumber' => '',
				'delay' => '',
				'time' => '',
			), $atts
		);

		/*====== Delay ======*/
		if( empty( $atts["delay"] ) ) {

			$atts["delay"] = "10";

		}

		/*====== Time ======*/
		if( empty( $atts["time"] ) ) {

			$atts["time"] = "2000";

		}

		/*====== HTML Output ======*/
		$output = '';

		if( !empty( $atts['counternumber'] ) or !empty( $atts['countertitle'] ) ) {

			$output .= '<div class="gt-counter gt-align-' . esc_attr( $atts["align"] ) . '" data-gt-delay="' . esc_attr( $atts["delay"] ) . '" data-gt-time="' . esc_attr( $atts["time"] ) . '">';

				if( !empty( $atts['counternumber'] ) ) {

					if( !empty( $atts['counternumber'] ) ) {

						$counternumber = esc_attr( $atts['counternumber'] );

					} else {

						$counternumber = "1";

					}

					if( !empty( $atts['counternumber'] ) ) {

						$output .= '<div class="gt-number">' . esc_attr( $atts['counternumber'] ) . '</div>';

					}

					if( !empty( $atts['countertitle'] ) ) {

						$output .= '<div class="gt-title">' . esc_attr( $atts['countertitle'] ) . '</div>';

					}

				}

			$output .= '</div>';

		}

		return $output;

	}
	add_shortcode( "eventchamp_step_boxes", "eventchamp_step_boxes_shortcode" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Counter', 'eventchamp-core' ),
				"base" => "eventchamp_step_boxes",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/counter.jpg',
				"description" => esc_html__( 'A number counter', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "dropdown",
						"param_name" => "align",
						"heading" => esc_html__( 'Align', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Left', 'eventchamp-core' ) => 'left',
							esc_html__( 'Center', 'eventchamp-core' ) => 'center',
							esc_html__( 'Right', 'eventchamp-core' ) => 'right',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "countertitle",
						"heading" => esc_html__( 'Title', 'eventchamp-core' ),
						"admin_label" => true,
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "counternumber",
						"heading" => esc_html__( 'Number', 'eventchamp-core' ),
						"admin_label" => true,
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "delay",
						"heading" => esc_html__( 'Delay', 'eventchamp-core' ),
						"description" => esc_html__( 'The delay in milliseconds per number count up. Default: 10.', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "time",
						"heading" => esc_html__( 'Time', 'eventchamp-core' ),
						"description" => esc_html__( 'The total duration of the count up animation. Default: 2000.', 'eventchamp-core' ),
						'save_always' => true,
					),
				)
			)
		);

	}

}