<?php
/*======
*
* Countdown Slider
*
======*/
if( !function_exists( 'eventchamp_event_counter_slider_output' ) ) {

	function eventchamp_event_counter_slider_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'titleone' => '',
				'titletwo' => '',
				'bgtext' => '',
				'addressdate' => '',
				'excerpt' => '',
				'detail-button-status' => '',
				'detaillink' => '',
				'detaillinkicon' => '',
				'detail-button-svg-icon' => '',
				'ticket-button-status' => '',
				'ticketlink' => '',
				'ticketlinkicon' => '',
				'ticket-button-svg-icon' => '',
				'eventdate' => '',
				'datebgtext' => '',
				'day-text' => '',
				'hour-text' => '',
				'minute-text' => '',
				'second-text' => '',
				'bgimages' => '',
				'style' => 'style-1',
				'separator' => '',
				'separator-color' => '',
				'sliderheight' => '100vh',
				'opacity' => '',
				'opacity-value' => '0.3',
				'opacity-color' => '',
				'slider-column' => '1',
				'slider-space' => '0',
				'autoplay' => '',
				'slider-autoplay-delay' => '15000',
				'loopstatus' => '',
				'slider-slide-speed' => 'false',
				'slider-centered-slides' => 'false',
				'slider-direction' => 'false',
				'slider-effect' => 'false',
				'slider-free-mode' => 'false',
				'navbuttons' => '',
				'navigation-style' => 'style-1',
				'dots' => '',
			), $atts
		);

		/*====== Lazy Load ======*/
		$lazy_load = ot_get_option( 'lazy-load', 'off' );

		/*====== Separator ======*/
		if( empty( $atts["separator-color"] ) ) {

			$separator_color = "#FFFFFF";

		} else {

			$separator_color = esc_attr( $atts["separator-color"] );

		}

		/*====== Day Text ======*/
		if( empty( $atts["day-text"] ) ) {

			$day_text = esc_html__( 'Days', 'eventchamp-core' );

		} else {

			$day_text = esc_attr( $atts["day-text"] );

		}

		/*====== Hour Text ======*/
		if( empty( $atts["hour-text"] ) ) {

			$hour_text = esc_html__( 'Hours', 'eventchamp-core' );

		} else {

			$hour_text = esc_attr( $atts["hour-text"] );

		}

		/*====== Minute Text ======*/
		if( empty( $atts["minute-text"] ) ) {

			$minute_text = esc_html__( 'Minutes', 'eventchamp-core' );

		} else {

			$minute_text = esc_attr( $atts["minute-text"] );

		}

		/*====== Second Text ======*/
		if( empty( $atts["second-text"] ) ) {

			$second_text = esc_html__( 'Seconds', 'eventchamp-core' );

		} else {

			$second_text = esc_attr( $atts["second-text"] );

		}

		/*====== Slider Height ======*/
		if( empty( $atts["sliderheight"] ) ) {

			$atts["sliderheight"] = "100vh";

		}

		/*====== Opacity ======*/
		if( empty( $atts["opacity"] ) ) {

			$atts["opacity"] = "true";

		}

		/*====== Opacity Value ======*/
		if( empty( $atts["opacity-value"] ) ) {

			$atts["opacity-value"] = "0.3";

		}

		/*====== Opacity Color ======*/
		if( empty( $atts["opacity-color"] ) ) {

			$opacity_color = "#000000";

		} else {

			$opacity_color = esc_attr( $atts["opacity-color"] );

		}

		/*====== Column ======*/
		if( empty( $atts["slider-column"] ) ) {

			$atts["slider-column"] = "1";

		}

		/*====== Column Space ======*/
		if( empty( $atts["slider-space"] ) ) {

			$atts["slider-space"] = "0";

		}

		/*====== Slider Autoplay Delay ======*/
		if( empty( $atts["slider-autoplay-delay"] ) ) {

			$atts["slider-autoplay-delay"] = "15000";

		}

		/*====== Slider Loop ======*/
		if( empty( $atts["slider-loop"] ) ) {

			$atts["slider-loop"] = "false";

		}

		/*====== Slider Slide Speed ======*/
		if( empty( $atts["slider-slide-speed"] ) ) {

			$atts["slider-slide-speed"] = "1000";

		}

		/*====== Centered Slides ======*/
		if( empty( $atts["slider-centered-slides"] ) ) {

			$atts["slider-centered-slides"] = "false";

		}

		/*====== Slider Direction ======*/
		if( empty( $atts["slider-direction"] ) ) {

			$atts["slider-direction"] = "horizontal";

		}

		/*====== Slider Effect ======*/
		if( empty( $atts["slider-effect"] ) ) {

			$atts["slider-effect"] = "slide";

		}

		/*====== Slider Free Mode ======*/
		if( empty( $atts["slider-free-mode"] ) ) {

			$atts["slider-free-mode"] = "false";

		}

		/*====== HTML Output ======*/
		$output = '';

		if( !empty( $atts["addressdate"] ) or !empty( $atts["titleone"] ) or !empty( $atts["titletwo"] ) or !empty( $atts["excerpt"] ) or !empty( $atts["eventdate"] ) ) {

			if( $atts["style"] == "style-1" ) {

				$output .= '<div class="gt-countdown-slider gt-style-1" style="height:' . esc_attr( $atts["sliderheight"] ) . ';">';
					$output .= '<div class="swiper-container gt-swiper-slider" data-gt-item="' . esc_attr( $atts["slider-column"] ) . '" data-gt-item-space="' . esc_attr( $atts["slider-space"] ) . '" data-gt-loop="' . esc_attr( $atts["loopstatus"] ) . '" data-gt-speed="' . esc_attr( $atts["slider-slide-speed"] ) . '" data-gt-direction="' . esc_attr( $atts["slider-direction"] ) . '" data-gt-effect="' . esc_attr( $atts["slider-effect"] ) . '" data-gt-centered-slides="' . esc_attr( $atts["slider-centered-slides"] ) . '" data-gt-free-mode="' . esc_attr( $atts["slider-free-mode"] ) . '">';
						$output .= '<div class="swiper-wrapper">';

							$slider_images = explode( ',', $atts["bgimages"] ); 

							if( !empty( $slider_images ) ) {

								foreach( $slider_images as $slider_image ) {

									if( !empty( $slider_image ) ) {

										if( $atts["autoplay"] == "true" ) {

											$output .= '<div class="swiper-slide" data-swiper-autoplay="' . esc_attr( $atts["slider-autoplay-delay"] ) . '">';

										} else {

											$output .= '<div class="swiper-slide">';

										}

											if( $lazy_load == "on" ) {

												$output .= '<div class="gt-image gt-lazy-load" data-background="' . esc_url( wp_get_attachment_image_src( esc_attr( $slider_image ), "eventchamp-event-slider" )[0] ) . '">';

											} else {

												$output .= '<div class="gt-image" style="background-image:url(' . esc_url( wp_get_attachment_image_src( esc_attr( $slider_image ), "eventchamp-event-slider" )[0] ) . ');">';

											}

												if( $atts["opacity"] == "true" ) {

													$output .= '<div class="gt-opacity" style="opacity: ' . esc_attr( $atts["opacity-value"] ) . '; background-color: ' . esc_attr( $opacity_color ) . ';"></div>';

												}

											$output .= '</div>';
										$output .= '</div>';

									}

								}

							}

						$output .= '</div>';

						if( $atts["dots"] == "true" ) {

							$output .= '<div class="swiper-pagination gt-slider-pagination"></div>';

						}

						if( $atts["navbuttons"] == "true" ) {

							$output .= '<div class="gt-slider-prev gt-slider-control gt-' . esc_attr( $atts["navigation-style"] ) . '">';
								$output .= '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="15 18 9 12 15 6"></polyline></svg>';
							$output .= '</div>';
							$output .= '<div class="gt-slider-next gt-slider-control gt-' . esc_attr( $atts["navigation-style"] ) . '">';
								$output .= '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="9 18 15 12 9 6"></polyline></svg>';
							$output .= '</div>';

						}

					$output .= '</div>';

					$output .= '<div class="gt-slider-content">';

						if( !empty( $atts["addressdate"] ) ) {

							$output .= '<div class="gt-address-date">' . esc_attr( $atts["addressdate"] ) . '</div>';

						}

						if( !empty( $atts["titleone"] ) or !empty( $atts["titletwo"] ) ) {

							$output .= '<div class="gt-title">';

								if( !empty( $atts["bgtext"] ) ) {

									$output .= '<div class="gt-background-text">' . esc_attr( $atts["bgtext"] ) . '</div>';

								}

								if( !empty( $atts["titleone"] ) or !empty( $atts["titleone"] ) ) {

									$output .= '<div class="gt-title-inner">';

										if( !empty( $atts["titleone"] ) ) {

											$output .= '<span class="gt-primary">' . esc_attr( $atts["titleone"] ) . '</span>';

										}

										if( !empty( $atts["titletwo"] ) ) {

											$output .= '<span class="gt-secondary">' . esc_attr( $atts["titletwo"] ) . '</span>';

										}

									$output .= '</div>';

								}

							$output .= '</div>';

						}

						if( !empty( $atts["excerpt"] ) ) {

							$output .= '<div class="gt-text">' . esc_attr( $atts["excerpt"] ) . '</div>';

						}

						if( !empty( $atts["detaillink"] ) or !empty( $atts["ticketlink"] ) ) {

							if( $atts["detail-button-status"] == "true" or $atts["ticket-button-status"] == "true" ) {

								$output .= '<div class="gt-buttons">';

									if( !empty( $atts["detaillink"] ) ) {

										if( $atts["detail-button-status"] == "true" ) {

											$href = $atts["detaillink"];
											$href = vc_build_link( $href );

											if( !empty( $href["target"] ) ) {

												$target = $href["target"];

											} else {

												$target = "_parent";

											}

											if( !empty( $href["title"] ) ) {

												$output .= '<a href="' . esc_url( $href["url"] ) . '" target="' . esc_attr( $target ) . '">';

													if( !empty( $atts["detaillinkicon"] ) ) {

														$output .= '<i class="' . esc_attr( $atts["detaillinkicon"] ) . '"></i>';

													} elseif( !empty( $atts["detail-button-svg-icon"] ) ) {

														$output .= rawurldecode( base64_decode( $atts["detail-button-svg-icon"] ) );

													}

													$output .= '<span>' . esc_attr( $href["title"] ) . '</span>';
												$output .= '</a>';

											}

										}

									}

									if( !empty( $atts["ticketlink"] ) ) {

										if( $atts["ticket-button-status"] == "true" ) {

											$href = $atts["ticketlink"];
											$href = vc_build_link( $href );

											if( !empty( $href["target"] ) ) {

												$target = $href["target"];

											} else {

												$target = "_parent";

											}

											if( !empty( $href["title"] ) ) {

												$output .= '<a href="' . esc_url( $href["url"] ) . '" target="' . esc_attr( $target ) . '">';

													if( !empty( $atts["ticketlinkicon"] ) ) {

														$output .= '<i class="' . esc_attr( $atts["ticketlinkicon"] ) . '"></i>';

													} elseif( !empty( $atts["ticket-button-svg-icon"] ) ) {

														$output .= rawurldecode( base64_decode( $atts["ticket-button-svg-icon"] ) );

													}

													$output .= '<span>' . esc_attr( $href["title"] ) . '</span>';
												$output .= '</a>';

											}

										}

									}

								$output .= '</div>';

							}

						}

					$output .= '</div>';

					if( !empty( $atts["eventdate"] ) ) {

						$output .= '<div class="gt-counter">';

							if( !empty( $atts["datebgtext"] ) ) {

								$output .= '<div class="gt-background-text">' . esc_attr( $atts["datebgtext"] ) . '</div>';

							}

							/*====== Rand ID ======*/
							$rand_id = rand( 0, 99999 );

							$output .= '<div class="gt-counter-inner">';
								$output .= '<div class="gt-day">';
									$output .= '<div class="wrapper">';
										$output .= '<div class="gt-count" id="gt-day-count-' . esc_attr( $rand_id ) . '"></div>';
										$output .= '<div class="gt-title">' . esc_attr( $day_text ) . '</div>';
									$output .= '</div>';
								$output .= '</div>';
								$output .= '<div class="gt-hour">';
									$output .= '<div class="wrapper">';
										$output .= '<div class="gt-count" id="gt-hour-count-' . esc_attr( $rand_id ) . '"></div>';
										$output .= '<div class="gt-title">' . esc_attr( $hour_text ) . '</div>';
									$output .= '</div>';
								$output .= '</div>';
								$output .= '<div class="gt-minute">';
									$output .= '<div class="wrapper">';
										$output .= '<div class="gt-count" id="gt-minute-count-' . esc_attr( $rand_id ) . '"></div>';
										$output .= '<div class="gt-title">' . esc_attr( $minute_text ) . '</div>';
									$output .= '</div>';
								$output .= '</div>';
								$output .= '<div class="gt-second">';
									$output .= '<div class="wrapper">';
										$output .= '<div class="gt-count" id="gt-second-count-' . esc_attr( $rand_id ) . '"></div>';
										$output .= '<div class="gt-title">' . esc_attr( $second_text ) . '</div>';
									$output .= '</div>';
								$output .= '</div>';
							$output .= '</div>';
							$output .= "<script type='text/javascript'>
								jQuery(document).ready(function($){
									$('.gt-counter-inner').countdown('" . date( 'Y/m/d H:i:s', strtotime( $atts["eventdate"] ) ) . "', function(event) {
										$('#gt-day-count-" . esc_attr( $rand_id ) . "').html(event.strftime('%D'));
										$('#gt-hour-count-" . esc_attr( $rand_id ) . "').html(event.strftime('%H'));
										$('#gt-minute-count-" . esc_attr( $rand_id ) . "').html(event.strftime('%M'));
										$('#gt-second-count-" . esc_attr( $rand_id ) . "').html(event.strftime('%S'));
									});
								});
							</script>";
						$output .= '</div>';

					}

					if( $atts["separator"] == "style-1" ) {

						$output .= '<div class="gt-separator gt-style-1">';
							$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1480 51" preserveAspectRatio="none"><path d="M1480 51V8c-17 0-34 2.3-47 6.8l-29.4 10.3c-25.8 9-68.1 9-93.9 0l-29.4-10.3c-25.8-9-68.1-9-93.9 0L1157 25.1c-25.8 9-68.1 9-93.9 0l-29.4-10.3c-25.8-9-68.1-9-93.9 0l-29.4 10.3c-25.8 9-68.1 9-93.9 0L787 14.8c-25.8-9-68.1-9-93.9 0l-29.4 10.3c-25.8 9-68.1 9-93.9 0l-29.4-10.3c-25.8-9-68.1-9-93.9 0l-29.4 10.3c-25.8 9-68.1 9-93.9 0l-29.5-10.3c-25.8-9-68.1-9-93.9 0l-29.4 10.3c-25.8 9-68.1 9-93.9 0L47 14.8C34 10.3 17 8 0 8v43h1480z"></path></svg>';
						$output .= '</div>';

					} elseif( $atts["separator"] == "style-2" ) {

						$output .= '<div class="gt-separator gt-style-2">';
							$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1480 103.5" preserveAspectRatio="none"><path d="M1480 103.5V7.7c-6.8.2-13.5.6-20.3.7-45.5 1.1-90.4 6.9-134 20.1-23.9 7.2-47 16.8-70.6 24.8-14 4.7-28.2 8.7-42.4 12.8-23.7 6.8-47.9 9.9-72.4 11.3-17 1-34.3 2.7-51.2 1.1-26.2-2.4-52.3-6.5-78.1-11.2-30.8-5.7-60.1-17-89.3-28.2C865.3 17.4 806.6 7.1 746.3 7c-57.8-.1-115.1 5.7-170.4 24-22.1 7.3-43.6 16.1-65.7 23.6-38.6 13.1-78.2 21.1-118.9 23.7-66.6 4.2-130.7-7.7-192.7-31.8-40.5-15.8-81.9-28.1-125-33.8C49.3 9.4 24.7 7.1 0 7.7v95.8h1480z"/></svg>';
						$output .= '</div>';

					} elseif( $atts["separator"] == "style-3" ) {

						$output .= '<div class="gt-separator gt-style-3">';
							$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1480 142.3" preserveAspectRatio="none"><path d="M704.6 52.7C430.3 1.4 174.9 23 0 43.7v98.7h1480V43.7c-192.5 22.8-441.9 71.3-775.4 9z"/></svg>';
						$output .= '</div>';

					} elseif( $atts["separator"] == "style-4" ) {

						$output .= '<div class="gt-separator gt-style-4">';
							$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1480 117"  preserveAspectRatio="none"><path d="M0 24.5c246.7 46.3 493.3 69.4 740 69.4s493.3-23.1 740-69.4V117H0V24.5z"/></svg>';
						$output .= '</div>';

					} elseif( $atts["separator"] == "style-5" ) {

						$output .= '<div class="gt-separator gt-style-5">';
							$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1480 160"><path d="M0 160L1480 12v148z"/></svg>';
						$output .= '</div>';

					} elseif( $atts["separator"] == "style-6" ) {

						$output .= '<div class="gt-separator gt-style-6">';
							$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1480 60"><path d="M74 22.5C33.1 22.5 0 39.3 0 60h148c0-20.7-33.1-37.5-74-37.5zM222 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM370 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM518 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM666 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM814 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM962 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM1110 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM1258 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM1406 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5z"/></svg>';
						$output .= '</div>';

					} elseif( $atts["separator"] == "style-7" ) {

						$output .= '<div class="gt-separator gt-style-7">';
							$output .= '<svg fill="fill:' . esc_attr( $separator_color ) . '" xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1480 60"><path d="M43.5 22L0 60h87.1zM130.6 22L87.1 60h87zM217.6 22l-43.5 38h87.1zM304.7 22l-43.5 38h87zM391.8 22l-43.6 38h87.1zM478.8 22l-43.5 38h87.1zM565.9 22l-43.5 38h87zM652.9 22l-43.5 38h87.1zM740 22l-43.5 38h87zM827.1 22l-43.6 38h87.1zM914.1 22l-43.5 38h87zM1001.2 22l-43.6 38h87.1zM1088.2 22l-43.5 38h87.1zM1175.3 22l-43.5 38h87zM1262.4 22l-43.6 38h87.1zM1349.4 22l-43.5 38h87zM1436.5 22l-43.6 38h87.1z"/></svg>';
						$output .= '</div>';

					}

				$output .= '</div>';

			} elseif( $atts["style"] == "style-2" ) {

				$output .= '<div class="gt-countdown-slider gt-style-2" style="height:' . esc_attr( $atts["sliderheight"] ) . ';">';
					$output .= '<div class="swiper-container gt-swiper-slider" data-gt-item="' . esc_attr( $atts["slider-column"] ) . '" data-gt-item-space="' . esc_attr( $atts["slider-space"] ) . '" data-gt-loop="' . esc_attr( $atts["loopstatus"] ) . '" data-gt-speed="' . esc_attr( $atts["slider-slide-speed"] ) . '" data-gt-direction="' . esc_attr( $atts["slider-direction"] ) . '" data-gt-effect="' . esc_attr( $atts["slider-effect"] ) . '" data-gt-centered-slides="' . esc_attr( $atts["slider-centered-slides"] ) . '" data-gt-free-mode="' . esc_attr( $atts["slider-free-mode"] ) . '">';
						$output .= '<div class="swiper-wrapper">';

							$slider_images = explode( ',', $atts["bgimages"] ); 

							if( !empty( $slider_images ) ) {

								foreach( $slider_images as $slider_image ) {

									if( !empty( $slider_image ) ) {

										if( $atts["autoplay"] == "true" ) {

											$output .= '<div class="swiper-slide" data-swiper-autoplay="' . esc_attr( $atts["slider-autoplay-delay"] ) . '">';

										} else {

											$output .= '<div class="swiper-slide">';

										}

											if( $lazy_load == "on" ) {

												$output .= '<div class="gt-image gt-lazy-load" data-background="' . esc_url( wp_get_attachment_image_src( esc_attr( $slider_image ), "eventchamp-event-slider" )[0] ) . '">';

											} else {

												$output .= '<div class="gt-image" style="background-image:url(' . esc_url( wp_get_attachment_image_src( esc_attr( $slider_image ), "eventchamp-event-slider" )[0] ) . ');">';

											}

												if( $atts["opacity"] == "true" ) {

													$output .= '<div class="gt-opacity" style="opacity: ' . esc_attr( $atts["opacity-value"] ) . '; background-color: ' . esc_attr( $opacity_color ) . ';"></div>';

												}

											$output .= '</div>';
										$output .= '</div>';

									}

								}

							}

						$output .= '</div>';

						if( $atts["dots"] == "true" ) {

							$output .= '<div class="swiper-pagination gt-slider-pagination"></div>';

						}

						if( $atts["navbuttons"] == "true" ) {

							$output .= '<div class="gt-slider-prev gt-slider-control gt-' . esc_attr( $atts["navigation-style"] ) . '">';
								$output .= '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="15 18 9 12 15 6"></polyline></svg>';
							$output .= '</div>';
							$output .= '<div class="gt-slider-next gt-slider-control gt-' . esc_attr( $atts["navigation-style"] ) . '">';
								$output .= '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="9 18 15 12 9 6"></polyline></svg>';
							$output .= '</div>';

						}

					$output .= '</div>';

					$output .= '<div class="gt-slider-content">';

						if( !empty( $atts["titleone"] ) or !empty( $atts["titletwo"] ) ) {

							$output .= '<div class="gt-title">';

								if( !empty( $atts["bgtext"] ) ) {

									$output .= '<div class="gt-background-text">' . esc_attr( $atts["bgtext"] ) . '</div>';

								}

								if( !empty( $atts["titleone"] ) or !empty( $atts["titleone"] ) ) {

									if( !empty( $atts["bgtext"] ) ) {

										$output .= '<div class="gt-title-inner">';

									} else {

										$output .= '<div class="gt-title-inner gt-relative">';

									}

										if( !empty( $atts["titleone"] ) ) {

											$output .= '<span class="gt-primary">' . esc_attr( $atts["titleone"] ) . '</span>';

										}

										if( !empty( $atts["titletwo"] ) ) {

											$output .= '<span class="gt-secondary">' . esc_attr( $atts["titletwo"] ) . '</span>';

										}

									$output .= '</div>';

								}

							$output .= '</div>';

						}

						if( !empty( $atts["addressdate"] ) ) {

							$output .= '<div class="gt-address-date">' . esc_attr( $atts["addressdate"] ) . '</div>';

						}

						if( !empty( $atts["excerpt"] ) ) {

							$output .= '<div class="gt-text">' . esc_attr( $atts["excerpt"] ) . '</div>';

						}

						if( !empty( $atts["eventdate"] ) ) {

							$output .= '<div class="gt-counter">';

								if( !empty( $atts["datebgtext"] ) ) {

									$output .= '<div class="gt-background-text">' . esc_attr( $atts["datebgtext"] ) . '</div>';

								}

								if( !empty( $atts["datebgtext"] ) ) {

									$output .= '<div class="gt-counter-inner">';

								} else {

									$output .= '<div class="gt-counter-inner gt-relative">';

								}

									/*====== Rand ID ======*/
									$rand_id = rand( 0, 99999 );

									$output .= '<div class="gt-day">';
										$output .= '<div class="wrapper">';
											$output .= '<div class="gt-count" id="gt-day-count-' . esc_attr( $rand_id ) . '"></div>';
											$output .= '<div class="gt-title">' . esc_attr( $day_text ) . '</div>';
										$output .= '</div>';
									$output .= '</div>';
									$output .= '<div class="gt-hour">';
										$output .= '<div class="wrapper">';
											$output .= '<div class="gt-count" id="gt-hour-count-' . esc_attr( $rand_id ) . '"></div>';
											$output .= '<div class="gt-title">' . esc_attr( $hour_text ) . '</div>';
										$output .= '</div>';
									$output .= '</div>';
									$output .= '<div class="gt-minute">';
										$output .= '<div class="wrapper">';
											$output .= '<div class="gt-count" id="gt-minute-count-' . esc_attr( $rand_id ) . '"></div>';
											$output .= '<div class="gt-title">' . esc_attr( $minute_text ) . '</div>';
										$output .= '</div>';
									$output .= '</div>';
									$output .= '<div class="gt-second">';
										$output .= '<div class="wrapper">';
											$output .= '<div class="gt-count" id="gt-second-count-' . esc_attr( $rand_id ) . '"></div>';
											$output .= '<div class="gt-title">' . esc_attr( $second_text ) . '</div>';
										$output .= '</div>';
									$output .= '</div>';
								$output .= '</div>';
								$output .= "<script type='text/javascript'>
									jQuery(document).ready(function($){
										$('.gt-counter-inner').countdown('" . date( 'Y/m/d H:i:s', strtotime( $atts["eventdate"] ) ) . "', function(event) {
											$('#gt-day-count-" . esc_attr( $rand_id ) . "').html(event.strftime('%D'));
											$('#gt-hour-count-" . esc_attr( $rand_id ) . "').html(event.strftime('%H'));
											$('#gt-minute-count-" . esc_attr( $rand_id ) . "').html(event.strftime('%M'));
											$('#gt-second-count-" . esc_attr( $rand_id ) . "').html(event.strftime('%S'));
										});
									});
								</script>";
							$output .= '</div>';

						}

						if( !empty( $atts["detaillink"] ) or !empty( $atts["ticketlink"] ) ) {

							if( $atts["detail-button-status"] == "true" or $atts["ticket-button-status"] == "true" ) {

								$output .= '<div class="gt-buttons">';

									if( !empty( $atts["detaillink"] ) ) {

										if( $atts["detail-button-status"] == "true" ) {

											$href = $atts["detaillink"];
											$href = vc_build_link( $href );

											if( !empty( $href["target"] ) ) {

												$target = $href["target"];

											} else {

												$target = "_parent";

											}

											if( !empty( $href["title"] ) ) {

												$output .= '<a href="' . esc_url( $href["url"] ) . '" target="' . esc_attr( $target ) . '">';

													if( !empty( $atts["detaillinkicon"] ) ) {

														$output .= '<i class="' . esc_attr( $atts["detaillinkicon"] ) . '"></i>';

													} elseif( !empty( $atts["detail-button-svg-icon"] ) ) {

														$output .= rawurldecode( base64_decode( $atts["detail-button-svg-icon"] ) );

													}

													$output .= '<span>' . esc_attr( $href["title"] ) . '</span>';
												$output .= '</a>';

											}

										}

									}

									if( !empty( $atts["ticketlink"] ) ) {

										if( $atts["ticket-button-status"] == "true" ) {

											$href = $atts["ticketlink"];
											$href = vc_build_link( $href );

											if( !empty( $href["target"] ) ) {

												$target = $href["target"];

											} else {

												$target = "_parent";

											}

											if( !empty( $href["title"] ) ) {

												$output .= '<a href="' . esc_url( $href["url"] ) . '" target="' . esc_attr( $target ) . '">';

													if( !empty( $atts["ticketlinkicon"] ) ) {

														$output .= '<i class="' . esc_attr( $atts["ticketlinkicon"] ) . '"></i>';

													} elseif( !empty( $atts["ticket-button-svg-icon"] ) ) {

														$output .= rawurldecode( base64_decode( $atts["ticket-button-svg-icon"] ) );

													}

													$output .= '<span>' . esc_attr( $href["title"] ) . '</span>';
												$output .= '</a>';

											}

										}

									}

								$output .= '</div>';

							}

						}

					$output .= '</div>';

					if( $atts["separator"] == "style-1" ) {

						$output .= '<div class="gt-separator gt-style-1">';
							$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1480 51" preserveAspectRatio="none"><path d="M1480 51V8c-17 0-34 2.3-47 6.8l-29.4 10.3c-25.8 9-68.1 9-93.9 0l-29.4-10.3c-25.8-9-68.1-9-93.9 0L1157 25.1c-25.8 9-68.1 9-93.9 0l-29.4-10.3c-25.8-9-68.1-9-93.9 0l-29.4 10.3c-25.8 9-68.1 9-93.9 0L787 14.8c-25.8-9-68.1-9-93.9 0l-29.4 10.3c-25.8 9-68.1 9-93.9 0l-29.4-10.3c-25.8-9-68.1-9-93.9 0l-29.4 10.3c-25.8 9-68.1 9-93.9 0l-29.5-10.3c-25.8-9-68.1-9-93.9 0l-29.4 10.3c-25.8 9-68.1 9-93.9 0L47 14.8C34 10.3 17 8 0 8v43h1480z"></path></svg>';
						$output .= '</div>';

					} elseif( $atts["separator"] == "style-2" ) {

						$output .= '<div class="gt-separator gt-style-2">';
							$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1480 103.5" preserveAspectRatio="none"><path d="M1480 103.5V7.7c-6.8.2-13.5.6-20.3.7-45.5 1.1-90.4 6.9-134 20.1-23.9 7.2-47 16.8-70.6 24.8-14 4.7-28.2 8.7-42.4 12.8-23.7 6.8-47.9 9.9-72.4 11.3-17 1-34.3 2.7-51.2 1.1-26.2-2.4-52.3-6.5-78.1-11.2-30.8-5.7-60.1-17-89.3-28.2C865.3 17.4 806.6 7.1 746.3 7c-57.8-.1-115.1 5.7-170.4 24-22.1 7.3-43.6 16.1-65.7 23.6-38.6 13.1-78.2 21.1-118.9 23.7-66.6 4.2-130.7-7.7-192.7-31.8-40.5-15.8-81.9-28.1-125-33.8C49.3 9.4 24.7 7.1 0 7.7v95.8h1480z"/></svg>';
						$output .= '</div>';

					} elseif( $atts["separator"] == "style-3" ) {

						$output .= '<div class="gt-separator gt-style-3">';
							$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1480 142.3" preserveAspectRatio="none"><path d="M704.6 52.7C430.3 1.4 174.9 23 0 43.7v98.7h1480V43.7c-192.5 22.8-441.9 71.3-775.4 9z"/></svg>';
						$output .= '</div>';

					} elseif( $atts["separator"] == "style-4" ) {

						$output .= '<div class="gt-separator gt-style-4">';
							$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1480 117"  preserveAspectRatio="none"><path d="M0 24.5c246.7 46.3 493.3 69.4 740 69.4s493.3-23.1 740-69.4V117H0V24.5z"/></svg>';
						$output .= '</div>';

					} elseif( $atts["separator"] == "style-5" ) {

						$output .= '<div class="gt-separator gt-style-5">';
							$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1480 160"><path d="M0 160L1480 12v148z"/></svg>';
						$output .= '</div>';

					} elseif( $atts["separator"] == "style-6" ) {

						$output .= '<div class="gt-separator gt-style-6">';
							$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1480 60"><path d="M74 22.5C33.1 22.5 0 39.3 0 60h148c0-20.7-33.1-37.5-74-37.5zM222 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM370 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM518 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM666 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM814 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM962 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM1110 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM1258 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5zM1406 22.5c-40.9 0-74 16.8-74 37.5h148c0-20.7-33.1-37.5-74-37.5z"/></svg>';
						$output .= '</div>';

					} elseif( $atts["separator"] == "style-7" ) {

						$output .= '<div class="gt-separator gt-style-7">';
							$output .= '<svg fill="' . esc_attr( $separator_color ) . '" xmlns="https://www.w3.org/2000/svg" viewBox="0 0 1480 60"><path d="M43.5 22L0 60h87.1zM130.6 22L87.1 60h87zM217.6 22l-43.5 38h87.1zM304.7 22l-43.5 38h87zM391.8 22l-43.6 38h87.1zM478.8 22l-43.5 38h87.1zM565.9 22l-43.5 38h87zM652.9 22l-43.5 38h87.1zM740 22l-43.5 38h87zM827.1 22l-43.6 38h87.1zM914.1 22l-43.5 38h87zM1001.2 22l-43.6 38h87.1zM1088.2 22l-43.5 38h87.1zM1175.3 22l-43.5 38h87zM1262.4 22l-43.6 38h87.1zM1349.4 22l-43.5 38h87zM1436.5 22l-43.6 38h87.1z"/></svg>';
						$output .= '</div>';

					}

				$output .= '</div>';

			}

		}

		return $output;

	}
	add_shortcode( "eventchamp_event_counter_slider", "eventchamp_event_counter_slider_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Countdown Slider', 'eventchamp-core' ),
				"base" => "eventchamp_event_counter_slider",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/countdown-slider.jpg',
				"description" => esc_html__( 'A countdown slider', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "textfield",
						"param_name" => "titleone",
						"heading" => esc_html__( 'Primary Title', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						"admin_label" => true,
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "titletwo",
						"heading" => esc_html__( 'Secondary Title', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						"admin_label" => true,
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "bgtext",
						"heading" => esc_html__( 'Background Text for Title', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "addressdate",
						"heading" => esc_html__( 'Address & Date', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "excerpt",
						"heading" => esc_html__( 'Description Text', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "detail-button-status",
						"heading" => esc_html__( 'Detail Button', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "vc_link",
						"param_name" => "detaillink",
						"heading" => esc_html__( 'Detail Button Link', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "detaillinkicon",
						"heading" => esc_html__( 'Detail Button Font Icon', 'eventchamp-core' ),
						"description" => esc_html__( 'If you want to use SVG icon, enter blank it. You can enter an icon. Example: fab fa-wordpress-simple, fas fa-map-marker-alt. Icon list: https://goo.gl/vdPEsc', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textarea_raw_html",
						"param_name" => "detail-button-svg-icon",
						"heading" => esc_html__( 'Detail Button SVG Icon', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "ticket-button-status",
						"heading" => esc_html__( 'Ticket Button', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "vc_link",
						"param_name" => "ticketlink",
						"heading" => esc_html__( 'Ticket Button Link', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "ticketlinkicon",
						"heading" => esc_html__( 'Ticket Button Font Icon', 'eventchamp-core' ),
						"description" => esc_html__( 'If you want to use SVG icon, enter blank it. You can enter an icon. Example: fab fa-wordpress-simple, fas fa-map-marker-alt. Icon list: https://goo.gl/vdPEsc', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textarea_raw_html",
						"param_name" => "ticket-button-svg-icon",
						"heading" => esc_html__( 'Detail Button SVG Icon', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "eventdate",
						"heading" => esc_html__( 'Event Date', 'eventchamp-core' ),
						"description" => esc_html__( 'Enter date with this format: 2020/09/23 10:24:00', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "datebgtext",
						"heading" => esc_html__( 'Background Text for Date', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "day-text",
						"heading" => esc_html__( 'Day Text', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: Days.', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "hour-text",
						"heading" => esc_html__( 'Hour Text', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: Hours.', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "minute-text",
						"heading" => esc_html__( 'Minute Text', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: Minutes.', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "second-text",
						"heading" => esc_html__( 'Second Text', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: Seconds.', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "attach_images",
						"param_name" => "bgimages",
						"heading" => esc_html__( 'Slider Images', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "style",
						"heading" => esc_html__( 'Style', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => 'style-1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => 'style-2',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "separator",
						"heading" => esc_html__( 'Separator', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'False',
							esc_html__( 'Style 1', 'eventchamp-core' ) => 'style-1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => 'style-2',
							esc_html__( 'Style 3', 'eventchamp-core' ) => 'style-3',
							esc_html__( 'Style 4', 'eventchamp-core' ) => 'style-4',
							esc_html__( 'Style 5', 'eventchamp-core' ) => 'style-5',
							esc_html__( 'Style 6', 'eventchamp-core' ) => 'style-6',
							esc_html__( 'Style 7', 'eventchamp-core' ) => 'style-7',
						),
					),
					array(
						"type" => "colorpicker",
						"param_name" => "separator-color",
						"heading" => esc_html__( 'Separator Color', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: #FFFFFF', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "sliderheight",
						"heading" => esc_html__( 'Slider Height', 'eventchamp-core' ),
						"description" => esc_html__( 'Enter a slider height. Example: 600px. If enter blank, it will have full height.', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "opacity",
						"heading" => esc_html__( 'Opacity', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "opacity-value",
						"heading" => esc_html__( 'Opacity Value', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: 0.3.', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( '10', 'eventchamp-core' ) => '0.1',
							esc_html__( '20', 'eventchamp-core' ) => '0.2',
							esc_html__( '30', 'eventchamp-core' ) => '0.3',
							esc_html__( '40', 'eventchamp-core' ) => '0.4',
							esc_html__( '50', 'eventchamp-core' ) => '0.5',
							esc_html__( '60', 'eventchamp-core' ) => '0.6',
							esc_html__( '70', 'eventchamp-core' ) => '0.7',
							esc_html__( '80', 'eventchamp-core' ) => '0.8',
							esc_html__( '90', 'eventchamp-core' ) => '0.9',
							esc_html__( '100', 'eventchamp-core' ) => '1',
						),
					),
					array(
						"type" => "colorpicker",
						"param_name" => "opacity-color",
						"heading" => esc_html__( 'Opacity Color', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: #000000', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-column",
						"heading" => esc_html__( 'Column', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( '1 Column', 'eventchamp-core' ) => '1',
							esc_html__( '2 Column', 'eventchamp-core' ) => '2',
							esc_html__( '3 Column', 'eventchamp-core' ) => '3',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-space",
						"heading" => esc_html__( 'Column Space', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( '0', 'eventchamp-core' ) => '0',
							esc_html__( '1', 'eventchamp-core' ) => '1',
							esc_html__( '2', 'eventchamp-core' ) => '2',
							esc_html__( '3', 'eventchamp-core' ) => '3',
							esc_html__( '4', 'eventchamp-core' ) => '4',
							esc_html__( '5', 'eventchamp-core' ) => '5',
							esc_html__( '10', 'eventchamp-core' ) => '10',
							esc_html__( '15', 'eventchamp-core' ) => '15',
							esc_html__( '20', 'eventchamp-core' ) => '20',
							esc_html__( '25', 'eventchamp-core' ) => '25',
							esc_html__( '30', 'eventchamp-core' ) => '30',
							esc_html__( '45', 'eventchamp-core' ) => '45',
							esc_html__( '50', 'eventchamp-core' ) => '50',
							esc_html__( '55', 'eventchamp-core' ) => '55',
							esc_html__( '60', 'eventchamp-core' ) => '60',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "autoplay",
						"heading" => esc_html__( 'Slider Autoplay', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "slider-autoplay-delay",
						"heading" => esc_html__( 'Slider Autoplay Delay', 'eventchamp-core' ),
						"description" => esc_html__( 'Default: 15000', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "loopstatus",
						"heading" => esc_html__( 'Slider Loop', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "slider-slide-speed",
						"heading" => esc_html__( 'Slide Speed', 'eventchamp-core' ),
						"description" => esc_html__( 'Duration of transition between the slides. Default: 1500', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-centered-slides",
						"heading" => esc_html__( 'Centered Slides', 'eventchamp-core' ),
						"description" => esc_html__( 'If you choose true, then active slide will be centered, not always on the left side.', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-direction",
						"heading" => esc_html__( 'Slider Direction', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Horizontal', 'eventchamp-core' ) => 'horizontal',
							esc_html__( 'Vertical', 'eventchamp-core' ) => 'vertical',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-effect",
						"heading" => esc_html__( 'Slider Effect', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Slide', 'eventchamp-core' ) => 'slide',
							esc_html__( 'Fade', 'eventchamp-core' ) => 'fade',
							esc_html__( 'Cube', 'eventchamp-core' ) => 'cube',
							esc_html__( 'Coverflow', 'eventchamp-core' ) => 'coverflow',
							esc_html__( 'Flip', 'eventchamp-core' ) => 'flip',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "slider-free-mode",
						"heading" => esc_html__( 'Free Mode', 'eventchamp-core' ),
						"description" => esc_html__( 'If true then slides will not have fixed positions', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "navbuttons",
						"heading" => esc_html__( 'Navigation', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "navigation-style",
						"heading" => esc_html__( 'Navigation Style', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => 'style-1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => 'style-2',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "dots",
						"heading" => esc_html__( 'Pagination', 'eventchamp-core' ),
						"group" => esc_html__( 'Slider', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
				),
			)
		);

	}

}