<?php
/*======
*
* Contact Box
*
======*/
if( !function_exists( 'eventchamp_contact_box_output' ) ) {

	function eventchamp_contact_box_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'address' => '',
				'email' => '',
				'phone' => '',
				'fax' => '',
				'abouttext' => '',
				'about-link-status' => '',
				'aboutlink' => '',
			), $atts
		);

		/*====== HTML Output ======*/
		$output = '';

		if( !empty( $atts["address"] ) or !empty( $atts["email"] ) or !empty( $atts["phone"] ) or !empty( $atts["fax"] ) or !empty( $atts["abouttext"] ) or !empty( $atts["aboutlink"] ) ) {

			$output .= '<div class="gt-contact-box">';

				if( !empty( $atts["abouttext"] ) ) {

					$output .= '<div class="gt-item gt-text">';
						$output .= esc_attr( $atts["abouttext"] );
					$output .= '</div>';

				}

				if( !empty( $atts["address"] ) ) {

					$output .= '<div class="gt-item gt-address">';
						$output .= '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"></path><circle cx="12" cy="10" r="3"></circle></svg>';
						$output .= esc_attr( $atts["address"] );
					$output .= '</div>';

				}

				if( !empty( $atts["email"] ) ) {

					$output .= '<div class="gt-item gt-email">';
						$output .= '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path><polyline points="22,6 12,13 2,6"></polyline></svg>';
						$output .= '<a href="mailto:' . esc_attr( str_replace( ' ', '', $atts["email"] ) ) . '">';
							$output .= esc_attr( $atts["email"] );
						$output .= '</a>';
					$output .= '</div>';

				}

				if( !empty( $atts["phone"] ) ) {

					$output .= '<div class="gt-item gt-phone">';
						$output .= '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"></path></svg>';
						$output .= '<a href="tel:+' . esc_attr( str_replace( ' ', '', $atts["phone"] ) ) . '">';
							$output .= esc_attr( $atts["phone"] );
						$output .= '</a>';
					$output .= '</div>';

				}

				if( !empty( $atts["fax"] ) ) {

					$output .= '<div class="gt-item gt-fax">';
						$output .= '<svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="6 9 6 2 18 2 18 9"></polyline><path d="M6 18H4a2 2 0 0 1-2-2v-5a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-2"></path><rect x="6" y="14" width="12" height="8"></rect></svg>';
						$output .= esc_attr( $atts["fax"] );
					$output .= '</div>';

				}

				if( $atts["about-link-status"] == "true" ) {

					if( !empty( $atts["aboutlink"] ) ) {

						$href = $atts["aboutlink"];
						$href = vc_build_link( $href );

						if( !empty( $href["target"] ) ) {

							$target = $href["target"];

						} else {

							$target = "_parent";

						}

						$output .= '<div class="gt-item gt-link gt-button gt-style-2">';
							$output .= '<a href="' . esc_url( $href["url"] ) . '" target="' . esc_attr( $target ) . '">' . esc_attr( $href["title"] ) . '</a>';
						$output .= '</div>';

					}

				}

			$output .= '</div>';

		}

		return $output;

	}
	add_shortcode( "eventchamp_contact_box", "eventchamp_contact_box_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Contact Box', 'eventchamp-core' ),
				"base" => "eventchamp_contact_box",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/contact-box.jpg',
				"description" => esc_html__( 'Create a contact box', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "textfield",
						"param_name" => "address",
						"heading" => esc_html__( 'Address', 'eventchamp-core' ),
						"admin_label" => true,
						"save_always" => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "email",
						"heading" => esc_html__( 'Email Address', 'eventchamp-core' ),
						"admin_label" => true,
						"save_always" => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "phone",
						"heading" => esc_html__( 'Phone Number', 'eventchamp-core' ),
						"admin_label" => true,
						"save_always" => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "fax",
						"heading" => esc_html__( 'Fax Number', 'eventchamp-core' ),
						"admin_label" => true,
						"save_always" => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "abouttext",
						"heading" => esc_html__( 'Text', 'eventchamp-core' ),
						"save_always" => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "about-link-status",
						"heading" => esc_html__( 'Link Status', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "vc_link",
						"param_name" => "aboutlink",
						"heading" => esc_html__( 'Link', 'eventchamp-core' ),
						"save_always" => true,
					),
				),
			)
		);

	}

}