<?php
/*======
*
* Categorized Speakers
*
======*/
if( !function_exists( 'eventchamp_categorized_speakers_output' ) ) {

	function eventchamp_categorized_speakers_output( $atts, $content = null ) {

		/*====== Atts ======*/
		$atts = shortcode_atts(
			array(
				'count' => '',
				'exclude-speakers' => '',
				'offset' => '',
				'order' => '',
				'order-type' => '',
				'exclude-categories' => '',
				'exclude-locations' => '',
				'exclude-tags' => '',
				'include-categories' => '',
				'include-locations' => '',
				'include-tags' => '',
				'taxonomy-order' => '',
				'taxonomy-order-type' => '',
				'hide-empty-taxonomies' => '',
				'childless' => '',
				'category-list-align' => '',
				'style' => '',
				'column' => '',
				'column-space' => '0',
				'all-speakers-tab' => '',
				'all-speakers-button' => '',
				'profession' => '',
				'company' => 'false',
				'short-biography' => '',
				'social-links' => '',
			), $atts
		);

		/*====== Exclude Categories ======*/
		$exclude_category_array = "";

		if( !empty( $atts['exclude-categories'] ) ) {

			$exclude_categories = $atts['exclude-categories'];
			$exclude_categories = explode( ',', $exclude_categories );

		} else {

			$exclude_categories = "";

		}

		if( !empty( $exclude_categories ) ) {

			$exclude_category_array = array(
				'taxonomy' => 'speaker-category',
				'field' => 'term_id',
				'terms' => $exclude_categories,
				'operator' => 'NOT IN',
			);

		}

		/*====== Exclude Locations ======*/
		$exclude_location_array = "";

		if( !empty( $atts['exclude-locations'] ) ) {

			$exclude_locations = $atts['exclude-locations'];
			$exclude_locations = explode( ',', $exclude_locations );

		} else {

			$exclude_locations = "";

		}

		if( !empty( $exclude_locations ) ) {

			$exclude_location_array = array(
				'taxonomy' => 'location',
				'field' => 'term_id',
				'terms' => $exclude_locations,
				'operator' => 'NOT IN',
			);

		}

		/*====== Exclude Tags ======*/
		$exclude_tag_array = "";

		if( !empty( $atts['exclude-tags'] ) ) {

			$exclude_tags = $atts['exclude-tags'];
			$exclude_tags = explode( ',', $exclude_tags );

		} else {

			$exclude_tags = "";

		}

		if( !empty( $exclude_tags ) ) {

			$exclude_tag_array = array(
				'taxonomy' => 'speaker-tags',
				'field' => 'term_id',
				'terms' => $exclude_tags,
				'operator' => 'NOT IN',
			);

		}

		/*====== Include Categories ======*/
		$include_category_array = "";

		if( !empty( $atts['include-categories'] ) ) {

			$include_categories = $atts['include-categories'];
			$include_categories = explode( ',', $include_categories );

		} else {

			$include_categories = "";

		}

		if( !empty( $include_categories ) ) {

			$include_category_array = array(
				'taxonomy' => 'speaker-category',
				'field' => 'term_id',
				'terms' => $include_categories,
				'operator' => 'IN',
			);

		}

		/*====== Include Locations ======*/
		$include_location_array = "";

		if( !empty( $atts['include-locations'] ) ) {

			$include_locations = $atts['include-locations'];
			$include_locations = explode( ',', $include_locations );

		} else {

			$include_locations = "";

		}

		if( !empty( $include_locations ) ) {

			$include_location_array = array(
				'taxonomy' => 'location',
				'field' => 'term_id',
				'terms' => $include_locations,
				'operator' => 'IN',
			);

		}

		/*====== Include Tags ======*/
		$include_tags_array = "";

		if( !empty( $atts['include-tags'] ) ) {

			$include_tags = $atts['include-tags'];
			$include_tags = explode( ',', $include_tags );

		} else {

			$include_tags = "";

		}

		if( !empty( $include_tags ) ) {

			$include_tags_array = array(
				'taxonomy' => 'speaker-tags',
				'field' => 'term_id',
				'terms' => $include_tags,
				'operator' => 'IN',
			);

		}

		/*====== Hide Empty Categories ======*/
		if( $atts['hide-empty-taxonomies'] == 'false' ) {

			$hide_empty_taxonomies = false;

		} else {

			$hide_empty_taxonomies = true;

		}

		/*====== Childless ======*/
		if( $atts['childless'] == 'false' ) {

			$childless = false;

		} else {

			$childless = true;

		}

		/*====== Category List Align ======*/
		if( !empty( $atts['category-list-align'] ) ) {

			$category_list_align = esc_attr( $atts['category-list-align'] );

		} else {

			$category_list_align = "center";

		}

		/*====== Main Query ======*/
		$arg = array(
			'post_status' => 'publish',
			'post_type' => 'speaker',
			'tax_query' => array (
				'relation' => 'AND',
				$include_category_array,
				$include_tags_array,
				$include_location_array,
				$exclude_category_array,
				$exclude_tag_array,
				$exclude_location_array,
			)
		);

		/*====== Arg for Tabs ======*/
		$tab_arg = array(
			'post_status' => 'publish',
			'post_type' => 'speaker',
		);

		/*====== Count ======*/
		if( !empty( $atts["count"] ) ) {

			$extra_query = array(
				'posts_per_page' => $atts["count"],
			);
			$arg = wp_parse_args( $arg, $extra_query );
			$tab_arg = wp_parse_args( $tab_arg, $extra_query );

		}

		/*====== Offset ======*/
		if( !empty( $atts["offset"] ) ) {

			$extra_query = array(
				'offset' => $atts["offset"],
			);
			$arg = wp_parse_args( $arg, $extra_query );
			$tab_arg = wp_parse_args( $tab_arg, $extra_query );

		}

		/*====== Exclude Speakers ======*/
		$exclude_speakers = $atts['exclude-speakers'];

		if( !empty( $atts['exclude-speakers'] ) ) {

			$exclude_speakers = explode( ',', $exclude_speakers );

			if( !empty( $exclude_speakers ) ) {

				$extra_query = array(
					'post__not_in' => $exclude_speakers,
				);
				$arg = wp_parse_args( $arg, $extra_query );
				$tab_arg = wp_parse_args( $tab_arg, $extra_query );

			}

		}

		/*====== Order & Order By ======*/
		if( $atts["order"] == "ASC" ) {

			$order = "ASC";

		} else {

			$order = "DESC";

		}

		if( !empty( $order ) ) {

			$extra_query = array(
				'order' => $order,
			);
			$arg = wp_parse_args( $arg, $extra_query );
			$tab_arg = wp_parse_args( $tab_arg, $extra_query );

		}

		if( $atts["order-type"] == "popular-comment" ) {

			$order_by = "comment_count";

		} elseif( $atts["order-type"] == "id" ) {

			$order_by = "ID";

		} elseif( $atts["order-type"] == "popular" ) {

			$order_by = "comment_count";

		} elseif( $atts["order-type"] == "title" ) {

			$order_by = "title";

		} elseif( $atts["order-type"] == "menu_order" ) {

			$order_by = "menu_order";

		} elseif( $atts["order-type"] == "rand" ) {

			$order_by = "rand";

		} elseif( $atts["order-type"] == "none" ) {

			$order_by = "none";

		} elseif( $atts["order-type"] == "post__in" ) {

			$order_by = "post__in";

		} else {

			$order_by = "date";

		}

		if( !empty( $order_by ) ) {

			$extra_query = array(
				'orderby' => $order_by,
			);
			$arg = wp_parse_args( $arg, $extra_query );
			$tab_arg = wp_parse_args( $tab_arg, $extra_query );

		}

		/*====== Get Terms ======*/
		$category_terms = get_terms(
			array(
				'taxonomy' => 'speaker-category',
				'order' => $atts["taxonomy-order"],
				'orderby' => $atts["taxonomy-order-type"],
				'exclude' => $exclude_categories,
				'include' => $include_categories,
				'hide_empty' => $hide_empty_taxonomies,
				'childless' => $childless,
			)
		);

		/*====== HTML Output ======*/
		$output = "";

		if( ! empty( $category_terms ) && ! is_wp_error( $category_terms ) ) {

			$output .= '<div class="gt-categorized-contents gt-tab-panel">';
				$output .= '<ul class="nav gt-nav gt-' . esc_attr( $category_list_align ) . '" role="tablist">';

					if( $atts["all-speakers-tab"] == "true" ) {

						$output .= '<li>';
							$output .= '<a href="#categorized-speakers-all" aria-controls="categorized-speakers-all" role="tab" data-toggle="tab" class="active">' . esc_html__( 'All', 'eventchamp-core' ) . '</a>';
						$output .= '</li>';

					}

					$i = 0;

					foreach( $category_terms as $category_term ) {

						if( !empty( $category_term ) ) {

							$i++;

							$output .= '<li>';
								$output .= '<a href="#categorized-speakers-' . esc_attr( $category_term->slug ) . '-' . esc_attr( $i ) . '" aria-controls="categorized-speakers-' . esc_attr( $category_term->slug ) . '" role="tab" data-toggle="tab"' . ( $i == '1' && $atts["all-speakers-tab"] == "false"  ? ' class="active"' : '' )  . '>' . esc_attr( $category_term->name ) . '</a>';
							$output .= '</li>';

						}

					}

				$output .= '</ul>';

				$output .= '<div class="tab-content">';

					if( $atts["all-speakers-tab"] == "true" ) {

							$wp_query = new WP_Query( $arg );

							if( !empty( $wp_query ) ) {

								if( $wp_query->have_posts() ) {

									$output .= '<div role="tabpanel" class="tab-pane fade active show" aria-labelledby="categorized-speakers-all" id="categorized-speakers-all">';

										$output .= '<div class="gt-columns gt-column-' . esc_attr( $atts["column"] ) . ' gt-column-space-' . esc_attr( $atts["column-space"] ) . '">';

											while( $wp_query->have_posts() ) {

												$wp_query->the_post();

												$output .= '<div class="gt-col">';
													$output .= '<div class="gt-inner">';

														if( $atts["style"] == "style-1" ) {

															$output .= eventchamp_speaker_style_1( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["profession"] ), $company = esc_attr( $atts["company"] ), $summary = esc_attr( $atts["short-biography"] ), $social = esc_attr( $atts["social-links"] ) );

														} elseif( $atts["style"] == "style-2" ) {

															$output .= eventchamp_speaker_style_2( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["profession"] ), $company = esc_attr( $atts["company"] ), $summary = esc_attr( $atts["short-biography"] ), $social = esc_attr( $atts["social-links"] ) );

														} elseif( $atts["style"] == "style-3" ) {

															$output .= eventchamp_speaker_style_3( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["profession"] ), $company = esc_attr( $atts["company"] ), $summary = esc_attr( $atts["short-biography"] ), $social = esc_attr( $atts["social-links"] ) );

														} elseif( $atts["style"] == "style-4" ) {

															$output .= eventchamp_speaker_style_4( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["profession"] ), $company = esc_attr( $atts["company"] ), $summary = esc_attr( $atts["short-biography"] ), $social = esc_attr( $atts["social-links"] ) );

														} elseif( $atts["style"] == "style-5" ) {

															$output .= eventchamp_speaker_style_5( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["profession"] ), $company = esc_attr( $atts["company"] ), $summary = esc_attr( $atts["short-biography"] ), $social = esc_attr( $atts["social-links"] ) );

														} elseif( $atts["style"] == "style-6" ) {

															$output .= eventchamp_speaker_style_6( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["profession"] ), $company = esc_attr( $atts["company"] ), $summary = esc_attr( $atts["short-biography"] ), $social = esc_attr( $atts["social-links"] ) );

														} elseif( $atts["style"] == "style-7" ) {

															$output .= eventchamp_speaker_style_7( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["profession"] ), $company = esc_attr( $atts["company"] ), $summary = esc_attr( $atts["short-biography"] ), $social = esc_attr( $atts["social-links"] ) );

														} elseif( $atts["style"] == "style-8" ) {

															$output .= eventchamp_speaker_style_8( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["profession"] ), $company = esc_attr( $atts["company"] ), $summary = esc_attr( $atts["short-biography"] ), $social = esc_attr( $atts["social-links"] ) );

														}

													$output .= '</div>';
												$output .= '</div>';

											}

										$output .= '</div>';

										if( $atts["all-speakers-button"] == "true" ) {

											$output .= '<div class="gt-pagination">';
												$output .= '<a href="' . esc_url( get_post_type_archive_link( 'speaker' ) ) . '" class="gt-all-button">' . esc_html__( 'All Speakers', 'eventchamp-core' ) . '</a>';
											$output .= '</div>';

										}

									$output .= '</div>';

								}

							}
							wp_reset_postdata();
 
					}

					$i = 0;

					foreach( $category_terms as $category_term ) {

						if( !empty( $category_term ) ) {

							$i++;

							$tax_extra_query = array(
								'tax_query' => array(
									'relation' => 'AND',
									$include_category_array,
									$include_tags_array,
									$include_location_array,
									$exclude_category_array,
									$exclude_tag_array,
									$exclude_location_array,
									array(
										'taxonomy' => 'speaker-category',
										'field' => 'slug',
										'terms' => array( $category_term->slug ),
									),
								),
							);

							$tab_arg_tab = wp_parse_args( $tab_arg, $tax_extra_query );

							$wp_query_tab = new WP_Query( $tab_arg_tab );

							if( !empty( $wp_query_tab ) ) {

								if( $wp_query_tab->have_posts() ) {

									$output .= '<div role="tabpanel" class="tab-pane fade' . ( $i == "1" && $atts["all-speakers-tab"] == "false" ? ' active show' : '' )  . '" id="categorized-speakers-' . esc_attr( $category_term->slug ) . '-' . esc_attr( $i ) . '" aria-labelledby="categorized-speakers-' . esc_attr( $category_term->slug ) . '">';

										$output .= '<div class="gt-columns gt-column-' . esc_attr( $atts["column"] ) . '" gt-column-space-' . esc_attr( $atts["column-space"] ) . '">';

											while( $wp_query_tab->have_posts() ) {

												$wp_query_tab->the_post();

												$output .= '<div class="gt-col">';
													$output .= '<div class="gt-inner">';

														if( $atts["style"] == "style-1" ) {

															$output .= eventchamp_speaker_style_1( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["profession"] ), $company = esc_attr( $atts["company"] ), $summary = esc_attr( $atts["short-biography"] ), $social = esc_attr( $atts["social-links"] ) );

														} elseif( $atts["style"] == "style-2" ) {

															$output .= eventchamp_speaker_style_2( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["profession"] ), $company = esc_attr( $atts["company"] ), $summary = esc_attr( $atts["short-biography"] ), $social = esc_attr( $atts["social-links"] ) );

														} elseif( $atts["style"] == "style-3" ) {

															$output .= eventchamp_speaker_style_3( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["profession"] ), $company = esc_attr( $atts["company"] ), $summary = esc_attr( $atts["short-biography"] ), $social = esc_attr( $atts["social-links"] ) );

														} elseif( $atts["style"] == "style-4" ) {

															$output .= eventchamp_speaker_style_4( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["profession"] ), $company = esc_attr( $atts["company"] ), $summary = esc_attr( $atts["short-biography"] ), $social = esc_attr( $atts["social-links"] ) );

														} elseif( $atts["style"] == "style-5" ) {

															$output .= eventchamp_speaker_style_5( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["profession"] ), $company = esc_attr( $atts["company"] ), $summary = esc_attr( $atts["short-biography"] ), $social = esc_attr( $atts["social-links"] ) );

														} elseif( $atts["style"] == "style-6" ) {

															$output .= eventchamp_speaker_style_6( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["profession"] ), $company = esc_attr( $atts["company"] ), $summary = esc_attr( $atts["short-biography"] ), $social = esc_attr( $atts["social-links"] ) );

														} elseif( $atts["style"] == "style-7" ) {

															$output .= eventchamp_speaker_style_7( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["profession"] ), $company = esc_attr( $atts["company"] ), $summary = esc_attr( $atts["short-biography"] ), $social = esc_attr( $atts["social-links"] ) );

														} elseif( $atts["style"] == "style-8" ) {

															$output .= eventchamp_speaker_style_8( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $atts["profession"] ), $company = esc_attr( $atts["company"] ), $summary = esc_attr( $atts["short-biography"] ), $social = esc_attr( $atts["social-links"] ) );

														}

													$output .= '</div>';
												$output .= '</div>';

											}

										$output .= '</div>';

										if( $atts["all-speakers-button"] == "true" ) {

											$output .= '<div class="gt-pagination">';
												$output .= '<a href="' . esc_url( get_term_link( $category_term->term_id ) . '?post_type=speaker' ) . '" class="gt-all-button">';
													$output .= sprintf( esc_html__( 'All %1$s Speakers', 'eventchamp-core' ), esc_attr( $category_term->name ) );
												$output .= '</a>';
											$output .= '</div>';

										}

									$output .= '</div>';

								}

							}
							wp_reset_postdata();

						}

					}

				$output .= '</div>';
			$output .= '</div>';

		}

		return $output;

	}
	add_shortcode( "eventchamp_categorized_speakers", "eventchamp_categorized_speakers_output" );

	if( function_exists( 'vc_map' ) ) {

		vc_map(
			array(
				"name" => esc_html__( 'Categorized Speakers', 'eventchamp-core' ),
				"base" => "eventchamp_categorized_speakers",
				"category" => esc_html__( 'Eventchamp Theme', 'eventchamp-core' ),
				"icon" => get_template_directory_uri() . '/include/assets/img/icons/categorized-speakers.jpg',
				"description" => esc_html__( 'List the speakers by categorizing', 'eventchamp-core' ),
				"params" => array(
					array(
						"type" => "textfield",
						"param_name" => "count",
						"heading" => esc_html__( 'Count', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-speakers",
						"heading" => esc_html__( 'Exclude Speakers', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "offset",
						"heading" => esc_html__( 'Offset', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "order",
						"heading" => esc_html__( 'Order', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'ASC', 'eventchamp-core' ) => 'ASC',
							esc_html__( 'DESC', 'eventchamp-core' ) => 'DESC',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "order-type",
						"heading" => esc_html__( 'Order Type', 'eventchamp-core' ),
						"group" => esc_html__( 'General', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Added Date', 'eventchamp-core' ) => 'added-date',
							esc_html__( 'Popular by Comment', 'eventchamp-core' ) => 'popular-comment',
							esc_html__( 'ID', 'eventchamp-core' ) => 'id',
							esc_html__( 'Title', 'eventchamp-core' ) => 'title',
							esc_html__( 'Menu Order', 'eventchamp-core' ) => 'menu_order',
							esc_html__( 'Random', 'eventchamp-core' ) => 'rand',
							esc_html__( 'By Include IDs', 'eventchamp-core' ) => 'post__in',
							esc_html__( 'None', 'eventchamp-core' ) => 'none',
						),
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-categories",
						"heading" => esc_html__( 'Exclude Categories', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-locations",
						"heading" => esc_html__( 'Exclude Locations', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "exclude-tags",
						"heading" => esc_html__( 'Exclude Tags', 'eventchamp-core' ),
						"description" => esc_html__( 'Example: Event.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-categories",
						"heading" => esc_html__( 'Include Categories', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-locations",
						"heading" => esc_html__( 'Include Locations', 'eventchamp-core' ),
						"description" => esc_html__( 'Separate with commas. Example: 1, 2, 3 etc.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "textfield",
						"param_name" => "include-tags",
						"heading" => esc_html__( 'Include Tag', 'eventchamp-core' ),
						"description" => esc_html__( 'Example: Event.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
					),
					array(
						"type" => "dropdown",
						"param_name" => "taxonomy-order",
						"heading" => esc_html__( 'Taxonomy Order', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'ASC', 'eventchamp-core' ) => 'ASC',
							esc_html__( 'DESC', 'eventchamp-core' ) => 'DESC',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "taxonomy-order-type",
						"heading" => esc_html__( 'Taxonomy Order Type', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Name', 'eventchamp-core' ) => 'name',
							esc_html__( 'Slug', 'eventchamp-core' ) => 'slug',
							esc_html__( 'Term Group', 'eventchamp-core' ) => 'term_group',
							esc_html__( 'Term ID', 'eventchamp-core' ) => 'term_id',
							esc_html__( 'ID', 'eventchamp-core' ) => 'id',
							esc_html__( 'Description', 'eventchamp-core' ) => 'description',
							esc_html__( 'Parent', 'eventchamp-core' ) => 'parent',
							esc_html__( 'Count', 'eventchamp-core' ) => 'count',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "hide-empty-taxonomies",
						"heading" => esc_html__( 'Hide Empty Taxonomies', 'eventchamp-core' ),
						"description" => esc_html__( 'If you choose true option empty taxonomies will be hide.', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "childless",
						"heading" => esc_html__( 'Childless', 'eventchamp-core' ),
						"group" => esc_html__( 'Taxonomies', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "category-list-align",
						"heading" => esc_html__( 'Category List Align', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						"save_always" => true,
						"value" => array(
							esc_html__( 'Left', 'eventchamp-core' ) => 'left',
							esc_html__( 'Center', 'eventchamp-core' ) => 'center',
							esc_html__( 'Right', 'eventchamp-core' ) => 'right',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "style",
						"heading" => esc_html__( 'Style', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'Style 1', 'eventchamp-core' ) => 'style-1',
							esc_html__( 'Style 2', 'eventchamp-core' ) => 'style-2',
							esc_html__( 'Style 3', 'eventchamp-core' ) => 'style-3',
							esc_html__( 'Style 4', 'eventchamp-core' ) => 'style-4',
							esc_html__( 'Style 5', 'eventchamp-core' ) => 'style-5',
							esc_html__( 'Style 6', 'eventchamp-core' ) => 'style-6',
							esc_html__( 'Style 7', 'eventchamp-core' ) => 'style-7',
							esc_html__( 'Style 8', 'eventchamp-core' ) => 'style-8',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "column",
						"heading" => esc_html__( 'Column', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( '1 Column', 'eventchamp-core' ) => '1',
							esc_html__( '2 Column', 'eventchamp-core' ) => '2',
							esc_html__( '3 Column', 'eventchamp-core' ) => '3',
							esc_html__( '4 Column', 'eventchamp-core' ) => '4',
							esc_html__( '5 Column', 'eventchamp-core' ) => '5',
							esc_html__( '6 Column', 'eventchamp-core' ) => '6',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "column-space",
						"heading" => esc_html__( 'Column Space', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( '0', 'eventchamp-core' ) => '0',
							esc_html__( '5', 'eventchamp-core' ) => '5',
							esc_html__( '10', 'eventchamp-core' ) => '10',
							esc_html__( '15', 'eventchamp-core' ) => '15',
							esc_html__( '20', 'eventchamp-core' ) => '20',
							esc_html__( '25', 'eventchamp-core' ) => '25',
							esc_html__( '30', 'eventchamp-core' ) => '30',
							esc_html__( '35', 'eventchamp-core' ) => '35',
							esc_html__( '40', 'eventchamp-core' ) => '40',
							esc_html__( '45', 'eventchamp-core' ) => '45',
							esc_html__( '50', 'eventchamp-core' ) => '50',
							esc_html__( '55', 'eventchamp-core' ) => '55',
							esc_html__( '60', 'eventchamp-core' ) => '60',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "all-speakers-tab",
						"heading" => esc_html__( 'All Speakers Tab', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "all-speakers-button",
						"heading" => esc_html__( 'All Speakers Button', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "profession",
						"heading" => esc_html__( 'Profession', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "company",
						"heading" => esc_html__( 'Company', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "short-biography",
						"heading" => esc_html__( 'Short Biography', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
					array(
						"type" => "dropdown",
						"param_name" => "social-links",
						"heading" => esc_html__( 'Social Links', 'eventchamp-core' ),
						"group" => esc_html__( 'Design', 'eventchamp-core' ),
						'save_always' => true,
						"value" => array(
							esc_html__( 'False', 'eventchamp-core' ) => 'false',
							esc_html__( 'True', 'eventchamp-core' ) => 'true',
						),
					),
				),
			)
		);

	}

}