<?php
/*======
*
* Speakers Widget
*
======*/
	if( !function_exists( 'eventchamp_latest_speakers_register_widgets' ) ) {

		function eventchamp_latest_speakers_register_widgets() {

			register_widget( 'eventchamp_latest_speakers_widget' );

		}
		add_action( 'widgets_init', 'eventchamp_latest_speakers_register_widgets' );

	}



	if( !class_exists( 'eventchamp_latest_speakers_widget' ) ) {

		class eventchamp_latest_speakers_widget extends WP_Widget {

			function __construct() {

				parent::__construct(
					'eventchamp_latest_speakers_widget',
					esc_html__( 'Eventchamp: Speakers', 'eventchamp-core' ),
					array( 'description' => esc_html__( 'A speaker listing widget', 'eventchamp-core' ), )
				);

			}
			
			function widget( $args, $instance ) {

				echo $args['before_widget'];

					/*====== Title ======*/
					if ( !empty( $instance['latest_speakers_widget_title'] ) ) {

						echo '<div class="gt-widget-title">';
							echo '<span>' . esc_attr( $instance['latest_speakers_widget_title'] ) . '</span>';
						echo '</div>';

					}

					/*====== Instance ======*/
					if( !empty( $instance ) ) {

						$latest_speakers_widget_title = esc_attr( $instance['latest_speakers_widget_title'] );
						$latest_speakers_widget_exclude = esc_attr( $instance['latest_speakers_widget_exclude'] );
						$latest_speakers_widget_ids = esc_attr( $instance['latest_speakers_widget_ids'] );
						$latest_speakers_widget_offset = esc_attr( $instance['latest_speakers_widget_offset'] );
						$latest_speakers_widget_style = esc_attr( $instance['latest_speakers_widget_style'] );
						$latest_speakers_widget_column = esc_attr( $instance['latest_speakers_widget_column'] );
						$latest_speakers_widget_column_space = esc_attr( $instance['latest_speakers_widget_column_space'] );
						$latest_speakers_widget_speaker_count = esc_attr( $instance['latest_speakers_widget_speaker_count'] );

					}

					/*====== Settings ======*/
					$profession = ot_get_option( 'speaker-archives-profession', 'on' );
					$company = ot_get_option( 'speaker-archives-company', 'off' );
					$short_bio = ot_get_option( 'speaker-archives-short-bio', 'on' );
					$social_links = ot_get_option( 'speaker-archives-social-links', 'on' );

					if( $profession == "on" ) {

						$profession = "true";

					}

					if( $company == "on" ) {

						$company = "true";

					}

					if( $short_bio == "on" ) {

						$short_bio = "true";

					}

					if( $social_links == "on" ) {

						$social_links = "true";

					}

					/*====== Exclude ======*/
					if( !empty( $latest_speakers_widget_exclude ) ) {

						$latest_speakers_widget_exclude = $latest_speakers_widget_exclude;
						$latest_speakers_widget_exclude = explode( ',', $latest_speakers_widget_exclude );

					}

					/*====== Include ======*/
					if( !empty( $latest_speakers_widget_ids ) ) {

						$latest_speakers_widget_ids = $latest_speakers_widget_ids;
						$latest_speakers_widget_ids = explode( ',', $latest_speakers_widget_ids );

					}

					/*====== HTML Output ======*/
					echo eventchamp_widget_before();

						echo '<div class="gt-speakers-widget">';

							$query_args = array(
								'posts_per_page' => $latest_speakers_widget_speaker_count,
								'post_status' => 'publish',
								'post__not_in' => $latest_speakers_widget_exclude,
								'post__in' => $latest_speakers_widget_ids,
								'offset' => $latest_speakers_widget_offset,
								'post_type' => 'speaker',
							);

							$wp_query = new WP_Query( $query_args );

							if( $wp_query->have_posts() ) {

								if( $latest_speakers_widget_style == "style1" ) {

									echo '<div class="gt-columns gt-column-' . esc_attr( $latest_speakers_widget_column ) . ' gt-column-space-' . esc_attr( $latest_speakers_widget_column_space ) . '">';

										while ( $wp_query->have_posts() ) {

											$wp_query->the_post();

											echo '<div class="gt-col">';
												echo '<div class="gt-inner">';
													echo eventchamp_speaker_style_1( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $profession ), $company = esc_attr( $company ), $summary = esc_attr( $short_bio ), $social = esc_attr( $social_links ) );
												echo '</div>';
											echo '</div>';

										}
										wp_reset_postdata();

									echo '</div>';

								} elseif( $latest_speakers_widget_style == "style2" ) {

									echo '<div class="gt-columns gt-column-' . esc_attr( $latest_speakers_widget_column ) . ' gt-column-space-' . esc_attr( $latest_speakers_widget_column_space ) . '">';

										while ( $wp_query->have_posts() ) {

											$wp_query->the_post();

											echo '<div class="gt-col">';
												echo '<div class="gt-inner">';
													echo eventchamp_speaker_style_2( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $profession ), $company = esc_attr( $company ), $summary = esc_attr( $short_bio ), $social = esc_attr( $social_links ) );
												echo '</div>';
											echo '</div>';

										}
										wp_reset_postdata();

									echo '</div>';

								} elseif( $latest_speakers_widget_style == "style3" ) {

									echo '<div class="gt-columns gt-column-' . esc_attr( $latest_speakers_widget_column ) . ' gt-column-space-' . esc_attr( $latest_speakers_widget_column_space ) . '">';

										while ( $wp_query->have_posts() ) {

											$wp_query->the_post();

											echo '<div class="gt-col">';
												echo '<div class="gt-inner">';
													echo eventchamp_speaker_style_3( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $profession ), $company = esc_attr( $company ), $summary = esc_attr( $short_bio ), $social = esc_attr( $social_links ) );
												echo '</div>';
											echo '</div>';

										}
										wp_reset_postdata();

									echo '</div>';

								} elseif( $latest_speakers_widget_style == "style4" ) {

									echo '<div class="gt-columns gt-column-' . esc_attr( $latest_speakers_widget_column ) . ' gt-column-space-' . esc_attr( $latest_speakers_widget_column_space ) . '">';

										while ( $wp_query->have_posts() ) {

											$wp_query->the_post();

											echo '<div class="gt-col">';
												echo '<div class="gt-inner">';
													echo eventchamp_speaker_style_4( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $profession ), $company = esc_attr( $company ), $summary = esc_attr( $short_bio ), $social = esc_attr( $social_links ) );
												echo '</div>';
											echo '</div>';

										}
										wp_reset_postdata();

									echo '</div>';

								} elseif( $latest_speakers_widget_style == "style5" ) {

									echo '<div class="gt-columns gt-column-' . esc_attr( $latest_speakers_widget_column ) . ' gt-column-space-' . esc_attr( $latest_speakers_widget_column_space ) . '">';

										while ( $wp_query->have_posts() ) {

											$wp_query->the_post();

											echo '<div class="gt-col">';
												echo '<div class="gt-inner">';
													echo eventchamp_speaker_style_5( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $profession ), $company = esc_attr( $company ), $summary = esc_attr( $short_bio ), $social = esc_attr( $social_links ) );
												echo '</div>';
											echo '</div>';

										}
										wp_reset_postdata();

									echo '</div>';

								} elseif( $latest_speakers_widget_style == "style6" ) {

									echo '<div class="gt-columns gt-column-' . esc_attr( $latest_speakers_widget_column ) . ' gt-column-space-' . esc_attr( $latest_speakers_widget_column_space ) . '">';

										while ( $wp_query->have_posts() ) {

											$wp_query->the_post();

											echo '<div class="gt-col">';
												echo '<div class="gt-inner">';
													echo eventchamp_speaker_style_6( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $profession ), $company = esc_attr( $company ), $summary = esc_attr( $short_bio ), $social = esc_attr( $social_links ) );
												echo '</div>';
											echo '</div>';

										}
										wp_reset_postdata();

									echo '</div>';

								} elseif( $latest_speakers_widget_style == "style7" ) {

									echo '<div class="gt-columns gt-column-' . esc_attr( $latest_speakers_widget_column ) . ' gt-column-space-' . esc_attr( $latest_speakers_widget_column_space ) . '">';

										while ( $wp_query->have_posts() ) {

											$wp_query->the_post();

											echo '<div class="gt-col">';
												echo '<div class="gt-inner">';
													echo eventchamp_speaker_style_7( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $profession ), $company = esc_attr( $company ), $summary = esc_attr( $short_bio ), $social = esc_attr( $social_links ) );
												echo '</div>';
											echo '</div>';

										}
										wp_reset_postdata();

									echo '</div>';

								} elseif( $latest_speakers_widget_style == "style8" ) {

									echo '<div class="gt-columns gt-column-' . esc_attr( $latest_speakers_widget_column ) . ' gt-column-space-' . esc_attr( $latest_speakers_widget_column_space ) . '">';

										while ( $wp_query->have_posts() ) {

											$wp_query->the_post();

											echo '<div class="gt-col">';
												echo '<div class="gt-inner">';
													echo eventchamp_speaker_style_8( $post_id = get_the_ID(), $image = "true", $profession = esc_attr( $profession ), $company = esc_attr( $company ), $summary = esc_attr( $short_bio ), $social = esc_attr( $social_links ) );
												echo '</div>';
											echo '</div>';

										}
										wp_reset_postdata();

									echo '</div>';

								}

							}

						echo '</div>';

					echo eventchamp_widget_after();

				echo $args['after_widget'];

			}

			function update( $new_instance, $old_instance ) {

				$instance = $old_instance;
				$instance['latest_speakers_widget_title'] = esc_attr( $new_instance['latest_speakers_widget_title'] );
				$instance['latest_speakers_widget_exclude'] = esc_attr( $new_instance['latest_speakers_widget_exclude'] );
				$instance['latest_speakers_widget_ids'] = esc_attr( $new_instance['latest_speakers_widget_ids'] );
				$instance['latest_speakers_widget_offset'] = esc_attr( $new_instance['latest_speakers_widget_offset'] );
				$instance['latest_speakers_widget_style'] = esc_attr( $new_instance['latest_speakers_widget_style'] );
				$instance['latest_speakers_widget_column'] = esc_attr( $new_instance['latest_speakers_widget_column'] );
				$instance['latest_speakers_widget_column_space'] = esc_attr( $new_instance['latest_speakers_widget_column_space'] );
				$instance['latest_speakers_widget_speaker_count'] = esc_attr( $new_instance['latest_speakers_widget_speaker_count'] );

				return $instance;

			}

			function form( $instance ) {

				$latest_speakers_widget_title = '';
				$latest_speakers_widget_exclude = '';
				$latest_speakers_widget_ids = '';
				$latest_speakers_widget_offset = '';
				$latest_speakers_widget_style = '';
				$latest_speakers_widget_column = '';
				$latest_speakers_widget_column_space = '';
				$latest_speakers_widget_speaker_count = '';

				if( !empty( $instance ) ) {

					$latest_speakers_widget_title = esc_attr( $instance['latest_speakers_widget_title'] );
					$latest_speakers_widget_exclude = esc_attr( $instance['latest_speakers_widget_exclude'] );
					$latest_speakers_widget_ids = esc_attr( $instance['latest_speakers_widget_ids'] );
					$latest_speakers_widget_offset = esc_attr( $instance['latest_speakers_widget_offset'] );
					$latest_speakers_widget_style = esc_attr( $instance['latest_speakers_widget_style'] );
					$latest_speakers_widget_column = esc_attr( $instance['latest_speakers_widget_column'] );
					$latest_speakers_widget_column_space = esc_attr( $instance['latest_speakers_widget_column_space'] );
					$latest_speakers_widget_speaker_count = esc_attr( $instance['latest_speakers_widget_speaker_count'] );

				}

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_speakers_widget_title' ) ) . '">' . esc_html__( 'Widget Title', 'eventchamp-core' ) . '</label>';
					echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'latest_speakers_widget_title' ) ) . '" name="' . esc_attr( $this->get_field_name( 'latest_speakers_widget_title' ) ) . '" type="text" value="' . esc_attr( $latest_speakers_widget_title ) . '" />';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_speakers_widget_speaker_count' ) ) . '">' . esc_html__( 'Speaker Count', 'eventchamp-core' ) . '</label>';
					echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'latest_speakers_widget_speaker_count' ) ) . '" name="' . esc_attr( $this->get_field_name( 'latest_speakers_widget_speaker_count' ) ) . '" type="text" value="' . esc_attr( $latest_speakers_widget_speaker_count ) . '" />';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_speakers_widget_exclude' ) ) . '">' . esc_html__( 'Exclude Speakers', 'eventchamp-core' ) . '</label>';
					echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'latest_speakers_widget_exclude' ) ) . '" name="' . esc_attr( $this->get_field_name( 'latest_speakers_widget_exclude' ) ) . '" type="text" value="' . esc_attr( $latest_speakers_widget_exclude ) . '" />';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_speakers_widget_ids' ) ) . '">' . esc_html__( "Include Speakers:", "eventchamp" ) . '</label>';
					echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'latest_speakers_widget_ids' ) ) . '" name="' . esc_attr( $this->get_field_name( 'latest_speakers_widget_ids' ) ) . '" type="text" value="' . esc_attr( $latest_speakers_widget_ids ) . '" />';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_speakers_widget_offset' ) ) . '">' . esc_html__( 'Offset', 'eventchamp-core' ) . '</label>';
					echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'latest_speakers_widget_offset' ) ) . '" name="' . esc_attr( $this->get_field_name( 'latest_speakers_widget_offset' ) ) . '" type="text" value="' . esc_attr( $latest_speakers_widget_offset ) . '" />';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_speakers_widget_style' ) ) . '">' . esc_html__( 'Style', 'eventchamp-core' ) . '</label>';
					echo '<select name="' . esc_attr( $this->get_field_name( 'latest_speakers_widget_style' ) ) . '" id="' . esc_attr( $this->get_field_id( 'latest_speakers_widget_style' ) ) . '" class="widefat"> ';
						echo '<option value="style1" ' . ( $latest_speakers_widget_style == "style1" ? 'selected' : '' ) . '>' . esc_html__( 'Style 1', 'eventchamp-core' ) . '</option>';
						echo '<option value="style2" ' . ( $latest_speakers_widget_style == "style2" ? 'selected' : '' ) . '>' . esc_html__( 'Style 2', 'eventchamp-core' ) . '</option>';
						echo '<option value="style3" ' . ( $latest_speakers_widget_style == "style3" ? 'selected' : '' ) . '>' . esc_html__( 'Style 3', 'eventchamp-core' ) . '</option>';
						echo '<option value="style4" ' . ( $latest_speakers_widget_style == "style4" ? 'selected' : '' ) . '>' . esc_html__( 'Style 4', 'eventchamp-core' ) . '</option>';
						echo '<option value="style5" ' . ( $latest_speakers_widget_style == "style5" ? 'selected' : '' ) . '>' . esc_html__( 'Style 5', 'eventchamp-core' ) . '</option>';
						echo '<option value="style6" ' . ( $latest_speakers_widget_style == "style6" ? 'selected' : '' ) . '>' . esc_html__( 'Style 6', 'eventchamp-core' ) . '</option>';
						echo '<option value="style7" ' . ( $latest_speakers_widget_style == "style7" ? 'selected' : '' ) . '>' . esc_html__( 'Style 7', 'eventchamp-core' ) . '</option>';
						echo '<option value="style8" ' . ( $latest_speakers_widget_style == "style8" ? 'selected' : '' ) . '>' . esc_html__( 'Style 8', 'eventchamp-core' ) . '</option>';
					echo '</select>';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_speakers_widget_column' ) ) . '">' . esc_html__( 'Column', 'eventchamp-core' ) . '</label>';
					echo '<select name="' . esc_attr( $this->get_field_name( 'latest_speakers_widget_column' ) ) . '" id="' . esc_attr( $this->get_field_id( 'latest_speakers_widget_column' ) ) . '" class="widefat"> ';
						echo '<option value="1" ' . ( $latest_speakers_widget_column == "1" ? 'selected' : '' ) . '>' . esc_html__( '1 Column', 'eventchamp-core' ) . '</option>';
						echo '<option value="2" ' . ( $latest_speakers_widget_column == "2" ? 'selected' : '' ) . '>' . esc_html__( '2 Column', 'eventchamp-core' ) . '</option>';
						echo '<option value="3" ' . ( $latest_speakers_widget_column == "3" ? 'selected' : '' ) . '>' . esc_html__( '3 Column', 'eventchamp-core' ) . '</option>';
						echo '<option value="4" ' . ( $latest_speakers_widget_column == "4" ? 'selected' : '' ) . '>' . esc_html__( '4 Column', 'eventchamp-core' ) . '</option>';
					echo '</select>';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_speakers_widget_column_space' ) ) . '">' . esc_html__( 'Column Space', 'eventchamp-core' ) . '</label>';
					echo '<select name="' . esc_attr( $this->get_field_name( 'latest_speakers_widget_column_space' ) ) . '" id="' . esc_attr( $this->get_field_id( 'latest_speakers_widget_column_space' ) ) . '" class="widefat"> ';
						echo '<option value="0" ' . ( $latest_speakers_widget_column_space == "0" ? 'selected' : '' ) . '>' . esc_html__( '0', 'eventchamp-core' ) . '</option>';
						echo '<option value="5" ' . ( $latest_speakers_widget_column_space == "5" ? 'selected' : '' ) . '>' . esc_html__( '5', 'eventchamp-core' ) . '</option>';
						echo '<option value="10" ' . ( $latest_speakers_widget_column_space == "10" ? 'selected' : '' ) . '>' . esc_html__( '10', 'eventchamp-core' ) . '</option>';
						echo '<option value="15" ' . ( $latest_speakers_widget_column_space == "15" ? 'selected' : '' ) . '>' . esc_html__( '15', 'eventchamp-core' ) . '</option>';
						echo '<option value="20" ' . ( $latest_speakers_widget_column_space == "20" ? 'selected' : '' ) . '>' . esc_html__( '20', 'eventchamp-core' ) . '</option>';
						echo '<option value="25" ' . ( $latest_speakers_widget_column_space == "25" ? 'selected' : '' ) . '>' . esc_html__( '25', 'eventchamp-core' ) . '</option>';
						echo '<option value="30" ' . ( $latest_speakers_widget_column_space == "30" ? 'selected' : '' ) . '>' . esc_html__( '30', 'eventchamp-core' ) . '</option>';
						echo '<option value="35" ' . ( $latest_speakers_widget_column_space == "35" ? 'selected' : '' ) . '>' . esc_html__( '35', 'eventchamp-core' ) . '</option>';
						echo '<option value="40" ' . ( $latest_speakers_widget_column_space == "40" ? 'selected' : '' ) . '>' . esc_html__( '40', 'eventchamp-core' ) . '</option>';
						echo '<option value="45" ' . ( $latest_speakers_widget_column_space == "45" ? 'selected' : '' ) . '>' . esc_html__( '45', 'eventchamp-core' ) . '</option>';
						echo '<option value="50" ' . ( $latest_speakers_widget_column_space == "50" ? 'selected' : '' ) . '>' . esc_html__( '50', 'eventchamp-core' ) . '</option>';
						echo '<option value="55" ' . ( $latest_speakers_widget_column_space == "55" ? 'selected' : '' ) . '>' . esc_html__( '55', 'eventchamp-core' ) . '</option>';
						echo '<option value="60" ' . ( $latest_speakers_widget_column_space == "60" ? 'selected' : '' ) . '>' . esc_html__( '60', 'eventchamp-core' ) . '</option>';
					echo '</select>';
				echo '</p>';

			}

		}

	}