<?php
/*======
*
* Events Widget
*
======*/
	if( !function_exists( 'eventchamp_latest_events_register_widgets' ) ) {

		function eventchamp_latest_events_register_widgets() {

			register_widget( 'eventchamp_latest_events_widget' );

		}
		add_action( 'widgets_init', 'eventchamp_latest_events_register_widgets' );

	}



	if( !class_exists( 'eventchamp_latest_events_widget' ) ) {

		class eventchamp_latest_events_widget extends WP_Widget {

			function __construct() {

				parent::__construct(

					'eventchamp_latest_events_widget',
					esc_html__( 'Eventchamp: Events', 'eventchamp-core' ),
					array( 'description' => esc_html__( 'A event listing widget', 'eventchamp-core' ), )

				);

			}

			function widget( $args, $instance ) {

				echo $args['before_widget'];

					/*====== Title ======*/
					if ( !empty( $instance['latest_events_widget_title'] ) ) {

						echo '<div class="gt-widget-title">';
							echo '<span>' . esc_attr( $instance['latest_events_widget_title'] ) . '</span>';
						echo '</div>';

					}

					/*====== Instance ======*/
					if( !empty( $instance ) ) {

						$latest_events_widget_style = esc_attr( $instance['latest_events_widget_style'] );
						$latest_events_widget_column = esc_attr( $instance['latest_events_widget_column'] );
						$latest_events_widget_column_space = esc_attr( $instance['latest_events_widget_column_space'] );
						$latest_events_widget_title = esc_attr( $instance['latest_events_widget_title'] );
						$latest_events_widget_category = esc_attr( $instance['latest_events_widget_category'] );
						$latest_events_widget_exclude = esc_attr( $instance['latest_events_widget_exclude'] );
						$latest_events_widget_ids = esc_attr( $instance['latest_events_widget_ids'] );
						$latest_events_widget_offset = esc_attr( $instance['latest_events_widget_offset'] );
						$latest_events_widget_event_count = esc_attr( $instance['latest_events_widget_event_count'] );

					}
					
					/*====== Customizer ======*/
					$price = ot_get_option( 'event-archives-price', 'on' );
					$status = ot_get_option( 'event-archives-status', 'on' );
					$category = ot_get_option( 'event-archives-category', 'on' );
					$location = ot_get_option( 'event-archives-location', 'on' );
					$venue = ot_get_option( 'event-archives-venue', 'off' );
					$organizer = ot_get_option( 'event-archives-organizer', 'off' );
					$start_date = ot_get_option( 'event-archives-start-date', 'on' );
					$start_time = ot_get_option( 'event-archives-start-time', 'on' );
					$end_date = ot_get_option( 'event-archives-end-date', 'off' );
					$end_time = ot_get_option( 'event-archives-end-time', 'off' );
					$ticket_amount = ot_get_option( 'event-archives-ticket-amount', 'off' );
					$excerpt = ot_get_option( 'event-archives-excerpt', 'on' );

					if( $price == "on" ) {

						$price = "true";

					}

					if( $status == "on" ) {

						$status = "true";

					}

					if( $category == "on" ) {

						$category = "true";

					}

					if( $location == "on" ) {

						$location = "true";

					}

					if( $venue == "on" ) {

						$venue = "true";

					}

					if( $organizer == "on" ) {

						$organizer = "true";

					}

					if( $start_date == "on" ) {

						$start_date = "true";

					}

					if( $start_time == "on" ) {

						$start_time = "true";

					}

					if( $end_date == "on" ) {

						$end_date = "true";

					}

					if( $end_time == "on" ) {

						$end_time = "true";

					}

					if( $ticket_amount == "on" ) {

						$ticket_amount = "true";

					}

					if( $excerpt == "on" ) {

						$excerpt = "true";

					}
					
					/*====== Exclude ======*/
					if( !empty( $latest_events_widget_exclude ) ) {

						$latest_events_widget_exclude = $latest_events_widget_exclude;
						$latest_events_widget_exclude = explode( ',', $latest_events_widget_exclude );

					}
					
					/*====== Include ======*/
					if( !empty( $latest_events_widget_ids ) ) {

						$latest_events_widget_ids = $latest_events_widget_ids;
						$latest_events_widget_ids = explode( ',', $latest_events_widget_ids );

					}

					/*====== HTML Output ======*/
					echo eventchamp_widget_before();

						echo '<div class="gt-events-widget">';

							if( !empty( $latest_events_widget_category ) ) {

								$query_args = array(
									'posts_per_page' => $latest_events_widget_event_count,
									'post_status' => 'publish',
									'post__not_in' => $latest_events_widget_exclude,
									'post__in' => $latest_events_widget_ids,
									'offset' => $latest_events_widget_offset,
									'post_type' => 'event',
									'tax_query' => array(
										array(
											'taxonomy' => 'eventcat',
											'field' => 'term_id',
											'terms' => $latest_events_widget_category,
										),
									),
								);

							} else {

								$query_args = array(
									'posts_per_page' => $latest_events_widget_event_count,
									'post_status' => 'publish',
									'post__not_in' => $latest_events_widget_exclude,
									'post__in' => $latest_events_widget_ids,
									'offset' => $latest_events_widget_offset,
									'post_type' => 'event',
								);

							}

							$wp_query = new WP_Query( $query_args );

							if( $wp_query->have_posts() ) {

								if( $latest_events_widget_style == "style2" ) {

									echo '<div class="gt-columns gt-column-' . esc_attr( $latest_events_widget_column ) . ' gt-column-space-' . esc_attr( $latest_events_widget_column_space ) . '">';

										while ( $wp_query->have_posts() ) {

											$wp_query->the_post();

											echo '<div class="gt-col">';
												echo '<div class="gt-inner">';
													echo eventchamp_event_list_style_2( $post_id = get_the_ID(), $image = "true", $date = esc_attr( $start_date ), $location = esc_attr( $location ), $venue = esc_attr( $venue ) );
												echo '</div>';
											echo '</div>';

										}
										wp_reset_postdata();

									echo '</div>';

								} elseif( $latest_events_widget_style == "style1" ) {

									echo '<div class="gt-columns gt-column-' . esc_attr( $latest_events_widget_column ) . ' gt-column-space-' . esc_attr( $latest_events_widget_column_space ) . '">';

										while ( $wp_query->have_posts() ) {

											$wp_query->the_post();

											echo '<div class="gt-col">';
												echo '<div class="gt-inner">';
													echo eventchamp_event_list_style_1( $post_id = get_the_ID(), $image = "true", $category = esc_attr( $category ), $start_date = esc_attr( $start_date ), $end_date = esc_attr( $end_date ), $location = esc_attr( $location ), $excerpt = esc_attr( $excerpt ), $status = esc_attr( $status ), $price = esc_attr( $price ), $venue = esc_attr( $venue ), $ticket_amount = esc_attr( $ticket_amount ), $start_time = esc_attr( $start_time ), $end_time = esc_attr( $end_date ), $organizer = esc_attr( $organizer ) );
												echo '</div>';
											echo '</div>';

										}
										wp_reset_postdata();

									echo '</div>';

								} elseif( $latest_events_widget_style == "style3" ) {

									echo '<div class="gt-columns gt-column-' . esc_attr( $latest_events_widget_column ) . ' gt-column-space-' . esc_attr( $latest_events_widget_column_space ) . '">';

										while ( $wp_query->have_posts() ) {
											
											$wp_query->the_post();

											echo '<div class="gt-col">';
												echo '<div class="gt-inner">';
													echo eventchamp_event_list_style_3( $post_id = get_the_ID(), $image = "true", $category = esc_attr( $category ), $start_date = esc_attr( $start_date ), $end_date = esc_attr( $end_date ), $location = esc_attr( $location ), $excerpt = esc_attr( $excerpt ), $status = esc_attr( $status ), $price = esc_attr( $price ), $venue = esc_attr( $venue ), $ticket_amount = esc_attr( $ticket_amount ), $start_time = esc_attr( $start_time ), $end_time = esc_attr( $end_date ), $organizer = esc_attr( $organizer ) );
												echo '</div>';
											echo '</div>';

										}
										wp_reset_postdata();

									echo '</div>';

								} elseif( $latest_events_widget_style == "style4" ) {

									echo '<div class="gt-columns gt-column-' . esc_attr( $latest_events_widget_column ) . ' gt-column-space-' . esc_attr( $latest_events_widget_column_space ) . '">';

										while ( $wp_query->have_posts() ) {

											$wp_query->the_post();

											echo '<div class="gt-col">';
												echo '<div class="gt-inner">';
													echo eventchamp_event_list_style_4( $post_id = get_the_ID(), $image = "true", $category = esc_attr( $category ), $start_date = esc_attr( $start_date ), $end_date = esc_attr( $end_date ), $location = esc_attr( $location ), $excerpt = esc_attr( $excerpt ), $status = esc_attr( $status ), $price = esc_attr( $price ), $venue = esc_attr( $venue ), $ticket_amount = esc_attr( $ticket_amount ), $start_time = esc_attr( $start_time ), $end_time = esc_attr( $end_date ), $organizer = esc_attr( $organizer ) );
												echo '</div>';
											echo '</div>';

										}
										wp_reset_postdata();

									echo '</div>';

								}

							}

						echo '</div>';

					echo eventchamp_widget_after();

				echo $args['after_widget'];
				
			}

			function update( $new_instance, $old_instance ) {

				$instance = $old_instance;
				$instance['latest_events_widget_style'] = esc_attr( $new_instance['latest_events_widget_style'] );
				$instance['latest_events_widget_column'] = esc_attr( $new_instance['latest_events_widget_column'] );
				$instance['latest_events_widget_column_space'] = esc_attr( $new_instance['latest_events_widget_column_space'] );
				$instance['latest_events_widget_title'] = esc_attr( $new_instance['latest_events_widget_title'] );
				$instance['latest_events_widget_category'] = esc_attr( $new_instance['latest_events_widget_category'] );
				$instance['latest_events_widget_exclude'] = esc_attr( $new_instance['latest_events_widget_exclude'] );
				$instance['latest_events_widget_ids'] =  esc_attr( $new_instance['latest_events_widget_ids'] );
				$instance['latest_events_widget_offset'] = esc_attr( $new_instance['latest_events_widget_offset'] );
				$instance['latest_events_widget_event_count'] = esc_attr( $new_instance['latest_events_widget_event_count'] );

				return $instance;

			}

			function form( $instance ) {

				$latest_events_widget_style = '';
				$latest_events_widget_column = '';
				$latest_events_widget_column_space = '';
				$latest_events_widget_title = '';
				$latest_events_widget_category = '';
				$latest_events_widget_exclude = '';
				$latest_events_widget_ids = '';
				$latest_events_widget_offset = '';
				$latest_events_widget_event_count = '';

				if( !empty( $instance ) ) {

					$latest_events_widget_style = esc_attr( $instance['latest_events_widget_style'] );
					$latest_events_widget_column = esc_attr( $instance['latest_events_widget_column'] );
					$latest_events_widget_column_space = esc_attr( $instance['latest_events_widget_column_space'] );
					$latest_events_widget_title = esc_attr( $instance['latest_events_widget_title'] );
					$latest_events_widget_category = esc_attr( $instance['latest_events_widget_category'] );
					$latest_events_widget_exclude = esc_attr( $instance['latest_events_widget_exclude'] );
					$latest_events_widget_ids = esc_attr( $instance['latest_events_widget_ids'] );
					$latest_events_widget_offset = esc_attr( $instance['latest_events_widget_offset'] );
					$latest_events_widget_event_count = esc_attr( $instance['latest_events_widget_event_count'] );

				}

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_events_widget_title' ) ) . '">' . esc_html__( 'Widget Title', 'eventchamp-core' ) . '</label>';
					echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'latest_events_widget_title' ) ) . '" name="' . esc_attr( $this->get_field_name( 'latest_events_widget_title' ) ) . '" type="text" value="' . esc_attr( $latest_events_widget_title ) . '" />';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_events_widget_event_count' ) ) . '">' . esc_html__( 'Event Count', 'eventchamp-core' ) . '</label>';
					echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'latest_events_widget_event_count' ) ) . '" name="' . esc_attr( $this->get_field_name( 'latest_events_widget_event_count' ) ) . '" type="text" value="' . esc_attr( $latest_events_widget_event_count ) . '" />';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_events_widget_category' ) ) . '">' . esc_html__( 'Event Category', 'eventchamp-core' ) . '</label>';
					echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'latest_events_widget_category' ) ) . '" name="' . esc_attr( $this->get_field_name( 'latest_events_widget_category' ) ) . '" type="text" value="' . esc_attr( $latest_events_widget_category ) . '" />';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_events_widget_exclude' ) ) . '">' . esc_html__( 'Exclude Events', 'eventchamp-core' ) . '</label>';
					echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'latest_events_widget_exclude' ) ) . '" name="' . esc_attr( $this->get_field_name( 'latest_events_widget_exclude' ) ) . '" type="text" value="' . esc_attr( $latest_events_widget_exclude ) . '" />';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_events_widget_ids' ) ) . '">' . esc_html__( "Include Events:", "eventchamp" ) . '</label>';
					echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'latest_events_widget_ids' ) ) . '" name="' . esc_attr( $this->get_field_name( 'latest_events_widget_ids' ) ) . '" type="text" value="' . esc_attr( $latest_events_widget_ids ) . '" />';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_events_widget_offset' ) ) . '">' . esc_html__( 'Offset', 'eventchamp-core' ) . '</label>';
					echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'latest_events_widget_offset' ) ) . '" name="' . esc_attr( $this->get_field_name( 'latest_events_widget_offset' ) ) . '" type="text" value="' . esc_attr( $latest_events_widget_offset ) . '" />';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_events_widget_style' ) ) . '">' . esc_html__( 'Style', 'eventchamp-core' ) . '</label>';
					echo '<select name="' . esc_attr( $this->get_field_name( 'latest_events_widget_style' ) ) . '" id="' . esc_attr( $this->get_field_id( 'latest_events_widget_style' ) ) . '" class="widefat"> ';
						echo '<option value="style1" ' . ( $latest_events_widget_style == "style1" ? 'selected' : '' ) . '>' . esc_html__( 'Style 1', 'eventchamp-core' ) . '</option>';
						echo '<option value="style2" ' . ( $latest_events_widget_style == "style2" ? 'selected' : '' ) . '>' . esc_html__( 'Style 2', 'eventchamp-core' ) . '</option>';
						echo '<option value="style3" ' . ( $latest_events_widget_style == "style3" ? 'selected' : '' ) . '>' . esc_html__( 'Style 3', 'eventchamp-core' ) . '</option>';
						echo '<option value="style4" ' . ( $latest_events_widget_style == "style4" ? 'selected' : '' ) . '>' . esc_html__( 'Style 4', 'eventchamp-core' ) . '</option>';
					echo '</select>';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_events_widget_column' ) ) . '">' . esc_html__( 'Column', 'eventchamp-core' ) . '</label>';
					echo '<select name="' . esc_attr( $this->get_field_name( 'latest_events_widget_column' ) ) . '" id="' . esc_attr( $this->get_field_id( 'latest_events_widget_column' ) ) . '" class="widefat"> ';
						echo '<option value="1" ' . ( $latest_events_widget_column == "1" ? 'selected' : '' ) . '>' . esc_html__( '1 Column', 'eventchamp-core' ) . '</option>';
						echo '<option value="2" ' . ( $latest_events_widget_column == "2" ? 'selected' : '' ) . '>' . esc_html__( '2 Column', 'eventchamp-core' ) . '</option>';
						echo '<option value="3" ' . ( $latest_events_widget_column == "3" ? 'selected' : '' ) . '>' . esc_html__( '3 Column', 'eventchamp-core' ) . '</option>';
						echo '<option value="4" ' . ( $latest_events_widget_column == "4" ? 'selected' : '' ) . '>' . esc_html__( '4 Column', 'eventchamp-core' ) . '</option>';
					echo '</select>';
				echo '</p>';

				echo '<p>';
					echo '<label for="' . esc_attr( $this->get_field_id( 'latest_events_widget_column_space' ) ) . '">' . esc_html__( 'Column Space', 'eventchamp-core' ) . '</label>';
					echo '<select name="' . esc_attr( $this->get_field_name( 'latest_events_widget_column_space' ) ) . '" id="' . esc_attr( $this->get_field_id( 'latest_events_widget_column_space' ) ) . '" class="widefat"> ';
						echo '<option value="0" ' . ( $latest_events_widget_column_space == "0" ? 'selected' : '' ) . '>' . esc_html__( '0', 'eventchamp-core' ) . '</option>';
						echo '<option value="5" ' . ( $latest_events_widget_column_space == "5" ? 'selected' : '' ) . '>' . esc_html__( '5', 'eventchamp-core' ) . '</option>';
						echo '<option value="10" ' . ( $latest_events_widget_column_space == "10" ? 'selected' : '' ) . '>' . esc_html__( '10', 'eventchamp-core' ) . '</option>';
						echo '<option value="15" ' . ( $latest_events_widget_column_space == "15" ? 'selected' : '' ) . '>' . esc_html__( '15', 'eventchamp-core' ) . '</option>';
						echo '<option value="20" ' . ( $latest_events_widget_column_space == "20" ? 'selected' : '' ) . '>' . esc_html__( '20', 'eventchamp-core' ) . '</option>';
						echo '<option value="25" ' . ( $latest_events_widget_column_space == "25" ? 'selected' : '' ) . '>' . esc_html__( '25', 'eventchamp-core' ) . '</option>';
						echo '<option value="30" ' . ( $latest_events_widget_column_space == "30" ? 'selected' : '' ) . '>' . esc_html__( '30', 'eventchamp-core' ) . '</option>';
						echo '<option value="35" ' . ( $latest_events_widget_column_space == "35" ? 'selected' : '' ) . '>' . esc_html__( '35', 'eventchamp-core' ) . '</option>';
						echo '<option value="40" ' . ( $latest_events_widget_column_space == "40" ? 'selected' : '' ) . '>' . esc_html__( '40', 'eventchamp-core' ) . '</option>';
						echo '<option value="45" ' . ( $latest_events_widget_column_space == "45" ? 'selected' : '' ) . '>' . esc_html__( '45', 'eventchamp-core' ) . '</option>';
						echo '<option value="50" ' . ( $latest_events_widget_column_space == "50" ? 'selected' : '' ) . '>' . esc_html__( '50', 'eventchamp-core' ) . '</option>';
						echo '<option value="55" ' . ( $latest_events_widget_column_space == "55" ? 'selected' : '' ) . '>' . esc_html__( '55', 'eventchamp-core' ) . '</option>';
						echo '<option value="60" ' . ( $latest_events_widget_column_space == "60" ? 'selected' : '' ) . '>' . esc_html__( '60', 'eventchamp-core' ) . '</option>';
					echo '</select>';
				echo '</p>';

			}

		}

	}