<?php
/*======
*
* Event Search Widget
*
======*/
	if( !function_exists( 'eventchamp_event_search_register_widgets' ) ) {

		function eventchamp_event_search_register_widgets() {

			register_widget( 'eventchamp_event_search_widget' );

		}
		add_action( 'widgets_init', 'eventchamp_event_search_register_widgets' );

	}



	if( !class_exists( 'eventchamp_event_search_widget' ) ) {

		class eventchamp_event_search_widget extends WP_Widget {

			function __construct() {

				parent::__construct(
					'eventchamp_event_search_widget',
					esc_html__( 'Eventchamp: Event Search Tool', 'eventchamp-core' ),
					array( 'description' => esc_html__( 'An event search tool widget', 'eventchamp-core' ), )
				);

			}
			
			function widget( $args, $instance ) {

				echo $args['before_widget'];

					/*====== Title ======*/
					if ( !empty( $instance['widget-title'] ) ) {

						echo '<div class="gt-widget-title">';
							echo '<span>' . esc_attr( $instance['widget-title'] ) . '</span>';
						echo '</div>';

					}

					/*====== HTML Output ======*/
					echo eventchamp_widget_before();

						echo '<div class="gt-event-search-widget">';
							echo do_shortcode( '[eventchamp_event_search
								style="' . esc_attr( $instance['style'] ) . '"
								column="' . esc_attr( $instance['column'] ) . '"
								column-space="' . esc_attr( $instance['column_space'] ) . '"
								live-search-select="' . esc_attr( $instance['selects-live-search'] ) . '"
								title="' . esc_attr( $instance['search-title'] ) . '"
								startdate="' . esc_attr( $instance['start-date'] ) . '"
								enddate="' . esc_attr( $instance['end-date'] ) . '"
								keyword="' . esc_attr( $instance['keyword'] ) . '"
								category="' . esc_attr( $instance['category'] ) . '"
								location="' . esc_attr( $instance['location'] ) . '"
								venues="' . esc_attr( $instance['venue'] ) . '"
								venue-order="' . esc_attr( $instance['venue-order'] ) . '"
								venue-order-type="' . esc_attr( $instance['venue-order-type'] ) . '"
								speakers="' . esc_attr( $instance['speaker'] ) . '"
								speaker-order="' . esc_attr( $instance['speaker-order'] ) . '"
								speaker-order-type="' . esc_attr( $instance['speaker-order-type'] ) . '"
								organizer="' . esc_attr( $instance['organizer'] ) . '"
								status="' . esc_attr( $instance['status'] ) . '"
								upcoming-status="' . esc_attr( $instance['upcoming-status'] ) . '"
								showing-status="' . esc_attr( $instance['showing-status'] ) . '"
								expired-status="' . esc_attr( $instance['expired-status'] ) . '"
								tag="' . esc_attr( $instance['tag'] ) . '"
								sort="' . esc_attr( $instance['sort'] ) . '"
								sort-start-date="' . esc_attr( $instance['sort-start-date'] ) . '"
								sort-end-date="' . esc_attr( $instance['sort-end-date'] ) . '"
								sort-added-date="' . esc_attr( $instance['sort-added-date'] ) . '"
								sort-name-a-z="' . esc_attr( $instance['sort-name-a-z'] ) . '"
								sort-name-z-a="' . esc_attr( $instance['sort-name-z-a'] ) . '"
								sort-price-l-h="' . esc_attr( $instance['sort-price-l-h'] ) . '"
								sort-price-h-l="' . esc_attr( $instance['sort-price-h-l'] ) . '"
								price-slider="' . esc_attr( $instance['price-slider'] ) . '"
								price-slider-grid="' . esc_attr( $instance['price-slider-grid'] ) . '"
								price-slider-min-max="' . esc_attr( $instance['price-slider-min-max'] ) . '"
								price-slider-from-to="' . esc_attr( $instance['price-slider-from-to'] ) . '"
								taxonomy-order="' . esc_attr( $instance['taxonomy-order'] ) . '"
								taxonomy-order-type="' . esc_attr( $instance['taxonomy-order-type'] ) . '"
								empty-taxonomies="' . esc_attr( $instance['empty-taxonomies'] ) . '"
								childless="' . esc_attr( $instance['childless'] ) . '"
								hide-children="' . esc_attr( $instance['hide-children'] ) . '"
								slider-column="1"
								slider-space="0"
								slider-autoplay="true"
								slider-loop="true"
								slider-centered-slides="false"
								slider-direction="horizontal"
								slider-effect="fade"
								slider-free-mode="false"
								dark-background="' . eventchamp_attachment_id( esc_url( $instance['background-image'] ) ) . '"
								custom-title="' . esc_attr( $instance['custom-search-text'] ) . '"
								custom-keyword-text="' . esc_attr( $instance['custom-keyword-text'] ) . '"
								venue-count="' . esc_attr( $instance['venue-count'] ) . '"
								include-venues="' . esc_attr( $instance['include-venues'] ) . '"
								exclude-venues="' . esc_attr( $instance['exclude-venues'] ) . '"
								speaker-count="' . esc_attr( $instance['speaker-count'] ) . '"
								include-speakers="' . esc_attr( $instance['include-speakers'] ) . '"
								exclude-speakers="' . esc_attr( $instance['exclude-speakers'] ) . '"
								custom-tag-text="' . esc_attr( $instance['custom-tag-text'] ) . '"
								price-slider-min-price="' . esc_attr( $instance['price-slider-min-price'] ) . '"
								price-slider-max-price="' . esc_attr( $instance['price-slider-max-price'] ) . '"
								price-slider-from="' . esc_attr( $instance['price-slider-from'] ) . '"
								price-slider-to="' . esc_attr( 	$instance['price-slider-to'] ) . '"
								price-slider-step="' . esc_attr( $instance['price-slider-step'] ) . '"
								price-slider-prefix="' . esc_attr( $instance['price-slider-prefix'] ) . '"
								price-slider-postfix="' . esc_attr( $instance['price-slider-postfix'] ) . '"
								exclude-categories="' . esc_attr( $instance['exclude-categories'] ) . '"
								exclude-locations="' . esc_attr( $instance['exclude-locations'] ) . '"
								exclude-organizers="' . esc_attr( $instance['exclude-organizers'] ) . '"
								include-categories="' . esc_attr( $instance['include-categories'] ) . '"
								include-locations="' . esc_attr( $instance['include-locations'] ) . '"
								include-organizers="' . esc_attr( $instance['include-organizers'] ) . '"
								slider-images="' . esc_attr( $instance['slider-images'] ) . '"
								slider-height="' . esc_attr( $instance['slider-height'] ) . '"
								slider-autoplay-delay=""
								slider-slide-speed=""]' );
						echo '</div>';

					echo eventchamp_widget_after();

				echo $args['after_widget'];

			}

			function update( $new_instance, $old_instance ) {

				$instance = $old_instance;
				$instance['widget-title'] = esc_attr( $new_instance['widget-title'] );
				$instance['style'] = esc_attr( $new_instance['style'] );
				$instance['column'] = esc_attr( $new_instance['column'] );
				$instance['column_space'] = esc_attr( $new_instance['column_space'] );
				$instance['search-title'] = esc_attr( $new_instance['search-title'] );
				$instance['selects-live-search'] = esc_attr( $new_instance['selects-live-search'] );
				$instance['custom-search-text'] = esc_attr( $new_instance['custom-search-text'] );
				$instance['start-date'] = esc_attr( $new_instance['start-date'] );
				$instance['end-date'] = esc_attr( $new_instance['end-date'] );
				$instance['keyword'] = esc_attr( $new_instance['keyword'] );
				$instance['custom-keyword-text'] = esc_attr( $new_instance['custom-keyword-text'] );
				$instance['category'] = esc_attr( $new_instance['category'] );
				$instance['location'] = esc_attr( $new_instance['location'] );
				$instance['venue'] = esc_attr( $new_instance['venue'] );
				$instance['venue-count'] = esc_attr( $new_instance['venue-count'] );
				$instance['include-venues'] = esc_attr( $new_instance['include-venues'] );
				$instance['exclude-venues'] = esc_attr( $new_instance['exclude-venues'] );
				$instance['venue-order'] = esc_attr( $new_instance['venue-order'] );
				$instance['venue-order-type'] = esc_attr( $new_instance['venue-order-type'] );
				$instance['speaker'] = esc_attr( $new_instance['speaker'] );
				$instance['speaker-count'] = esc_attr( $new_instance['speaker-count'] );
				$instance['include-speakers'] = esc_attr( $new_instance['include-speakers'] );
				$instance['exclude-speakers'] = esc_attr( $new_instance['exclude-speakers'] );
				$instance['speaker-order'] = esc_attr( $new_instance['speaker-order'] );
				$instance['speaker-order-type'] = esc_attr( $new_instance['speaker-order-type'] );
				$instance['organizer'] = esc_attr( $new_instance['organizer'] );
				$instance['status'] = esc_attr( $new_instance['status'] );
				$instance['upcoming-status'] = esc_attr( $new_instance['upcoming-status'] );
				$instance['showing-status'] = esc_attr( $new_instance['showing-status'] );
				$instance['expired-status'] = esc_attr( $new_instance['expired-status'] );
				$instance['tag'] = esc_attr( $new_instance['tag'] );
				$instance['custom-tag-text'] = esc_attr( $new_instance['custom-tag-text'] );
				$instance['sort'] = esc_attr( $new_instance['sort'] );
				$instance['sort-start-date'] = esc_attr( $new_instance['sort-start-date'] );
				$instance['sort-end-date'] = esc_attr( $new_instance['sort-end-date'] );
				$instance['sort-added-date'] = esc_attr( $new_instance['sort-added-date'] );
				$instance['sort-name-a-z'] = esc_attr( $new_instance['sort-name-a-z'] );
				$instance['sort-name-z-a'] = esc_attr( $new_instance['sort-name-z-a'] );
				$instance['sort-price-l-h'] = esc_attr( $new_instance['sort-price-l-h'] );
				$instance['sort-price-h-l'] = esc_attr( $new_instance['sort-price-h-l'] );
				$instance['price-slider'] = esc_attr( $new_instance['price-slider'] );
				$instance['price-slider-grid'] = esc_attr( $new_instance['price-slider-grid'] );
				$instance['price-slider-min-price'] = esc_attr( $new_instance['price-slider-min-price'] );
				$instance['price-slider-max-price'] = esc_attr( $new_instance['price-slider-max-price'] );
				$instance['price-slider-from'] = esc_attr( $new_instance['price-slider-from'] );
				$instance['price-slider-to'] = esc_attr( $new_instance['price-slider-to'] );
				$instance['price-slider-step'] = esc_attr( $new_instance['price-slider-step'] );
				$instance['price-slider-min-max'] = esc_attr( $new_instance['price-slider-min-max'] );
				$instance['price-slider-from-to'] = esc_attr( $new_instance['price-slider-from-to'] );
				$instance['price-slider-prefix'] = esc_attr( $new_instance['price-slider-prefix'] );
				$instance['price-slider-postfix'] = esc_attr( $new_instance['price-slider-postfix'] );
				$instance['empty-taxonomies'] = esc_attr( $new_instance['empty-taxonomies'] );
				$instance['childless'] = esc_attr( $new_instance['childless'] );
				$instance['hide-children'] = esc_attr( $new_instance['hide-children'] );
				$instance['exclude-categories'] = esc_attr( $new_instance['exclude-categories'] );
				$instance['exclude-locations'] = esc_attr( $new_instance['exclude-locations'] );
				$instance['exclude-organizers'] = esc_attr( $new_instance['exclude-organizers'] );
				$instance['include-categories'] = esc_attr( $new_instance['include-categories'] );
				$instance['include-locations'] = esc_attr( $new_instance['include-locations'] );
				$instance['include-organizers'] = esc_attr( $new_instance['include-organizers'] );
				$instance['taxonomy-order'] = esc_attr( $new_instance['taxonomy-order'] );
				$instance['taxonomy-order-type'] = esc_attr( $new_instance['taxonomy-order-type'] );
				$instance['background-image'] = esc_url( $new_instance['background-image'] );
				$instance['slider-images'] = esc_attr( $new_instance['slider-images'] );
				$instance['slider-height'] = esc_attr( $new_instance['slider-height'] );

				return $instance;

			}

			function form( $instance ) {

				if( !empty( $instance ) ) {

					$instance['widget-title'] = esc_attr( $instance['widget-title'] );
					$instance['style'] = esc_attr( $instance['style'] );
					$instance['column'] = esc_attr( $instance['column'] );
					$instance['column_space'] = esc_attr( $instance['column_space'] );
					$instance['search-title'] = esc_attr( $instance['search-title'] );
					$instance['custom-search-text'] = esc_attr( $instance['custom-search-text'] );
					$instance['start-date'] = esc_attr( $instance['start-date'] );
					$instance['end-date'] = esc_attr( $instance['end-date'] );
					$instance['keyword'] = esc_attr( $instance['keyword'] );
					$instance['custom-keyword-text'] = esc_attr( $instance['custom-keyword-text'] );
					$instance['category'] = esc_attr( $instance['category'] );
					$instance['location'] = esc_attr( $instance['location'] );
					$instance['venue'] = esc_attr( $instance['venue'] );
					$instance['venue-count'] = esc_attr( $instance['venue-count'] );
					$instance['include-venues'] = esc_attr( $instance['include-venues'] );
					$instance['exclude-venues'] = esc_attr( $instance['exclude-venues'] );
					$instance['venue-order'] = esc_attr( $instance['venue-order'] );
					$instance['venue-order-type'] = esc_attr( $instance['venue-order-type'] );
					$instance['speaker'] = esc_attr( $instance['speaker'] );
					$instance['speaker-count'] = esc_attr( $instance['speaker-count'] );
					$instance['include-speakers'] = esc_attr( $instance['include-speakers'] );
					$instance['exclude-speakers'] = esc_attr( $instance['exclude-speakers'] );
					$instance['speaker-order'] = esc_attr( $instance['speaker-order'] );
					$instance['speaker-order-type'] = esc_attr( $instance['speaker-order-type'] );
					$instance['organizer'] = esc_attr( $instance['organizer'] );
					$instance['status'] = esc_attr( $instance['status'] );
					$instance['upcoming-status'] = esc_attr( $instance['upcoming-status'] );
					$instance['showing-status'] = esc_attr( $instance['showing-status'] );
					$instance['expired-status'] = esc_attr( $instance['expired-status'] );
					$instance['tag'] = esc_attr( $instance['tag'] );
					$instance['custom-tag-text'] = esc_attr( $instance['custom-tag-text'] );
					$instance['sort'] = esc_attr( $instance['sort'] );
					$instance['sort-start-date'] = esc_attr( $instance['sort-start-date'] );
					$instance['sort-end-date'] = esc_attr( $instance['sort-end-date'] );
					$instance['sort-added-date'] = esc_attr( $instance['sort-added-date'] );
					$instance['sort-name-a-z'] = esc_attr( $instance['sort-name-a-z'] );
					$instance['sort-name-z-a'] = esc_attr( $instance['sort-name-z-a'] );
					$instance['sort-price-l-h'] = esc_attr( $instance['sort-price-l-h'] );
					$instance['sort-price-h-l'] = esc_attr( $instance['sort-price-h-l'] );
					$instance['price-slider'] = esc_attr( $instance['price-slider'] );
					$instance['price-slider-grid'] = esc_attr( $instance['price-slider-grid'] );
					$instance['price-slider-min-price'] = esc_attr( $instance['price-slider-min-price'] );
					$instance['price-slider-max-price'] = esc_attr( $instance['price-slider-max-price'] );
					$instance['price-slider-from'] = esc_attr( $instance['price-slider-from'] );
					$instance['price-slider-to'] = esc_attr( $instance['price-slider-to'] );
					$instance['price-slider-step'] = esc_attr( $instance['price-slider-step'] );
					$instance['price-slider-min-max'] = esc_attr( $instance['price-slider-min-max'] );
					$instance['price-slider-from-to'] = esc_attr( $instance['price-slider-from-to'] );
					$instance['price-slider-prefix'] = esc_attr( $instance['price-slider-prefix'] );
					$instance['price-slider-postfix'] = esc_attr( $instance['price-slider-postfix'] );
					$instance['empty-taxonomies'] = esc_attr( $instance['empty-taxonomies'] );
					$instance['childless'] = esc_attr( $instance['childless'] );
					$instance['hide-children'] = esc_attr( $instance['hide-children'] );
					$instance['exclude-categories'] = esc_attr( $instance['exclude-categories'] );
					$instance['exclude-locations'] = esc_attr( $instance['exclude-locations'] );
					$instance['exclude-organizers'] = esc_attr( $instance['exclude-organizers'] );
					$instance['include-categories'] = esc_attr( $instance['include-categories'] );
					$instance['include-locations'] = esc_attr( $instance['include-locations'] );
					$instance['include-organizers'] = esc_attr( $instance['include-organizers'] );
					$instance['taxonomy-order'] = esc_attr( $instance['taxonomy-order'] );
					$instance['taxonomy-order-type'] = esc_attr( $instance['taxonomy-order-type'] );
					$instance['background-image'] = esc_url( $instance['background-image'] );
					$instance['slider-images'] = esc_attr( $instance['slider-images'] );
					$instance['slider-height'] = esc_attr( $instance['slider-height'] );

				} else {

					$instance['widget-title'] = "";
					$instance['style'] = "";
					$instance['column'] = "";
					$instance['column_space'] = "";
					$instance['search-title'] = "";
					$instance['selects-live-search'] = "";
					$instance['custom-search-text'] = "";
					$instance['start-date'] = "";
					$instance['end-date'] = "";
					$instance['keyword'] = "";
					$instance['custom-keyword-text'] = "";
					$instance['category'] = "";
					$instance['location'] = "";
					$instance['venue'] = "";
					$instance['venue-count'] = "";
					$instance['include-venues'] = "";
					$instance['exclude-venues'] = "";
					$instance['venue-order'] = "";
					$instance['venue-order-type'] = "";
					$instance['speaker'] = "";
					$instance['speaker-count'] = "";
					$instance['include-speakers'] = "";
					$instance['exclude-speakers'] = "";
					$instance['speaker-order'] = "";
					$instance['speaker-order-type'] = "";
					$instance['organizer'] = "";
					$instance['status'] = "";
					$instance['upcoming-status'] = "";
					$instance['showing-status'] = "";
					$instance['expired-status'] = "";
					$instance['tag'] = "";
					$instance['custom-tag-text'] = "";
					$instance['sort'] = "";
					$instance['sort-start-date'] = "";
					$instance['sort-end-date'] = "";
					$instance['sort-added-date'] = "";
					$instance['sort-name-a-z'] = "";
					$instance['sort-name-z-a'] = "";
					$instance['sort-price-l-h'] = "";
					$instance['sort-price-h-l'] = "";
					$instance['price-slider'] = "";
					$instance['price-slider-grid'] = "";
					$instance['price-slider-min-price'] = "";
					$instance['price-slider-max-price'] = "";
					$instance['price-slider-from'] = "";
					$instance['price-slider-to'] = "";
					$instance['price-slider-step'] = "";
					$instance['price-slider-min-max'] = "";
					$instance['price-slider-from-to'] = "";
					$instance['price-slider-prefix'] = "";
					$instance['price-slider-postfix'] = "";
					$instance['empty-taxonomies'] = "";
					$instance['childless'] = "";
					$instance['hide-children'] = "";
					$instance['exclude-categories'] = "";
					$instance['exclude-locations'] = "";
					$instance['exclude-organizers'] = "";
					$instance['include-categories'] = "";
					$instance['include-locations'] = "";
					$instance['include-organizers'] = "";
					$instance['taxonomy-order'] = "";
					$instance['taxonomy-order-type'] = "";
					$instance['background-image'] = "";
					$instance['slider-images'] = "";
					$instance['slider-height'] = "";

				}

				echo '<div class="wp-block">';
					echo '<strong>' . esc_html__( 'General', 'eventchamp-core' ) . '</strong>';
					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'widget-title' ) ) . '">' . esc_html__( 'Widget Title', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'widget-title' ) ) . '" name="' . esc_attr( $this->get_field_name( 'widget-title' ) ) . '" type="text" value="' . esc_attr( $instance['widget-title'] ) . '" />';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'style' ) ) . '">' . esc_html__( 'Style', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'style' ) ) . '" id="' . esc_attr( $this->get_field_id( 'style' ) ) . '" class="widefat"> ';
							echo '<option value="white" ' . ( $instance['style'] == "white" ? 'selected' : '' ) . '>' . esc_html__( 'Style 1: Color Background', 'eventchamp-core' ) . '</option>';
							echo '<option value="dark" ' . ( $instance['style'] == "dark" ? 'selected' : '' ) . '>' . esc_html__( 'Style 2: Image Background', 'eventchamp-core' ) . '</option>';
							echo '<option value="style-3" ' . ( $instance['style'] == "style-3" ? 'selected' : '' ) . '>' . esc_html__( 'Style 3: Slider Background', 'eventchamp-core' ) . '</option>';
							echo '<option value="style-4" ' . ( $instance['style'] == "style-4" ? 'selected' : '' ) . '>' . esc_html__( 'Style 4: Pure', 'eventchamp-core' ) . '</option>';
							echo '<option value="style-5" ' . ( $instance['style'] == "style-5" ? 'selected' : '' ) . '>' . esc_html__( 'Style 5: Dark', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'column' ) ) . '">' . esc_html__( 'Column', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'column' ) ) . '" id="' . esc_attr( $this->get_field_id( 'column' ) ) . '" class="widefat"> ';
							echo '<option value="1" ' . ( $instance['column'] == "1" ? 'selected' : '' ) . '>' . esc_html__( 'Column 1', 'eventchamp-core' ) . '</option>';
							echo '<option value="2" ' . ( $instance['column'] == "2" ? 'selected' : '' ) . '>' . esc_html__( 'Column 2', 'eventchamp-core' ) . '</option>';
							echo '<option value="3" ' . ( $instance['column'] == "3" ? 'selected' : '' ) . '>' . esc_html__( 'Column 3', 'eventchamp-core' ) . '</option>';
							echo '<option value="4" ' . ( $instance['column'] == "4" ? 'selected' : '' ) . '>' . esc_html__( 'Column 4', 'eventchamp-core' ) . '</option>';
							echo '<option value="5" ' . ( $instance['column'] == "5" ? 'selected' : '' ) . '>' . esc_html__( 'Column 5', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'column_space' ) ) . '">' . esc_html__( 'Column Space', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'column_space' ) ) . '" id="' . esc_attr( $this->get_field_id( 'column_space' ) ) . '" class="widefat"> ';
							echo '<option value="0" ' . ( $instance['column_space'] == "0" ? 'selected' : '' ) . '>' . esc_html__( '0', 'eventchamp-core' ) . '</option>';
							echo '<option value="5" ' . ( $instance['column_space'] == "5" ? 'selected' : '' ) . '>' . esc_html__( '5', 'eventchamp-core' ) . '</option>';
							echo '<option value="10" ' . ( $instance['column_space'] == "10" ? 'selected' : '' ) . '>' . esc_html__( '10', 'eventchamp-core' ) . '</option>';
							echo '<option value="15" ' . ( $instance['column_space'] == "15" ? 'selected' : '' ) . '>' . esc_html__( '15', 'eventchamp-core' ) . '</option>';
							echo '<option value="20" ' . ( $instance['column_space'] == "20" ? 'selected' : '' ) . '>' . esc_html__( '20', 'eventchamp-core' ) . '</option>';
							echo '<option value="25" ' . ( $instance['column_space'] == "25" ? 'selected' : '' ) . '>' . esc_html__( '25', 'eventchamp-core' ) . '</option>';
							echo '<option value="30" ' . ( $instance['column_space'] == "30" ? 'selected' : '' ) . '>' . esc_html__( '30', 'eventchamp-core' ) . '</option>';
							echo '<option value="35" ' . ( $instance['column_space'] == "35" ? 'selected' : '' ) . '>' . esc_html__( '35', 'eventchamp-core' ) . '</option>';
							echo '<option value="40" ' . ( $instance['column_space'] == "40" ? 'selected' : '' ) . '>' . esc_html__( '40', 'eventchamp-core' ) . '</option>';
							echo '<option value="45" ' . ( $instance['column_space'] == "45" ? 'selected' : '' ) . '>' . esc_html__( '45', 'eventchamp-core' ) . '</option>';
							echo '<option value="50" ' . ( $instance['column_space'] == "50" ? 'selected' : '' ) . '>' . esc_html__( '50', 'eventchamp-core' ) . '</option>';
							echo '<option value="55" ' . ( $instance['column_space'] == "55" ? 'selected' : '' ) . '>' . esc_html__( '55', 'eventchamp-core' ) . '</option>';
							echo '<option value="60" ' . ( $instance['column_space'] == "60" ? 'selected' : '' ) . '>' . esc_html__( '60', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';
				echo '</div>';

				echo '<div class="wp-block">';
					echo '<strong>' . esc_html__( 'Fields', 'eventchamp-core' ) . '</strong>';
					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'selects-live-search' ) ) . '">' . esc_html__( 'Live Search for Selects', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'selects-live-search' ) ) . '" id="' . esc_attr( $this->get_field_id( 'selects-live-search' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['selects-live-search'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['selects-live-search'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'search-title' ) ) . '">' . esc_html__( 'Search Title', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'search-title' ) ) . '" id="' . esc_attr( $this->get_field_id( 'search-title' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['search-title'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['search-title'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'custom-search-text' ) ) . '">' . esc_html__( 'Custom Search Text', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'custom-search-text' ) ) . '" name="' . esc_attr( $this->get_field_name( 'custom-search-text' ) ) . '" type="text" value="' . esc_attr( $instance['custom-search-text'] ) . '" />';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'start-date' ) ) . '">' . esc_html__( 'Start Date', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'start-date' ) ) . '" id="' . esc_attr( $this->get_field_id( 'start-date' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['start-date'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['start-date'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'end-date' ) ) . '">' . esc_html__( 'End Date', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'end-date' ) ) . '" id="' . esc_attr( $this->get_field_id( 'end-date' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['end-date'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['end-date'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'keyword' ) ) . '">' . esc_html__( 'Keyword', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'keyword' ) ) . '" id="' . esc_attr( $this->get_field_id( 'keyword' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['keyword'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['keyword'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'custom-keyword-text' ) ) . '">' . esc_html__( 'Custom Keyword Text', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'custom-keyword-text' ) ) . '" name="' . esc_attr( $this->get_field_name( 'custom-keyword-text' ) ) . '" type="text" value="' . esc_attr( $instance['custom-keyword-text'] ) . '" />';
						echo '<i>' . esc_html__( 'You can enter a text. Default: e.g. event, meetup', 'eventchamp-core' ) . '</i>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'category' ) ) . '">' . esc_html__( 'Category', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'category' ) ) . '" id="' . esc_attr( $this->get_field_id( 'category' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['category'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['category'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'location' ) ) . '">' . esc_html__( 'Locations', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'location' ) ) . '" id="' . esc_attr( $this->get_field_id( 'location' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['location'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['location'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'venue' ) ) . '">' . esc_html__( 'Venues', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'venue' ) ) . '" id="' . esc_attr( $this->get_field_id( 'venue' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['venue'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['venue'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'venue-count' ) ) . '">' . esc_html__( 'Venue Count', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'venue-count' ) ) . '" name="' . esc_attr( $this->get_field_name( 'venue-count' ) ) . '" type="text" value="' . esc_attr( $instance['venue-count'] ) . '" />';
						echo '<i>' . esc_html__( 'You can enter an venue count.', 'eventchamp-core' ) . '</i>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'include-venues' ) ) . '">' . esc_html__( 'Include Venues', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'include-venues' ) ) . '" name="' . esc_attr( $this->get_field_name( 'include-venues' ) ) . '" type="text" value="' . esc_attr( $instance['include-venues'] ) . '" />';
						echo '<i>' . esc_html__( 'You can enter venue ids. Example: 1,2,3 etc.', 'eventchamp-core' ) . '</i>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'exclude-venues' ) ) . '">' . esc_html__( 'Exclude Venues', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'exclude-venues' ) ) . '" name="' . esc_attr( $this->get_field_name( 'exclude-venues' ) ) . '" type="text" value="' . esc_attr( $instance['exclude-venues'] ) . '" />';
						echo '<i>' . esc_html__( 'You can enter venue ids. Example: 1,2,3 etc.', 'eventchamp-core' ) . '</i>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'venue-order' ) ) . '">' . esc_html__( 'Venue Order', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'venue-order' ) ) . '" id="' . esc_attr( $this->get_field_id( 'venue-order' ) ) . '" class="widefat"> ';
							echo '<option value="DESC" ' . ( $instance['venue-order'] == "DESC" ? 'selected' : '' ) . '>' . esc_html__( 'DESC', 'eventchamp-core' ) . '</option>';
							echo '<option value="ASC" ' . ( $instance['venue-order'] == "ASC" ? 'selected' : '' ) . '>' . esc_html__( 'ASC', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'venue-order-type' ) ) . '">' . esc_html__( 'Venue Order Type', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'venue-order-type' ) ) . '" id="' . esc_attr( $this->get_field_id( 'venue-order-type' ) ) . '" class="widefat"> ';
							echo '<option value="added-date" ' . ( $instance['venue-order-type'] == "added-date" ? 'selected' : '' ) . '>' . esc_html__( 'Added Date', 'eventchamp-core' ) . '</option>';
							echo '<option value="popular-comment" ' . ( $instance['venue-order-type'] == "popular-comment" ? 'selected' : '' ) . '>' . esc_html__( 'Popular by Comments', 'eventchamp-core' ) . '</option>';
							echo '<option value="id" ' . ( $instance['venue-order-type'] == "id" ? 'selected' : '' ) . '>' . esc_html__( 'ID', 'eventchamp-core' ) . '</option>';
							echo '<option value="title" ' . ( $instance['venue-order-type'] == "title" ? 'selected' : '' ) . '>' . esc_html__( 'Title', 'eventchamp-core' ) . '</option>';
							echo '<option value="menu_order" ' . ( $instance['venue-order-type'] == "menu_order" ? 'selected' : '' ) . '>' . esc_html__( 'Menu Order', 'eventchamp-core' ) . '</option>';
							echo '<option value="rand" ' . ( $instance['venue-order-type'] == "rand" ? 'selected' : '' ) . '>' . esc_html__( 'Random', 'eventchamp-core' ) . '</option>';
							echo '<option value="post__in" ' . ( $instance['speaker-order-type'] == "post__in" ? 'selected' : '' ) . '>' . esc_html__( 'By Include IDs', 'eventchamp-core' ) . '</option>';
							echo '<option value="none" ' . ( $instance['venue-order-type'] == "none" ? 'selected' : '' ) . '>' . esc_html__( 'None', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'speaker' ) ) . '">' . esc_html__( 'Speakers', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'speaker' ) ) . '" id="' . esc_attr( $this->get_field_id( 'speaker' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['speaker'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['speaker'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'speaker-count' ) ) . '">' . esc_html__( 'Speaker Count', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'speaker-count' ) ) . '" name="' . esc_attr( $this->get_field_name( 'speaker-count' ) ) . '" type="text" value="' . esc_attr( $instance['speaker-count'] ) . '" />';
						echo '<i>' . esc_html__( 'You can enter an speaker count.', 'eventchamp-core' ) . '</i>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'include-speakers' ) ) . '">' . esc_html__( 'Include Speakers', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'include-speakers' ) ) . '" name="' . esc_attr( $this->get_field_name( 'include-speakers' ) ) . '" type="text" value="' . esc_attr( $instance['include-speakers'] ) . '" />';
						echo '<i>' . esc_html__( 'You can enter speaker ids. Example: 1,2,3 etc.', 'eventchamp-core' ) . '</i>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'exclude-speakers' ) ) . '">' . esc_html__( 'Exclude Speakers', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'exclude-speakers' ) ) . '" name="' . esc_attr( $this->get_field_name( 'exclude-speakers' ) ) . '" type="text" value="' . esc_attr( $instance['exclude-speakers'] ) . '" />';
						echo '<i>' . esc_html__( 'You can enter speaker ids. Example: 1,2,3 etc.', 'eventchamp-core' ) . '</i>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'speaker-order' ) ) . '">' . esc_html__( 'Speaker Order', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'speaker-order' ) ) . '" id="' . esc_attr( $this->get_field_id( 'speaker-order' ) ) . '" class="widefat"> ';
							echo '<option value="DESC" ' . ( $instance['speaker-order'] == "DESC" ? 'selected' : '' ) . '>' . esc_html__( 'DESC', 'eventchamp-core' ) . '</option>';
							echo '<option value="ASC" ' . ( $instance['speaker-order'] == "ASC" ? 'selected' : '' ) . '>' . esc_html__( 'ASC', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'speaker-order-type' ) ) . '">' . esc_html__( 'Speaker Order Type', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'speaker-order-type' ) ) . '" id="' . esc_attr( $this->get_field_id( 'speaker-order-type' ) ) . '" class="widefat"> ';
							echo '<option value="added-date" ' . ( $instance['speaker-order-type'] == "added-date" ? 'selected' : '' ) . '>' . esc_html__( 'Added Date', 'eventchamp-core' ) . '</option>';
							echo '<option value="popular-comment" ' . ( $instance['speaker-order-type'] == "popular-comment" ? 'selected' : '' ) . '>' . esc_html__( 'Popular by Comments', 'eventchamp-core' ) . '</option>';
							echo '<option value="id" ' . ( $instance['speaker-order-type'] == "id" ? 'selected' : '' ) . '>' . esc_html__( 'ID', 'eventchamp-core' ) . '</option>';
							echo '<option value="title" ' . ( $instance['speaker-order-type'] == "title" ? 'selected' : '' ) . '>' . esc_html__( 'Title', 'eventchamp-core' ) . '</option>';
							echo '<option value="menu_order" ' . ( $instance['speaker-order-type'] == "menu_order" ? 'selected' : '' ) . '>' . esc_html__( 'Menu Order', 'eventchamp-core' ) . '</option>';
							echo '<option value="rand" ' . ( $instance['speaker-order-type'] == "rand" ? 'selected' : '' ) . '>' . esc_html__( 'Random', 'eventchamp-core' ) . '</option>';
							echo '<option value="post__in" ' . ( $instance['speaker-order-type'] == "post__in" ? 'selected' : '' ) . '>' . esc_html__( 'By Include IDs', 'eventchamp-core' ) . '</option>';
							echo '<option value="none" ' . ( $instance['speaker-order-type'] == "none" ? 'selected' : '' ) . '>' . esc_html__( 'None', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'organizer' ) ) . '">' . esc_html__( 'Organizers', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'organizer' ) ) . '" id="' . esc_attr( $this->get_field_id( 'organizer' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['organizer'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['organizer'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'status' ) ) . '">' . esc_html__( 'Status', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'status' ) ) . '" id="' . esc_attr( $this->get_field_id( 'status' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['status'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['status'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'upcoming-status' ) ) . '">' . esc_html__( 'Upcoming for the Status', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'upcoming-status' ) ) . '" id="' . esc_attr( $this->get_field_id( 'upcoming-status' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['upcoming-status'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['upcoming-status'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'showing-status' ) ) . '">' . esc_html__( 'Upcoming for the Status', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'showing-status' ) ) . '" id="' . esc_attr( $this->get_field_id( 'showing-status' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['showing-status'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['showing-status'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'expired-status' ) ) . '">' . esc_html__( 'Upcoming for the Status', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'expired-status' ) ) . '" id="' . esc_attr( $this->get_field_id( 'expired-status' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['expired-status'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['expired-status'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'tag' ) ) . '">' . esc_html__( 'Tag', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'tag' ) ) . '" id="' . esc_attr( $this->get_field_id( 'tag' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['tag'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['tag'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'custom-tag-text' ) ) . '">' . esc_html__( 'Custom Tag Text', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'custom-tag-text' ) ) . '" name="' . esc_attr( $this->get_field_name( 'custom-tag-text' ) ) . '" type="text" value="' . esc_attr( $instance['custom-tag-text'] ) . '" />';
						echo '<i>' . esc_html__( 'You can enter a tag text. Enter a tag: art, food', 'eventchamp-core' ) . '</i>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'sort' ) ) . '">' . esc_html__( 'Sort', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'sort' ) ) . '" id="' . esc_attr( $this->get_field_id( 'sort' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['sort'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['sort'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'sort-start-date' ) ) . '">' . esc_html__( 'Sort: Start Date', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'sort-start-date' ) ) . '" id="' . esc_attr( $this->get_field_id( 'sort-start-date' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['sort-start-date'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['sort-start-date'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'sort-end-date' ) ) . '">' . esc_html__( 'Sort: End Date', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'sort-end-date' ) ) . '" id="' . esc_attr( $this->get_field_id( 'sort-end-date' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['sort-end-date'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['sort-end-date'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'sort-added-date' ) ) . '">' . esc_html__( 'Sort: Added Date', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'sort-added-date' ) ) . '" id="' . esc_attr( $this->get_field_id( 'sort-added-date' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['sort-added-date'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['sort-added-date'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'sort-name-a-z' ) ) . '">' . esc_html__( 'Sort: Name A > Z', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'sort-name-a-z' ) ) . '" id="' . esc_attr( $this->get_field_id( 'sort-name-a-z' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['sort-name-a-z'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['sort-name-a-z'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'sort-name-z-a' ) ) . '">' . esc_html__( 'Sort: Name A > Z', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'sort-name-z-a' ) ) . '" id="' . esc_attr( $this->get_field_id( 'sort-name-z-a' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['sort-name-z-a'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['sort-name-z-a'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'sort-price-l-h' ) ) . '">' . esc_html__( 'Sort: Price Low to High', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'sort-price-l-h' ) ) . '" id="' . esc_attr( $this->get_field_id( 'sort-price-l-h' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['sort-price-l-h'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['sort-price-l-h'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'sort-price-h-l' ) ) . '">' . esc_html__( 'Sort: Price High to Low', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'sort-price-h-l' ) ) . '" id="' . esc_attr( $this->get_field_id( 'sort-price-h-l' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['sort-price-h-l'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['sort-price-h-l'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'price-slider' ) ) . '">' . esc_html__( 'Price Slider', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'price-slider' ) ) . '" id="' . esc_attr( $this->get_field_id( 'price-slider' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['price-slider'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['price-slider'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'price-slider-grid' ) ) . '">' . esc_html__( 'Grid for the Price Slider', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'price-slider-grid' ) ) . '" id="' . esc_attr( $this->get_field_id( 'price-slider-grid' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['price-slider-grid'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['price-slider-grid'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'price-slider-min-price' ) ) . '">' . esc_html__( 'Min Price for the Price Slider', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'price-slider-min-price' ) ) . '" name="' . esc_attr( $this->get_field_name( 'price-slider-min-price' ) ) . '" type="text" value="' . esc_attr( $instance['price-slider-min-price'] ) . '" />';
						echo '<i>' . esc_html__( 'You can enter a min price for the price slider. Default: 0', 'eventchamp-core' ) . '</i>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'price-slider-max-price' ) ) . '">' . esc_html__( 'Max Price for the Price Slider', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'price-slider-max-price' ) ) . '" name="' . esc_attr( $this->get_field_name( 'price-slider-max-price' ) ) . '" type="text" value="' . esc_attr( $instance['price-slider-max-price'] ) . '" />';
						echo '<i>' . esc_html__( 'You can enter a max price for the price slider. Default: 999', 'eventchamp-core' ) . '</i>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'price-slider-from' ) ) . '">' . esc_html__( 'From Price for the Price Slider', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'price-slider-from' ) ) . '" name="' . esc_attr( $this->get_field_name( 'price-slider-from' ) ) . '" type="text" value="' . esc_attr( $instance['price-slider-from'] ) . '" />';
						echo '<i>' . esc_html__( 'You can enter a from price for the price slider. Set start position for left handle (or for single handle). Default: 0', 'eventchamp-core' ) . '</i>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'price-slider-to' ) ) . '">' . esc_html__( 'To Price for the Price Slider', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'price-slider-to' ) ) . '" name="' . esc_attr( $this->get_field_name( 'price-slider-to' ) ) . '" type="text" value="' . esc_attr( $instance['price-slider-to'] ) . '" />';
						echo '<i>' . esc_html__( 'You can enter a to price for the price slider. Set start position for right handle. Default: 299', 'eventchamp-core' ) . '</i>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'price-slider-step' ) ) . '">' . esc_html__( 'Step for the Price Slider', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'price-slider-step' ) ) . '" name="' . esc_attr( $this->get_field_name( 'price-slider-step' ) ) . '" type="text" value="' . esc_attr( $instance['price-slider-step'] ) . '" />';
						echo '<i>' . esc_html__( 'You can enter a step for the price slider. Set sliders step. Always > 0. Could be fractional. Default: 1', 'eventchamp-core' ) . '</i>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'price-slider-min-max' ) ) . '">' . esc_html__( 'Hide Min-Max Label for the Price Slider', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'price-slider-min-max' ) ) . '" id="' . esc_attr( $this->get_field_id( 'price-slider-min-max' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['price-slider-min-max'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['price-slider-min-max'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'price-slider-from-to' ) ) . '">' . esc_html__( 'Hide From-To Label for the Price Slider', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'price-slider-from-to' ) ) . '" id="' . esc_attr( $this->get_field_id( 'price-slider-from-to' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['price-slider-min-max'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['price-slider-min-max'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'price-slider-prefix' ) ) . '">' . esc_html__( 'Prefix for the Price Slider', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'price-slider-prefix' ) ) . '" name="' . esc_attr( $this->get_field_name( 'price-slider-prefix' ) ) . '" type="text" value="' . esc_attr( $instance['price-slider-prefix'] ) . '" />';
						echo '<i>' . esc_html__( 'You can enter a prefix text. Will be set up right before the number. Example: $100', 'eventchamp-core' ) . '</i>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'price-slider-postfix' ) ) . '">' . esc_html__( 'Postfix for the Price Slider', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'price-slider-postfix' ) ) . '" name="' . esc_attr( $this->get_field_name( 'price-slider-postfix' ) ) . '" type="text" value="' . esc_attr( $instance['price-slider-postfix'] ) . '" />';
						echo '<i>' . esc_html__( 'You can enter a postfix text. Will be set up right after the number. Example: 100k', 'eventchamp-core' ) . '</i>';
					echo '</p>';
				echo '</div>';

				echo '<div class="wp-block">';
					echo '<strong>' . esc_html__( 'Taxonomies', 'eventchamp-core' ) . '</strong>';
					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'empty-taxonomies' ) ) . '">' . esc_html__( 'Empty Taxonomies', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'empty-taxonomies' ) ) . '" id="' . esc_attr( $this->get_field_id( 'empty-taxonomies' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['empty-taxonomies'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['empty-taxonomies'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
						echo '<i>' . esc_html__( 'You can choose visible status of the empty taxonomies. If you choose true option empty taxonomies will be hide.', 'eventchamp-core' ) . '</i>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'childless' ) ) . '">' . esc_html__( 'Childless', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'childless' ) ) . '" id="' . esc_attr( $this->get_field_id( 'childless' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['childless'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['childless'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'hide-children' ) ) . '">' . esc_html__( 'Hide Children', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'hide-children' ) ) . '" id="' . esc_attr( $this->get_field_id( 'hide-children' ) ) . '" class="widefat"> ';
							echo '<option value="false" ' . ( $instance['hide-children'] == "false" ? 'selected' : '' ) . '>' . esc_html__( 'False', 'eventchamp-core' ) . '</option>';
							echo '<option value="true" ' . ( $instance['hide-children'] == "true" ? 'selected' : '' ) . '>' . esc_html__( 'True', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'exclude-categories' ) ) . '">' . esc_html__( 'Exclude Categories', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'exclude-categories' ) ) . '" name="' . esc_attr( $this->get_field_name( 'exclude-categories' ) ) . '" type="text" value="' . esc_attr( $instance['exclude-categories'] ) . '" />';
						echo '<i>' . esc_html__( 'You can enter category ids. Example: 1,2,3 etc.', 'eventchamp-core' ) . '</i>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'exclude-locations' ) ) . '">' . esc_html__( 'Exclude Locations', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'exclude-locations' ) ) . '" name="' . esc_attr( $this->get_field_name( 'exclude-locations' ) ) . '" type="text" value="' . esc_attr( $instance['exclude-locations'] ) . '" />';
						echo '<i>' . esc_html__( 'You can enter location ids. Separate with commas. Example: 1,2,3 etc.', 'eventchamp-core' ) . '</i>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'exclude-organizers' ) ) . '">' . esc_html__( 'Exclude Organizers', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'exclude-organizers' ) ) . '" name="' . esc_attr( $this->get_field_name( 'exclude-organizers' ) ) . '" type="text" value="' . esc_attr( $instance['exclude-organizers'] ) . '" />';
						echo '<i>' . esc_html__( 'You can enter organizer ids. Separate with commas. Example: 1,2,3 etc.', 'eventchamp-core' ) . '</i>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'include-categories' ) ) . '">' . esc_html__( 'Include Categories', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'include-categories' ) ) . '" name="' . esc_attr( $this->get_field_name( 'include-categories' ) ) . '" type="text" value="' . esc_attr( $instance['include-categories'] ) . '" />';
						echo '<i>' . esc_html__( 'You can enter category ids. Example: 1, 2, 3 etc. If you have sub categories, it will work only for parents.', 'eventchamp-core' ) . '</i>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'include-locations' ) ) . '">' . esc_html__( 'Include Locations', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'include-locations' ) ) . '" name="' . esc_attr( $this->get_field_name( 'include-locations' ) ) . '" type="text" value="' . esc_attr( $instance['include-locations'] ) . '" />';
						echo '<i>' . esc_html__( 'You can enter location ids. Separate with commas. Example: 1,2,3 etc. If you have sub locations, it will work only for parents.', 'eventchamp-core' ) . '</i>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'include-organizers' ) ) . '">' . esc_html__( 'Include Organizers', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'include-organizers' ) ) . '" name="' . esc_attr( $this->get_field_name( 'include-organizers' ) ) . '" type="text" value="' . esc_attr( $instance['include-organizers'] ) . '" />';
						echo '<i>' . esc_html__( 'You can enter organizer ids. Separate with commas. Example: 1,2,3 etc. If you have sub organizers, it will work only for parents.', 'eventchamp-core' ) . '</i>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'taxonomy-order' ) ) . '">' . esc_html__( 'Taxonomy Order', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'taxonomy-order' ) ) . '" id="' . esc_attr( $this->get_field_id( 'taxonomy-order' ) ) . '" class="widefat"> ';
							echo '<option value="ASC" ' . ( $instance['taxonomy-order'] == "ASC" ? 'selected' : '' ) . '>' . esc_html__( 'ASC', 'eventchamp-core' ) . '</option>';
							echo '<option value="DESC" ' . ( $instance['taxonomy-order'] == "DESC" ? 'selected' : '' ) . '>' . esc_html__( 'DESC', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'taxonomy-order-type' ) ) . '">' . esc_html__( 'Taxonomy Order Type', 'eventchamp-core' ) . '</label>';
						echo '<select name="' . esc_attr( $this->get_field_name( 'taxonomy-order-type' ) ) . '" id="' . esc_attr( $this->get_field_id( 'taxonomy-order-type' ) ) . '" class="widefat"> ';
							echo '<option value="name" ' . ( $instance['taxonomy-order-type'] == "name" ? 'selected' : '' ) . '>' . esc_html__( 'Name', 'eventchamp-core' ) . '</option>';
							echo '<option value="slug" ' . ( $instance['taxonomy-order-type'] == "slug" ? 'selected' : '' ) . '>' . esc_html__( 'Slug', 'eventchamp-core' ) . '</option>';
							echo '<option value="term_group" ' . ( $instance['taxonomy-order-type'] == "term_group" ? 'selected' : '' ) . '>' . esc_html__( 'Term Group', 'eventchamp-core' ) . '</option>';
							echo '<option value="term_id" ' . ( $instance['taxonomy-order-type'] == "term_id" ? 'selected' : '' ) . '>' . esc_html__( 'Term ID', 'eventchamp-core' ) . '</option>';
							echo '<option value="id" ' . ( $instance['taxonomy-order-type'] == "id" ? 'selected' : '' ) . '>' . esc_html__( 'ID', 'eventchamp-core' ) . '</option>';
							echo '<option value="description" ' . ( $instance['taxonomy-order-type'] == "description" ? 'selected' : '' ) . '>' . esc_html__( 'Description', 'eventchamp-core' ) . '</option>';
							echo '<option value="parent" ' . ( $instance['taxonomy-order-type'] == "parent" ? 'selected' : '' ) . '>' . esc_html__( 'Parent', 'eventchamp-core' ) . '</option>';
							echo '<option value="count" ' . ( $instance['taxonomy-order-type'] == "count" ? 'selected' : '' ) . '>' . esc_html__( 'Count', 'eventchamp-core' ) . '</option>';
						echo '</select>';
					echo '</p>';
				echo '</div>';

				echo '<div class="wp-block">';
					echo '<strong>' . esc_html__( 'Design', 'eventchamp-core' ) . '</strong>';
					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'background-image' ) ) . '">' . esc_html__( 'Background Image for Style 2', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'background-image' ) ) . '" name="' . esc_attr( $this->get_field_name( 'background-image' ) ) . '" type="text" value="' . esc_url( $instance['background-image'] ) . '" />';
						echo '<i>' . esc_html__( 'You can enter a background image url for the style 2.', 'eventchamp-core' ) . '</i>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'slider-images' ) ) . '">' . esc_html__( 'Slider Images IDs for Style 3', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'slider-images' ) ) . '" name="' . esc_attr( $this->get_field_name( 'slider-images' ) ) . '" type="text" value="' . esc_attr( $instance['slider-images'] ) . '" />';
						echo '<i>' . esc_html__( 'You can enter image IDs for the style 3. After uploading the images to the media page, you can find the IDs from that page. Example: 305, 369, 296', 'eventchamp-core' ) . '</i>';
					echo '</p>';

					echo '<p>';
						echo '<label for="' . esc_attr( $this->get_field_id( 'slider-height' ) ) . '">' . esc_html__( 'Slider Height', 'eventchamp-core' ) . '</label>';
						echo '<input class="widefat" id="' . esc_attr( $this->get_field_id( 'slider-height' ) ) . '" name="' . esc_attr( $this->get_field_name( 'slider-height' ) ) . '" type="text" value="' . esc_attr( $instance['slider-height'] ) . '" />';
						echo '<i>' . esc_html__( 'If you use the style 3, enter a slider height. Example: 600px. If enter blank, it will have full height.', 'eventchamp-core' ) . '</i>';
					echo '</p>';
				echo '</div>';



			}

		}

	}