<?php
/**
* Plugin Name: Eventchamp Elements
* Plugin URI: https://themeforest.net/user/gloriathemes
* Description: The elements of Eventchamp theme is exists in the plugin.
* Version: 1.8.1
* Author: Gloria Themes
* Author URI: https://gloriathemes.com/
*/


if( !defined( 'ABSPATH' ) ) {

	exit; // Exit if accessed directly

}

final class eventchamp_core_plugin {


	/*====== Constants ======*/
	const VERSION = '1.8.1';
	const MINIMUM_PHP_VERSION = '7.4';

	/*====== Constructor ======*/
	public function __construct() {

		/*====== OptionTree Settings ======*/
		if( class_exists( 'OT_Loader' ) ) {

			add_filter( 'ot_show_new_layout', '__return_false' );
			add_filter( 'ot_show_pages', '__return_false' );
			add_filter( 'ot_show_settings_import', '__return_true' );
			add_filter( 'ot_show_settings_export', '__return_true' );
			add_filter( 'ot_theme_options_parent_slug', '__return_false' );

			require_once ( dirname( __FILE__ ) . '/theme-options-extended.php' );
			require_once ( dirname( __FILE__ ) . '/theme-options.php' );

		}

		/*====== Init Plugin ======*/
		add_action( 'after_setup_theme', array( $this, 'init' ), 999 );

	}

	/*====== Initialize The Plugin ======*/
	public function init() {

		/*====== Load Textdomain ======*/
		load_plugin_textdomain( 'eventchamp-core' );

		/*====== Check PHP Version ======*/
		if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {

			add_action( 'admin_notices', array( $this, 'admin_notice_minimum_php_version' ) );

			return;

		}

		$event_system = ot_get_option( 'event-system', 'eventchamp' );

		/*====== Main Files ======*/
		require_once ( dirname( __FILE__ ) . '/user-social-media.php' );
		require_once ( dirname( __FILE__ ) . '/custom-post-types.php' );

		if( $event_system == "eventchamp" ) {

			require_once ( dirname( __FILE__ ) . '/post-types.php' );

		}

		/*====== Special Theme Files ======*/
		if( get_option( 'stylesheet' ) == 'eventchamp' or get_option( 'stylesheet' ) == 'eventchamp-child' ) {

			if( function_exists( 'vc_map' ) ) {

				function eventchamp_wpbakery_extensions() {

					$event_system = ot_get_option( 'event-system', 'eventchamp' );

					if( eventchamp_license_check() === true ) {

						require_once ( dirname( __FILE__ ) . '/wpbakery/elements/eventchamp-slider.php' );

						if( $event_system == "eventchamp" ) {

							require_once ( dirname( __FILE__ ) . '/wpbakery/elements/events-slider.php' );
							require_once ( dirname( __FILE__ ) . '/wpbakery/elements/event-search-tool.php' );
							require_once ( dirname( __FILE__ ) . '/wpbakery/elements/event-search-results.php' );
							require_once ( dirname( __FILE__ ) . '/wpbakery/elements/event-listing.php' );
							require_once ( dirname( __FILE__ ) . '/wpbakery/elements/categorized-events.php' );
							require_once ( dirname( __FILE__ ) . '/wpbakery/elements/events-carousel.php' );
							require_once ( dirname( __FILE__ ) . '/wpbakery/elements/events-map.php' );
							require_once ( dirname( __FILE__ ) . '/wpbakery/elements/events-calendar.php' );
							require_once ( dirname( __FILE__ ) . '/wpbakery/elements/get-an-event-content.php' );
							require_once ( dirname( __FILE__ ) . '/wpbakery/elements/speaker-listing.php' );
							require_once ( dirname( __FILE__ ) . '/wpbakery/elements/categorized-speakers.php' );
							require_once ( dirname( __FILE__ ) . '/wpbakery/elements/venue-listing.php' );
							require_once ( dirname( __FILE__ ) . '/wpbakery/elements/categorized-venues.php' );
							require_once ( dirname( __FILE__ ) . '/wpbakery/elements/venues-carousel.php' );
							require_once ( dirname( __FILE__ ) . '/wpbakery/elements/sponsors.php' );
							require_once ( dirname( __FILE__ ) . '/wpbakery/elements/organizers.php' );
							require_once ( dirname( __FILE__ ) . '/wpbakery/elements/tags.php' );
							require_once ( dirname( __FILE__ ) . '/wpbakery/elements/categories.php' );
							require_once ( dirname( __FILE__ ) . '/wpbakery/elements/user-activity.php' );

						} elseif( $event_system == "the-events-calendar" ) {

							if( class_exists( 'Tribe__Events__Main' ) ) {

								require_once ( dirname( __FILE__ ) . '/wpbakery/elements/the-events-calendar-events.php' );

							}

						}

						require_once ( dirname( __FILE__ ) . '/wpbakery/elements/banner-box.php' );
						require_once ( dirname( __FILE__ ) . '/wpbakery/elements/feature-box.php' );
						require_once ( dirname( __FILE__ ) . '/wpbakery/elements/service-box.php' );
						require_once ( dirname( __FILE__ ) . '/wpbakery/elements/blog-listing.php' );
						require_once ( dirname( __FILE__ ) . '/wpbakery/elements/blog-carousel.php' );
						require_once ( dirname( __FILE__ ) . '/wpbakery/elements/testimonials.php' );
						require_once ( dirname( __FILE__ ) . '/wpbakery/elements/contact-box.php' );
						require_once ( dirname( __FILE__ ) . '/wpbakery/elements/app-box.php' );
						require_once ( dirname( __FILE__ ) . '/wpbakery/elements/faq.php' );
						require_once ( dirname( __FILE__ ) . '/wpbakery/elements/icon-list.php' );
						require_once ( dirname( __FILE__ ) . '/wpbakery/elements/image-gallery.php' );
						require_once ( dirname( __FILE__ ) . '/wpbakery/elements/button.php' );
						require_once ( dirname( __FILE__ ) . '/wpbakery/elements/modal-button.php' );
						require_once ( dirname( __FILE__ ) . '/wpbakery/elements/heading.php' );
						require_once ( dirname( __FILE__ ) . '/wpbakery/elements/counter.php' );
						require_once ( dirname( __FILE__ ) . '/wpbakery/elements/countdown.php' );
						require_once ( dirname( __FILE__ ) . '/wpbakery/elements/countdown-slider.php' );
						require_once ( dirname( __FILE__ ) . '/wpbakery/elements/google-maps.php' );
						require_once ( dirname( __FILE__ ) . '/wpbakery/elements/mailchimp-newsletter.php' );
						require_once ( dirname( __FILE__ ) . '/wpbakery/elements/social-links.php' );
						require_once ( dirname( __FILE__ ) . '/wpbakery/template-studio.php' );

					}

				}
				add_action( 'init', 'eventchamp_wpbakery_extensions', 10, 2 );
		 
			}

			require_once ( dirname( __FILE__ ) . '/widgets/blog.php' );

			if( $event_system == "eventchamp" ) {

				require_once ( dirname( __FILE__ ) . '/like-system.php' );
				require_once ( dirname( __FILE__ ) . '/favorite-system.php' );
				require_once ( dirname( __FILE__ ) . '/widgets/events.php' );
				require_once ( dirname( __FILE__ ) . '/widgets/event-search.php' );
				require_once ( dirname( __FILE__ ) . '/widgets/speakers.php' );
				require_once ( dirname( __FILE__ ) . '/widgets/venues.php' );

			}

		}

	}

	/*====== PHP Version Admin Notice ======*/
	public function admin_notice_minimum_php_version() {

		if ( isset( $_GET['activate'] ) ) {

			unset( $_GET['activate'] );

		}

		$message = sprintf( esc_html__( '%1$s requires %2$s version must be %3$s or greater.', 'eventchamp-core' ), '<strong>' . esc_html__( 'Eventchamp Core', 'eventchamp-core' ) . '</strong>', '<strong>' . esc_html__( 'PHP', 'eventchamp-core' ) . '</strong>', self::MINIMUM_PHP_VERSION );

		printf( '<div class="notice notice-warning is-dismissible">%1$s</div>', wpautop( $message ) );

	}

}
new eventchamp_core_plugin();