<?php
/*======
*
* Post Types
*
======*/
	/*====== Events ======*/
	if( !function_exists( 'eventchamp_events_post_type' ) ) {

		function eventchamp_events_post_type() {

			$labels = array(
				'name' => esc_html__( 'Events', 'eventchamp-core' ),
				'singular_name' => esc_html__( 'Event', 'eventchamp-core' ),
				'menu_name' => esc_html__( 'Events', 'eventchamp-core' ),
				'parent_item_colon' => esc_html__( 'Parent Event:', 'eventchamp-core' ),
				'all_items' => esc_html__( 'All Events', 'eventchamp-core' ),
				'view_item' => esc_html__( 'View Event', 'eventchamp-core' ),
				'add_new_item' => esc_html__( 'Add New Event Item', 'eventchamp-core' ),
				'add_new' => esc_html__( 'Add New Event', 'eventchamp-core' ),
				'edit_item' => esc_html__( 'Edit Event', 'eventchamp-core' ),
				'update_item' => esc_html__( 'Update Event', 'eventchamp-core' ),
				'search_items' => esc_html__( 'Search Event', 'eventchamp-core' ),
				'not_found' => esc_html__( 'Not Event Found', 'eventchamp-core' ),
				'not_found_in_trash' => esc_html__( 'Not Event Found in Trash', 'eventchamp-core' ),
			);
			$args = array(
				'label' => esc_html__( 'Events', 'eventchamp-core' ),
				'description' => esc_html__( 'Event post type description.', 'eventchamp-core' ),
				'labels' => $labels,
				'supports' => array( 'title', 'comments', 'author', 'excerpt', 'thumbnail', 'revisions', 'editor', 'custom-fields' ),
				'show_in_rest' => true,
				'hierarchical' => false,
				'public' => true,
				'show_ui' => true,
				'show_in_menu' => true,
				'show_in_nav_menus' => true,
				'show_in_admin_bar' => true,
				'menu_position' => 20,
				'menu_icon' => 'dashicons-calendar-alt',
				'can_export' => true,
				'has_archive' => true,
				'exclude_from_search' => false,
				'publicly_queryable' => true,
				'capability_type' => 'post',
			);
			register_post_type( 'event', $args );

		}
		add_action( 'init', 'eventchamp_events_post_type', 0 );

	}



	/*====== Venues ======*/
	if( !function_exists( 'eventchamp_venues_post_type' ) ) {

		function eventchamp_venues_post_type() {

			$labels = array(
				'name' => esc_html__( 'Venues', 'eventchamp-core' ),
				'singular_name' => esc_html__( 'Venue', 'eventchamp-core' ),
				'menu_name' => esc_html__( 'Venues', 'eventchamp-core' ),
				'parent_item_colon' => esc_html__( 'Parent Venue:', 'eventchamp-core' ),
				'all_items' => esc_html__( 'All Venues', 'eventchamp-core' ),
				'view_item' => esc_html__( 'View Venue', 'eventchamp-core' ),
				'add_new_item' => esc_html__( 'Add New Venue Item', 'eventchamp-core' ),
				'add_new' => esc_html__( 'Add New Venue', 'eventchamp-core' ),
				'edit_item' => esc_html__( 'Edit Venue', 'eventchamp-core' ),
				'update_item' => esc_html__( 'Update Venue', 'eventchamp-core' ),
				'search_items' => esc_html__( 'Search Venue', 'eventchamp-core' ),
				'not_found' => esc_html__( 'Not Venue Found', 'eventchamp-core' ),
				'not_found_in_trash' => esc_html__( 'Not Venue Found in Trash', 'eventchamp-core' ),
			);
			$args = array(
				'label' => esc_html__( 'Venues', 'eventchamp-core' ),
				'description' => esc_html__( 'Venue post type description.', 'eventchamp-core' ),
				'labels' => $labels,
				'supports' => array( 'title', 'comments', 'author', 'excerpt', 'thumbnail', 'revisions', 'editor', 'custom-fields' ),
				'show_in_rest' => true,
				'hierarchical' => false,
				'public' => true,
				'show_ui' => true,
				'show_in_menu' => true,
				'show_in_nav_menus' => true,
				'show_in_admin_bar' => true,
				'menu_position' => 20,
				'menu_icon' => 'dashicons-store',
				'can_export' => true,
				'has_archive' => true,
				'exclude_from_search' => false,
				'publicly_queryable' => true,
				'capability_type' => 'post',
			);
			register_post_type( 'venue', $args );

		}
		add_action( 'init', 'eventchamp_venues_post_type', 0 );

	}



	/*====== Speakers ======*/
	if( !function_exists( 'eventchamp_speakers_post_type' ) ) {

		function eventchamp_speakers_post_type() {

			$labels = array(
				'name' => esc_html__( 'Speakers', 'eventchamp-core' ),
				'singular_name' => esc_html__( 'Speaker', 'eventchamp-core' ),
				'menu_name' => esc_html__( 'Speakers', 'eventchamp-core' ),
				'parent_item_colon' => esc_html__( 'Parent Speaker:', 'eventchamp-core' ),
				'all_items' => esc_html__( 'All Speakers', 'eventchamp-core' ),
				'view_item' => esc_html__( 'View Speaker', 'eventchamp-core' ),
				'add_new_item' => esc_html__( 'Add New Speaker Item', 'eventchamp-core' ),
				'add_new' => esc_html__( 'Add New Speaker', 'eventchamp-core' ),
				'edit_item' => esc_html__( 'Edit Speaker', 'eventchamp-core' ),
				'update_item' => esc_html__( 'Update Speaker', 'eventchamp-core' ),
				'search_items' => esc_html__( 'Search Speaker', 'eventchamp-core' ),
				'not_found' => esc_html__( 'Not Speaker Found', 'eventchamp-core' ),
				'not_found_in_trash' => esc_html__( 'Not Speaker Found in Trash', 'eventchamp-core' ),
			);
			$args = array(
				'label' => esc_html__( 'Speakers', 'eventchamp-core' ),
				'description' => esc_html__( 'Speaker post type description.', 'eventchamp-core' ),
				'labels' => $labels,
				'supports' => array( 'title', 'comments', 'author', 'excerpt', 'thumbnail', 'revisions', 'editor', 'custom-fields' ),
				'show_in_rest' => true,
				'hierarchical' => false,
				'public' => true,
				'show_ui' => true,
				'show_in_menu' => true,
				'show_in_nav_menus' => true,
				'show_in_admin_bar' => true,
				'menu_position' => 20,
				'menu_icon' => 'dashicons-microphone',
				'can_export' => true,
				'has_archive' => true,
				'exclude_from_search' => false,
				'publicly_queryable' => true,
				'capability_type' => 'post',
			);
			register_post_type( 'speaker', $args );

		} 
		add_action( 'init', 'eventchamp_speakers_post_type', 0 );

	}



/*======
*
* Taxonomies
*
======*/
	/*====== Event Categories ======*/
	if( !function_exists( 'eventchamp_eventcat_taxonomy' ) ) {

		function eventchamp_eventcat_taxonomy() {

			$labels = array(
				'name' => esc_html__( 'Categories', 'eventchamp-core' ),
				'singular_name' => esc_html__( 'Category', 'eventchamp-core' ),
				'menu_name' => esc_html__( 'Categories', 'eventchamp-core' ),
				'all_items' => esc_html__( 'All Categories', 'eventchamp-core' ),
				'parent_item' => esc_html__( 'Parent Category', 'eventchamp-core' ),
				'parent_item_colon' => esc_html__( 'Parent Category:', 'eventchamp-core' ),
				'new_item_name' => esc_html__( 'New Category Name', 'eventchamp-core' ),
				'add_new_item' => esc_html__( 'Add New Category', 'eventchamp-core' ),
				'edit_item' => esc_html__( 'Edit Category', 'eventchamp-core' ),
				'view_item' => esc_html__( 'View Category', 'eventchamp-core' ),
				'update_item' => esc_html__( 'Update Category', 'eventchamp-core' ),
				'separate_items_with_commas' => esc_html__( 'Separate categories with commas', 'eventchamp-core' ),
				'search_items' => esc_html__( 'Search Categories', 'eventchamp-core' ),
				'add_or_remove_items' => esc_html__( 'Add or remove categories', 'eventchamp-core' ),
				'choose_from_most_used' => esc_html__( 'Choose from the most used categories', 'eventchamp-core' ),
				'not_found' => esc_html__( 'Not Found', 'eventchamp-core' ),
			);
			$args = array(
				'labels' => $labels,
				'hierarchical' => true,
				'public' => true,
				'show_ui' => true,
				'show_admin_column' => true,
				'show_in_nav_menus' => true,
				'show_tagcloud' => true,
				'show_in_rest' => true,
			);
			register_taxonomy( 'eventcat', array( 'event'), $args );

		}
		add_action( 'init', 'eventchamp_eventcat_taxonomy', 0 );

	}



	/*====== Event Organizers ======*/
	if( !function_exists( 'eventchamp_organizer_taxonomy' ) ) {

		function eventchamp_organizer_taxonomy() {

			$labels = array(
				'name' => esc_html__( 'Organizers', 'eventchamp-core' ),
				'singular_name' => esc_html__( 'Organizer', 'eventchamp-core' ),
				'menu_name' => esc_html__( 'Organizers', 'eventchamp-core' ),
				'all_items' => esc_html__( 'All Organizers', 'eventchamp-core' ),
				'parent_item' => esc_html__( 'Parent Organizer', 'eventchamp-core' ),
				'parent_item_colon' => esc_html__( 'Parent Organizer:', 'eventchamp-core' ),
				'new_item_name' => esc_html__( 'New Organizer Name', 'eventchamp-core' ),
				'add_new_item' => esc_html__( 'Add New Organizer', 'eventchamp-core' ),
				'edit_item' => esc_html__( 'Edit Organizer', 'eventchamp-core' ),
				'view_item' => esc_html__( 'View Organizer', 'eventchamp-core' ),
				'update_item' => esc_html__( 'Update Organizer', 'eventchamp-core' ),
				'separate_items_with_commas' => esc_html__( 'Separate organizers with commas', 'eventchamp-core' ),
				'search_items' => esc_html__( 'Search Organizers', 'eventchamp-core' ),
				'add_or_remove_items' => esc_html__( 'Add or remove organizers', 'eventchamp-core' ),
				'choose_from_most_used' => esc_html__( 'Choose from the most used organizers', 'eventchamp-core' ),
				'not_found' => esc_html__( 'Not Found', 'eventchamp-core' ),
			);
			$args = array(
				'labels' => $labels,
				'hierarchical' => true,
				'public' => true,
				'show_ui' => true,
				'show_admin_column' => true,
				'show_in_nav_menus' => true,
				'show_tagcloud' => true,
				'show_in_rest' => true,
			);
			register_taxonomy( 'organizer', array( 'event' ), $args );

		}
		add_action( 'init', 'eventchamp_organizer_taxonomy', 0 );

	}



	/*====== Event Tags ======*/
	if( !function_exists( 'eventchamp_event_tags_taxonomy' ) ) {

		function eventchamp_event_tags_taxonomy() {

			$labels = array(
				'name' => esc_html__( 'Tags', 'eventchamp-core' ),
				'singular_name' => esc_html__( 'Tag', 'eventchamp-core' ),
				'menu_name' => esc_html__( 'Tags', 'eventchamp-core' ),
				'all_items' => esc_html__( 'All Tags', 'eventchamp-core' ),
				'parent_item' => esc_html__( 'Parent Tag', 'eventchamp-core' ),
				'parent_item_colon' => esc_html__( 'Parent Tag:', 'eventchamp-core' ),
				'new_item_name' => esc_html__( 'New Tag Name', 'eventchamp-core' ),
				'add_new_item' => esc_html__( 'Add New Tag', 'eventchamp-core' ),
				'edit_item' => esc_html__( 'Edit Tag', 'eventchamp-core' ),
				'view_item' => esc_html__( 'View Tag', 'eventchamp-core' ),
				'update_item' => esc_html__( 'Update Tag', 'eventchamp-core' ),
				'separate_items_with_commas' => esc_html__( 'Separate tags with commas', 'eventchamp-core' ),
				'search_items' => esc_html__( 'Search Tags', 'eventchamp-core' ),
				'add_or_remove_items' => esc_html__( 'Add or remove tags', 'eventchamp-core' ),
				'choose_from_most_used' => esc_html__( 'Choose from the most used tags', 'eventchamp-core' ),
				'not_found' => esc_html__( 'Not Found', 'eventchamp-core' ),
			);
			$args = array(
				'labels' => $labels,
				'hierarchical' => true,
				'public' => true,
				'show_ui' => true,
				'show_admin_column' => true,
				'show_in_nav_menus' => true,
				'show_tagcloud' => true,
				'show_in_rest' => true,
			);
			register_taxonomy( 'event_tags', array( 'event' ), $args );

		}
		add_action( 'init', 'eventchamp_event_tags_taxonomy', 0 );

	}



	/*====== Venue Categories ======*/
	if( !function_exists( 'eventchamp_venuecat_taxonomy' ) ) {

		function eventchamp_venuecat_taxonomy() {

			$labels = array(
				'name' => esc_html__( 'Categories', 'eventchamp-core' ),
				'singular_name' => esc_html__( 'Category', 'eventchamp-core' ),
				'menu_name' => esc_html__( 'Categories', 'eventchamp-core' ),
				'all_items' => esc_html__( 'All Categories', 'eventchamp-core' ),
				'parent_item' => esc_html__( 'Parent Category', 'eventchamp-core' ),
				'parent_item_colon' => esc_html__( 'Parent Category:', 'eventchamp-core' ),
				'new_item_name' => esc_html__( 'New Category Name', 'eventchamp-core' ),
				'add_new_item' => esc_html__( 'Add New Category', 'eventchamp-core' ),
				'edit_item' => esc_html__( 'Edit Category', 'eventchamp-core' ),
				'view_item' => esc_html__( 'View Category', 'eventchamp-core' ),
				'update_item' => esc_html__( 'Update Category', 'eventchamp-core' ),
				'separate_items_with_commas' => esc_html__( 'Separate categories with commas', 'eventchamp-core' ),
				'search_items' => esc_html__( 'Search Categories', 'eventchamp-core' ),
				'add_or_remove_items' => esc_html__( 'Add or remove categories', 'eventchamp-core' ),
				'choose_from_most_used' => esc_html__( 'Choose from the most used categories', 'eventchamp-core' ),
				'not_found' => esc_html__( 'Not Found', 'eventchamp-core' ),
			);
			$args = array(
				'labels' => $labels,
				'hierarchical' => true,
				'public' => true,
				'show_ui' => true,
				'show_admin_column' => true,
				'show_in_nav_menus' => true,
				'show_tagcloud' => true,
				'show_in_rest' => true,
			);
			register_taxonomy( 'venuecat', array( 'venue'), $args );

		}
		add_action( 'init', 'eventchamp_venuecat_taxonomy', 0 );

	}



	/*====== Venue Tags ======*/
	if( !function_exists( 'eventchamp_venue_tags_taxonomy' ) ) {

		function eventchamp_venue_tags_taxonomy() {

			$labels = array(
				'name' => esc_html__( 'Tags', 'eventchamp-core' ),
				'singular_name' => esc_html__( 'Tag', 'eventchamp-core' ),
				'menu_name' => esc_html__( 'Tags', 'eventchamp-core' ),
				'all_items' => esc_html__( 'All Tags', 'eventchamp-core' ),
				'parent_item' => esc_html__( 'Parent Tag', 'eventchamp-core' ),
				'parent_item_colon' => esc_html__( 'Parent Tag:', 'eventchamp-core' ),
				'new_item_name' => esc_html__( 'New Tag Name', 'eventchamp-core' ),
				'add_new_item' => esc_html__( 'Add New Tag', 'eventchamp-core' ),
				'edit_item' => esc_html__( 'Edit Tag', 'eventchamp-core' ),
				'view_item' => esc_html__( 'View Tag', 'eventchamp-core' ),
				'update_item' => esc_html__( 'Update Tag', 'eventchamp-core' ),
				'separate_items_with_commas' => esc_html__( 'Separate tags with commas', 'eventchamp-core' ),
				'search_items' => esc_html__( 'Search Tags', 'eventchamp-core' ),
				'add_or_remove_items' => esc_html__( 'Add or remove tags', 'eventchamp-core' ),
				'choose_from_most_used' => esc_html__( 'Choose from the most used tags', 'eventchamp-core' ),
				'not_found' => esc_html__( 'Not Found', 'eventchamp-core' ),
			);
			$args = array(
				'labels' => $labels,
				'hierarchical' => true,
				'public' => true,
				'show_ui' => true,
				'show_admin_column' => true,
				'show_in_nav_menus' => true,
				'show_tagcloud' => true,
				'show_in_rest' => true,
			);
			register_taxonomy( 'venue_tags', array( 'venue' ), $args );

		}
		add_action( 'init', 'eventchamp_venue_tags_taxonomy', 0 );

	}



	/*====== Speaker Categories ======*/
	if( !function_exists( 'eventchamp_speaker_category_taxonomy' ) ) {

		function eventchamp_speaker_category_taxonomy() {

			$labels = array(
				'name' => esc_html__( 'Categories', 'eventchamp-core' ),
				'singular_name' => esc_html__( 'Category', 'eventchamp-core' ),
				'menu_name' => esc_html__( 'Categories', 'eventchamp-core' ),
				'all_items' => esc_html__( 'All Categories', 'eventchamp-core' ),
				'parent_item' => esc_html__( 'Parent Category', 'eventchamp-core' ),
				'parent_item_colon' => esc_html__( 'Parent Category:', 'eventchamp-core' ),
				'new_item_name' => esc_html__( 'New Category Name', 'eventchamp-core' ),
				'add_new_item' => esc_html__( 'Add New Category', 'eventchamp-core' ),
				'edit_item' => esc_html__( 'Edit Category', 'eventchamp-core' ),
				'view_item' => esc_html__( 'View Category', 'eventchamp-core' ),
				'update_item' => esc_html__( 'Update Category', 'eventchamp-core' ),
				'separate_items_with_commas' => esc_html__( 'Separate categories with commas', 'eventchamp-core' ),
				'search_items' => esc_html__( 'Search Categories', 'eventchamp-core' ),
				'add_or_remove_items' => esc_html__( 'Add or remove categories', 'eventchamp-core' ),
				'choose_from_most_used' => esc_html__( 'Choose from the most used categories', 'eventchamp-core' ),
				'not_found' => esc_html__( 'Not Found', 'eventchamp-core' ),
			);
			$args = array(
				'labels' => $labels,
				'hierarchical' => true,
				'public' => true,
				'show_ui' => true,
				'show_admin_column' => true,
				'show_in_nav_menus' => true,
				'show_tagcloud' => true,
				'show_in_rest' => true,
			);
			register_taxonomy( 'speaker-category', array( 'speaker'), $args );

		}
		add_action( 'init', 'eventchamp_speaker_category_taxonomy', 0 );

	}



	/*====== Speaker Tags ======*/
	if( !function_exists( 'eventchamp_speaker_tags_taxonomy' ) ) {

		function eventchamp_speaker_tags_taxonomy() {

			$labels = array(
				'name' => esc_html__( 'Tags', 'eventchamp-core' ),
				'singular_name' => esc_html__( 'Tag', 'eventchamp-core' ),
				'menu_name' => esc_html__( 'Tags', 'eventchamp-core' ),
				'all_items' => esc_html__( 'All Tags', 'eventchamp-core' ),
				'parent_item' => esc_html__( 'Parent Tag', 'eventchamp-core' ),
				'parent_item_colon' => esc_html__( 'Parent Tag:', 'eventchamp-core' ),
				'new_item_name' => esc_html__( 'New Tag Name', 'eventchamp-core' ),
				'add_new_item' => esc_html__( 'Add New Tag', 'eventchamp-core' ),
				'edit_item' => esc_html__( 'Edit Tag', 'eventchamp-core' ),
				'view_item' => esc_html__( 'View Tag', 'eventchamp-core' ),
				'update_item' => esc_html__( 'Update Tag', 'eventchamp-core' ),
				'separate_items_with_commas' => esc_html__( 'Separate tags with commas', 'eventchamp-core' ),
				'search_items' => esc_html__( 'Search Tags', 'eventchamp-core' ),
				'add_or_remove_items' => esc_html__( 'Add or remove tags', 'eventchamp-core' ),
				'choose_from_most_used' => esc_html__( 'Choose from the most used tags', 'eventchamp-core' ),
				'not_found' => esc_html__( 'Not Found', 'eventchamp-core' ),
			);
			$args = array(
				'labels' => $labels,
				'hierarchical' => true,
				'public' => true,
				'show_ui' => true,
				'show_admin_column' => true,
				'show_in_nav_menus' => true,
				'show_tagcloud' => true,
				'show_in_rest' => true,
			);
			register_taxonomy( 'speaker-tags', array( 'speaker' ), $args );

		}
		add_action( 'init', 'eventchamp_speaker_tags_taxonomy', 0 );

	}



	/*====== Global Locations ======*/
	if( !function_exists( 'eventchamp_location_taxonomy' ) ) {

		function eventchamp_location_taxonomy() {

			$labels = array(
				'name' => esc_html__( 'Locations', 'eventchamp-core' ),
				'singular_name' => esc_html__( 'Location', 'eventchamp-core' ),
				'menu_name' => esc_html__( 'Locations', 'eventchamp-core' ),
				'all_items' => esc_html__( 'All Locations', 'eventchamp-core' ),
				'parent_item' => esc_html__( 'Parent Location', 'eventchamp-core' ),
				'parent_item_colon' => esc_html__( 'Parent Location:', 'eventchamp-core' ),
				'new_item_name' => esc_html__( 'New Location Name', 'eventchamp-core' ),
				'add_new_item' => esc_html__( 'Add New Location', 'eventchamp-core' ),
				'edit_item' => esc_html__( 'Edit Location', 'eventchamp-core' ),
				'view_item' => esc_html__( 'View Location', 'eventchamp-core' ),
				'update_item' => esc_html__( 'Update Location', 'eventchamp-core' ),
				'separate_items_with_commas' => esc_html__( 'Separate locations with commas', 'eventchamp-core' ),
				'search_items' => esc_html__( 'Search Locations', 'eventchamp-core' ),
				'add_or_remove_items' => esc_html__( 'Add or remove locations', 'eventchamp-core' ),
				'choose_from_most_used' => esc_html__( 'Choose from the most used locations', 'eventchamp-core' ),
				'not_found' => esc_html__( 'Not Found', 'eventchamp-core' ),
			);
			$args = array(
				'labels' => $labels,
				'hierarchical' => true,
				'public' => true,
				'show_ui' => true,
				'show_admin_column' => true,
				'show_in_nav_menus' => true,
				'show_tagcloud' => true,
				'show_in_rest' => true,
			);
			register_taxonomy( 'location', array( 'event', 'venue', 'speaker' ), $args );

		}
		add_action( 'init', 'eventchamp_location_taxonomy', 0 );

	}